/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain;

import com.eucalyptus.cloudwatch.backend.CloudWatchException;
import com.eucalyptus.cloudwatch.backend.InvalidNextTokenException;
import com.eucalyptus.cloudwatch.backend.InvalidParameterValueException;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class NextTokenUtils {
    private NextTokenUtils() {
    }

    public static Date getNextTokenCreatedTime(String nextToken, Class<? extends AbstractPersistent> clazz, boolean throwsNextTokenException) throws CloudWatchException {
        Date nextTokenCreated = null;
        if (nextToken != null) {
            Criteria nextTokenCriteria = Entities.createCriteria(clazz);
            nextTokenCriteria.add((Criterion)Restrictions.eq((String)"naturalId", (Object)nextToken));
            AbstractPersistent nextTokenEntity = (AbstractPersistent)nextTokenCriteria.uniqueResult();
            if (nextTokenEntity != null) {
                nextTokenCreated = nextTokenEntity.getCreationTimestamp();
            } else {
                if (throwsNextTokenException) {
                    throw new InvalidNextTokenException("The token '" + nextToken + "' was invalid");
                }
                throw new InvalidParameterValueException("Invalid nextToken");
            }
        }
        return nextTokenCreated;
    }

    public static Criteria addNextTokenConstraints(Integer maxRecords, String nextToken, Date nextTokenCreated, Criteria criteria) {
        if (nextTokenCreated != null) {
            Disjunction or = Restrictions.disjunction();
            or.add((Criterion)Restrictions.gt((String)"creationTimestamp", (Object)nextTokenCreated));
            Conjunction and = Restrictions.conjunction();
            and.add((Criterion)Restrictions.eq((String)"creationTimestamp", (Object)nextTokenCreated));
            and.add((Criterion)Restrictions.gt((String)"naturalId", (Object)nextToken));
            or.add((Criterion)and);
            criteria.add((Criterion)or);
        }
        criteria.addOrder(Order.asc((String)"creationTimestamp"));
        criteria.addOrder(Order.asc((String)"naturalId"));
        if (maxRecords != null) {
            criteria.setMaxResults(maxRecords.intValue());
        }
        return criteria;
    }
}

