/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cloudwatch.common.CloudWatchBackend;
import com.eucalyptus.cloudwatch.domain.absolute.AbsoluteMetricHelper;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmManager;
import com.eucalyptus.cloudwatch.domain.listmetrics.ListMetricManager;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricManager;
import com.eucalyptus.component.Topology;
import java.util.Date;
import org.apache.log4j.Logger;

public class DBCleanupService
implements Runnable {
    Logger LOG = Logger.getLogger(DBCleanupService.class);

    @Override
    public void run() {
        this.LOG.info((Object)"Calling cloudwatch db cleanup service");
        if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabled(CloudWatchBackend.class)) {
            this.LOG.info((Object)"Cloudwatch service is not ENABLED");
            return;
        }
        Date twoWeeksAgo = new Date(System.currentTimeMillis() - 1209600000L);
        try {
            MetricManager.deleteMetrics(twoWeeksAgo);
        }
        catch (Exception ex) {
            this.LOG.error((Object)ex);
            this.LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            ListMetricManager.deleteMetrics(twoWeeksAgo);
        }
        catch (Exception ex) {
            this.LOG.error((Object)ex);
            this.LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            AlarmManager.deleteAlarmHistory(twoWeeksAgo);
        }
        catch (Exception ex) {
            this.LOG.error((Object)ex);
            this.LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            AbsoluteMetricHelper.deleteAbsoluteMetricHistory(twoWeeksAgo);
        }
        catch (Exception ex) {
            this.LOG.error((Object)ex);
            this.LOG.error((Object)ex, (Throwable)ex);
        }
        this.LOG.info((Object)"Done cleaning up cloudwatch db");
    }
}

