/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.domain;

import com.eucalyptus.cloudwatch.domain.DimensionEntity;
import com.eucalyptus.entities.AbstractPersistent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.apache.log4j.Logger;

@MappedSuperclass
public class AbstractPersistentWithDimensions
extends AbstractPersistent {
    public static final int MAX_DIM_NUM = 10;
    private static final Logger LOG = Logger.getLogger(AbstractPersistentWithDimensions.class);
    @Column(name="dim_1_name")
    private String dim1Name;
    @Column(name="dim_2_name")
    private String dim2Name;
    @Column(name="dim_3_name")
    private String dim3Name;
    @Column(name="dim_4_name")
    private String dim4Name;
    @Column(name="dim_5_name")
    private String dim5Name;
    @Column(name="dim_6_name")
    private String dim6Name;
    @Column(name="dim_7_name")
    private String dim7Name;
    @Column(name="dim_8_name")
    private String dim8Name;
    @Column(name="dim_9_name")
    private String dim9Name;
    @Column(name="dim_10_name")
    private String dim10Name;
    @Column(name="dim_1_value")
    private String dim1Value;
    @Column(name="dim_2_value")
    private String dim2Value;
    @Column(name="dim_3_value")
    private String dim3Value;
    @Column(name="dim_4_value")
    private String dim4Value;
    @Column(name="dim_5_value")
    private String dim5Value;
    @Column(name="dim_6_value")
    private String dim6Value;
    @Column(name="dim_7_value")
    private String dim7Value;
    @Column(name="dim_8_value")
    private String dim8Value;
    @Column(name="dim_9_value")
    private String dim9Value;
    @Column(name="dim_10_value")
    private String dim10Value;

    public Collection<DimensionEntity> getDimensions() {
        TreeSet<DimensionEntity> dimensions = new TreeSet<DimensionEntity>();
        for (int dimNum = 1; dimNum <= 10; ++dimNum) {
            String dimName = this.getDimName(dimNum);
            String dimValue = this.getDimValue(dimNum);
            if (dimName == null || dimValue == null) continue;
            dimensions.add(new DimensionEntity(dimName, dimValue));
        }
        return dimensions;
    }

    public Map<String, String> getDimensionMap() {
        TreeMap<String, String> dimensionMap = new TreeMap<String, String>();
        for (DimensionEntity entity : this.getDimensions()) {
            dimensionMap.put(entity.getName(), entity.getValue());
        }
        return dimensionMap;
    }

    public void setDimensions(Collection<DimensionEntity> dimensions) {
        if (dimensions != null && dimensions.size() > 10) {
            throw new IllegalArgumentException("Too many dimensions, " + dimensions.size());
        }
        for (int dimNum = 1; dimNum <= 10; ++dimNum) {
            this.setDimName(dimNum, null);
            this.setDimValue(dimNum, null);
        }
        if (dimensions == null) {
            return;
        }
        dimensions = new TreeSet<DimensionEntity>(dimensions);
        Iterator<DimensionEntity> iter = dimensions.iterator();
        DimensionEntity d = null;
        for (int dimNum = 1; dimNum <= 10; ++dimNum) {
            if (!iter.hasNext()) {
                return;
            }
            d = iter.next();
            this.setDimName(dimNum, d.getName());
            this.setDimValue(dimNum, d.getValue());
        }
    }

    public String getDim1Name() {
        return this.dim1Name;
    }

    public void setDim1Name(String dim1Name) {
        this.dim1Name = dim1Name;
    }

    public String getDim2Name() {
        return this.dim2Name;
    }

    public void setDim2Name(String dim2Name) {
        this.dim2Name = dim2Name;
    }

    public String getDim3Name() {
        return this.dim3Name;
    }

    public void setDim3Name(String dim3Name) {
        this.dim3Name = dim3Name;
    }

    public String getDim4Name() {
        return this.dim4Name;
    }

    public void setDim4Name(String dim4Name) {
        this.dim4Name = dim4Name;
    }

    public String getDim5Name() {
        return this.dim5Name;
    }

    public void setDim5Name(String dim5Name) {
        this.dim5Name = dim5Name;
    }

    public String getDim6Name() {
        return this.dim6Name;
    }

    public void setDim6Name(String dim6Name) {
        this.dim6Name = dim6Name;
    }

    public String getDim7Name() {
        return this.dim7Name;
    }

    public void setDim7Name(String dim7Name) {
        this.dim7Name = dim7Name;
    }

    public String getDim8Name() {
        return this.dim8Name;
    }

    public void setDim8Name(String dim8Name) {
        this.dim8Name = dim8Name;
    }

    public String getDim9Name() {
        return this.dim9Name;
    }

    public void setDim9Name(String dim9Name) {
        this.dim9Name = dim9Name;
    }

    public String getDim10Name() {
        return this.dim10Name;
    }

    public void setDim10Name(String dim10Name) {
        this.dim10Name = dim10Name;
    }

    public String getDim1Value() {
        return this.dim1Value;
    }

    public void setDim1Value(String dim1Value) {
        this.dim1Value = dim1Value;
    }

    public String getDim2Value() {
        return this.dim2Value;
    }

    public void setDim2Value(String dim2Value) {
        this.dim2Value = dim2Value;
    }

    public String getDim3Value() {
        return this.dim3Value;
    }

    public void setDim3Value(String dim3Value) {
        this.dim3Value = dim3Value;
    }

    public String getDim4Value() {
        return this.dim4Value;
    }

    public void setDim4Value(String dim4Value) {
        this.dim4Value = dim4Value;
    }

    public String getDim5Value() {
        return this.dim5Value;
    }

    public void setDim5Value(String dim5Value) {
        this.dim5Value = dim5Value;
    }

    public String getDim6Value() {
        return this.dim6Value;
    }

    public void setDim6Value(String dim6Value) {
        this.dim6Value = dim6Value;
    }

    public String getDim7Value() {
        return this.dim7Value;
    }

    public void setDim7Value(String dim7Value) {
        this.dim7Value = dim7Value;
    }

    public String getDim8Value() {
        return this.dim8Value;
    }

    public void setDim8Value(String dim8Value) {
        this.dim8Value = dim8Value;
    }

    public String getDim9Value() {
        return this.dim9Value;
    }

    public void setDim9Value(String dim9Value) {
        this.dim9Value = dim9Value;
    }

    public String getDim10Value() {
        return this.dim10Value;
    }

    public void setDim10Value(String dim10Value) {
        this.dim10Value = dim10Value;
    }

    private void setDimName(int dimNum, String value) {
        try {
            if (dimNum < 1 || dimNum > 10) {
                throw new IllegalArgumentException("No such method");
            }
            Method m = ((Object)((Object)this)).getClass().getMethod("setDim" + dimNum + "Name", String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to invoke setDim" + dimNum + "Name, method may not exist"));
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private void setDimValue(int dimNum, String value) {
        try {
            if (dimNum < 1 || dimNum > 10) {
                throw new IllegalArgumentException("No such method");
            }
            Method m = ((Object)((Object)this)).getClass().getMethod("setDim" + dimNum + "Value", String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to invoke setDim" + dimNum + "Value, method may not exist"));
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private String getDimName(int dimNum) {
        try {
            if (dimNum < 1 || dimNum > 10) {
                throw new IllegalArgumentException("No such method");
            }
            Method m = ((Object)((Object)this)).getClass().getMethod("getDim" + dimNum + "Name", new Class[0]);
            return (String)m.invoke((Object)this, new Object[0]);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to invoke setDim" + dimNum + "Name, method may not exist"));
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    private String getDimValue(int dimNum) {
        try {
            if (dimNum < 1 || dimNum > 10) {
                throw new IllegalArgumentException("No such method");
            }
            Method m = ((Object)((Object)this)).getClass().getMethod("getDim" + dimNum + "Value", new Class[0]);
            return (String)m.invoke((Object)this, new Object[0]);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to invoke setDim" + dimNum + "Value, method may not exist"));
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }
}

