/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.backend;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloudwatch.backend.CloudWatchException;
import com.eucalyptus.cloudwatch.backend.InternalFailureException;
import com.eucalyptus.cloudwatch.backend.InvalidFormatException;
import com.eucalyptus.cloudwatch.backend.InvalidParameterCombinationException;
import com.eucalyptus.cloudwatch.backend.InvalidParameterValueException;
import com.eucalyptus.cloudwatch.backend.LimitExceededException;
import com.eucalyptus.cloudwatch.backend.MissingParameterException;
import com.eucalyptus.cloudwatch.backend.ServiceDisabledException;
import com.eucalyptus.cloudwatch.backend.TransformationFunctions;
import com.eucalyptus.cloudwatch.common.CloudWatchBackend;
import com.eucalyptus.cloudwatch.common.CloudWatchMetadata;
import com.eucalyptus.cloudwatch.common.backend.msgs.AlarmHistoryItems;
import com.eucalyptus.cloudwatch.common.backend.msgs.AlarmNames;
import com.eucalyptus.cloudwatch.common.backend.msgs.Datapoint;
import com.eucalyptus.cloudwatch.common.backend.msgs.Datapoints;
import com.eucalyptus.cloudwatch.common.backend.msgs.DeleteAlarmsResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DeleteAlarmsType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DescribeAlarmHistoryResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DescribeAlarmHistoryType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DescribeAlarmsForMetricResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DescribeAlarmsForMetricType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DescribeAlarmsResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DescribeAlarmsType;
import com.eucalyptus.cloudwatch.common.backend.msgs.Dimension;
import com.eucalyptus.cloudwatch.common.backend.msgs.DimensionFilter;
import com.eucalyptus.cloudwatch.common.backend.msgs.DimensionFilters;
import com.eucalyptus.cloudwatch.common.backend.msgs.Dimensions;
import com.eucalyptus.cloudwatch.common.backend.msgs.DisableAlarmActionsResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.DisableAlarmActionsType;
import com.eucalyptus.cloudwatch.common.backend.msgs.EnableAlarmActionsResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.EnableAlarmActionsType;
import com.eucalyptus.cloudwatch.common.backend.msgs.GetMetricStatisticsResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.GetMetricStatisticsType;
import com.eucalyptus.cloudwatch.common.backend.msgs.ListMetricsResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.ListMetricsResult;
import com.eucalyptus.cloudwatch.common.backend.msgs.ListMetricsType;
import com.eucalyptus.cloudwatch.common.backend.msgs.MetricAlarms;
import com.eucalyptus.cloudwatch.common.backend.msgs.MetricData;
import com.eucalyptus.cloudwatch.common.backend.msgs.MetricDatum;
import com.eucalyptus.cloudwatch.common.backend.msgs.Metrics;
import com.eucalyptus.cloudwatch.common.backend.msgs.PutMetricAlarmResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.PutMetricAlarmType;
import com.eucalyptus.cloudwatch.common.backend.msgs.PutMetricDataResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.PutMetricDataType;
import com.eucalyptus.cloudwatch.common.backend.msgs.ResourceList;
import com.eucalyptus.cloudwatch.common.backend.msgs.SetAlarmStateResponseType;
import com.eucalyptus.cloudwatch.common.backend.msgs.SetAlarmStateType;
import com.eucalyptus.cloudwatch.common.backend.msgs.StatisticSet;
import com.eucalyptus.cloudwatch.common.backend.msgs.Statistics;
import com.eucalyptus.cloudwatch.domain.DBCleanupService;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmEntity;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmHistory;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmManager;
import com.eucalyptus.cloudwatch.domain.alarms.AlarmStateEvaluationDispatcher;
import com.eucalyptus.cloudwatch.domain.listmetrics.ListMetric;
import com.eucalyptus.cloudwatch.domain.listmetrics.ListMetricManager;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricDataQueue;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricEntity;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricManager;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricStatistics;
import com.eucalyptus.cloudwatch.domain.metricdata.MetricUtils;
import com.eucalyptus.component.Faults;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.log4j.Logger;

@ConfigurableClass(root="cloudwatch", description="Parameters controlling cloud watch and reporting")
public class CloudWatchBackendService {
    @ConfigurableField(initial="false", description="Set this to true to stop cloud watch alarm evaluation and new alarm/metric data entry")
    public static volatile Boolean DISABLE_CLOUDWATCH_SERVICE = false;
    private static final Logger LOG;
    private static final String SystemMetricPrefix = "AWS/";
    private static final int DISABLED_SERVICE_FAULT_ID = 1500;
    private boolean alreadyFaulted = false;

    public PutMetricAlarmResponseType putMetricAlarm(PutMetricAlarmType request) throws CloudWatchException {
        PutMetricAlarmResponseType reply = (PutMetricAlarmResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            this.checkActionPermission("putmetricalarm", ctx);
            if (DISABLE_CLOUDWATCH_SERVICE.booleanValue()) {
                this.faultDisableCloudWatchServiceIfNecessary();
                throw new ServiceDisabledException("Service Disabled");
            }
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            Boolean actionsEnabled = this.validateActionsEnabled(request.getActionsEnabled(), true);
            Map<String, String> dimensionMap = TransformationFunctions.DimensionsToMap.INSTANCE.apply(this.validateDimensions(request.getDimensions()));
            Collection<String> alarmActions = this.validateActions(request.getAlarmActions(), dimensionMap, "AlarmActions");
            String alarmDescription = this.validateAlarmDescription(request.getAlarmDescription());
            String alarmName = this.validateAlarmName(request.getAlarmName(), true);
            AlarmEntity.ComparisonOperator comparisonOperator = this.validateComparisonOperator(request.getComparisonOperator(), true);
            Integer evaluationPeriods = this.validateEvaluationPeriods(request.getEvaluationPeriods(), true);
            Integer period = this.validatePeriod(request.getPeriod(), true);
            this.validatePeriodAndEvaluationPeriodsNotAcrossDays(period, evaluationPeriods);
            Collection<String> insufficientDataActions = this.validateActions(request.getInsufficientDataActions(), dimensionMap, "InsufficientDataActions");
            String metricName = this.validateMetricName(request.getMetricName(), true);
            String namespace = this.validateNamespace(request.getNamespace(), true);
            Collection<String> okActions = this.validateActions(request.getOkActions(), dimensionMap, "OKActions");
            AlarmEntity.Statistic statistic = this.validateStatistic(request.getStatistic(), true);
            Double threshold = this.validateThreshold(request.getThreshold(), true);
            MetricEntity.Units unit = this.validateUnits(request.getUnit(), true);
            if (AlarmManager.countMetricAlarms(accountId) >= 5000L) {
                throw new LimitExceededException("The maximum limit of 5000 alarms would be exceeded.");
            }
            AlarmManager.putMetricAlarm(accountId, actionsEnabled, alarmActions, alarmDescription, alarmName, comparisonOperator, dimensionMap, evaluationPeriods, insufficientDataActions, metricName, this.getMetricTypeFromNamespace(namespace), namespace, okActions, period, statistic, threshold, unit);
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public PutMetricDataResponseType putMetricData(PutMetricDataType request) throws CloudWatchException {
        PutMetricDataResponseType reply = (PutMetricDataResponseType)request.getReply();
        long before = System.currentTimeMillis();
        Context ctx = Contexts.lookup();
        try {
            this.checkActionPermission("putmetricdata", ctx);
            if (DISABLE_CLOUDWATCH_SERVICE.booleanValue()) {
                this.faultDisableCloudWatchServiceIfNecessary();
                throw new ServiceDisabledException("Service Disabled");
            }
            UserFullName ownerFullName = ctx.getUserFullName();
            List<MetricDatum> metricData = this.validateMetricData(request.getMetricData());
            String namespace = this.validateNamespace(request.getNamespace(), true);
            Boolean privileged = Contexts.lookup().isPrivileged();
            LOG.trace((Object)("Namespace=" + namespace));
            LOG.trace((Object)("metricData=" + metricData));
            MetricEntity.MetricType metricType = this.getMetricTypeFromNamespace(namespace);
            if (metricType == MetricEntity.MetricType.System && !privileged.booleanValue()) {
                throw new InvalidParameterValueException("The value AWS/ for parameter Namespace is invalid.");
            }
            MetricDataQueue.getInstance().insertMetricData(ownerFullName.getAccountNumber(), namespace, metricData, metricType);
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public ListMetricsResponseType listMetrics(ListMetricsType request) throws CloudWatchException {
        ListMetricsResponseType reply = (ListMetricsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            this.checkActionPermission("listmetrics", ctx);
            UserFullName ownerFullName = ctx.getUserFullName();
            String namespace = this.validateNamespace(request.getNamespace(), false);
            String metricName = this.validateMetricName(request.getMetricName(), false);
            Map dimensionMap = (Map)TransformationFunctions.DimensionFiltersToMap.INSTANCE.apply(this.validateDimensionFilters(request.getDimensions()));
            Date after = new Date(System.currentTimeMillis() - 1209600000L);
            Date before = null;
            Integer maxRecords = 500;
            String nextToken = request.getNextToken();
            List<ListMetric> results = ListMetricManager.listMetrics(ownerFullName.getAccountNumber(), metricName, namespace, dimensionMap, after, before, maxRecords, nextToken);
            Metrics metrics = new Metrics();
            metrics.setMember(Lists.newArrayList((Iterable)Collections2.transform(results, (Function)TransformationFunctions.ListMetricToMetric.INSTANCE)));
            ListMetricsResult listMetricsResult = new ListMetricsResult();
            listMetricsResult.setMetrics(metrics);
            if (maxRecords != null && results.size() == maxRecords.intValue()) {
                listMetricsResult.setNextToken(results.get(results.size() - 1).getNaturalId());
            }
            reply.setListMetricsResult(listMetricsResult);
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public GetMetricStatisticsResponseType getMetricStatistics(GetMetricStatisticsType request) throws CloudWatchException {
        GetMetricStatisticsResponseType reply = (GetMetricStatisticsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            this.checkActionPermission("getmetricstatistics", ctx);
            UserFullName ownerFullName = ctx.getUserFullName();
            Statistics statistics = this.validateStatistics(request.getStatistics());
            String namespace = this.validateNamespace(request.getNamespace(), true);
            String metricName = this.validateMetricName(request.getMetricName(), true);
            Date startTime = MetricManager.stripSeconds(this.validateStartTime(request.getStartTime(), true));
            Date endTime = MetricManager.stripSeconds(this.validateEndTime(request.getEndTime(), true));
            Integer period = this.validatePeriod(request.getPeriod(), true);
            this.validateDateOrder(startTime, endTime, "StartTime", "EndTime", true, true);
            this.validateNotTooManyDataPoints(startTime, endTime, period, 1440L);
            MetricEntity.Units units = this.validateUnits(request.getUnit(), false);
            Map<String, String> dimensionMap = TransformationFunctions.DimensionsToMap.INSTANCE.apply(this.validateDimensions(request.getDimensions()));
            Collection<MetricStatistics> metrics = MetricManager.getMetricStatistics(ownerFullName.getAccountNumber(), metricName, namespace, dimensionMap, this.getMetricTypeFromNamespace(namespace), units, startTime, endTime, period);
            reply.getGetMetricStatisticsResult().setLabel(metricName);
            ArrayList<Datapoint> datapoints = this.convertMetricStatisticsToDataoints(statistics, metrics);
            if (datapoints.size() > 0) {
                Datapoints datapointsReply = new Datapoints();
                datapointsReply.setMember(datapoints);
                reply.getGetMetricStatisticsResult().setDatapoints(datapointsReply);
            }
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public DisableAlarmActionsResponseType disableAlarmActions(DisableAlarmActionsType request) throws EucalyptusCloudException {
        DisableAlarmActionsResponseType reply = (DisableAlarmActionsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            Collection<String> alarmNames;
            if (DISABLE_CLOUDWATCH_SERVICE.booleanValue()) {
                this.faultDisableCloudWatchServiceIfNecessary();
                throw new ServiceDisabledException("Service Disabled");
            }
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            if (!AlarmManager.disableAlarmActions(accountId, alarmNames = this.validateAlarmNames(request.getAlarmNames(), true), (Predicate<CloudWatchMetadata.AlarmMetadata>)RestrictedTypes.filterPrivileged())) {
                throw new EucalyptusCloudException("User does not have permission");
            }
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public DescribeAlarmsResponseType describeAlarms(DescribeAlarmsType request) throws CloudWatchException {
        DescribeAlarmsResponseType reply = (DescribeAlarmsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            boolean showAll = request.getAlarms().remove("verbose");
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ctx.isAdministrator() && showAll ? null : ownerFullName.getAccountNumber();
            String actionPrefix = this.validateActionPrefix(request.getActionPrefix(), false);
            String alarmNamePrefix = this.validateAlarmNamePrefix(request.getAlarmNamePrefix(), false);
            Collection<String> alarmNames = this.validateAlarmNames(request.getAlarmNames(), false);
            this.validateNotBothAlarmNamesAndAlarmNamePrefix(alarmNames, alarmNamePrefix);
            Integer maxRecords = this.validateMaxRecords(request.getMaxRecords());
            String nextToken = request.getNextToken();
            AlarmEntity.StateValue stateValue = this.validateStateValue(request.getStateValue(), false);
            List<AlarmEntity> results = AlarmManager.describeAlarms(accountId, actionPrefix, alarmNamePrefix, alarmNames, maxRecords, stateValue, nextToken, (Predicate<? super CloudWatchMetadata.AlarmMetadata>)RestrictedTypes.filteringFor(CloudWatchMetadata.AlarmMetadata.class).byPrivileges().buildPredicate());
            if (maxRecords != null && results.size() == maxRecords.intValue()) {
                reply.getDescribeAlarmsResult().setNextToken(results.get(results.size() - 1).getNaturalId());
            }
            MetricAlarms metricAlarms = new MetricAlarms();
            metricAlarms.setMember(Lists.newArrayList((Iterable)Collections2.transform(results, (Function)TransformationFunctions.AlarmEntityToMetricAlarm.INSTANCE)));
            reply.getDescribeAlarmsResult().setMetricAlarms(metricAlarms);
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public DescribeAlarmsForMetricResponseType describeAlarmsForMetric(DescribeAlarmsForMetricType request) throws CloudWatchException {
        DescribeAlarmsForMetricResponseType reply = (DescribeAlarmsForMetricResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            Map<String, String> dimensionMap = TransformationFunctions.DimensionsToMap.INSTANCE.apply(this.validateDimensions(request.getDimensions()));
            String metricName = this.validateMetricName(request.getMetricName(), true);
            String namespace = this.validateNamespace(request.getNamespace(), true);
            Integer period = this.validatePeriod(request.getPeriod(), false);
            AlarmEntity.Statistic statistic = this.validateStatistic(request.getStatistic(), false);
            MetricEntity.Units unit = this.validateUnits(request.getUnit(), true);
            Collection<AlarmEntity> results = AlarmManager.describeAlarmsForMetric(accountId, dimensionMap, metricName, namespace, period, statistic, unit, (Predicate<? super CloudWatchMetadata.AlarmMetadata>)RestrictedTypes.filteringFor(CloudWatchMetadata.AlarmMetadata.class).byPrivileges().buildPredicate());
            MetricAlarms metricAlarms = new MetricAlarms();
            metricAlarms.setMember(Lists.newArrayList((Iterable)Collections2.transform(results, (Function)TransformationFunctions.AlarmEntityToMetricAlarm.INSTANCE)));
            reply.getDescribeAlarmsForMetricResult().setMetricAlarms(metricAlarms);
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public DescribeAlarmHistoryResponseType describeAlarmHistory(DescribeAlarmHistoryType request) throws CloudWatchException {
        DescribeAlarmHistoryResponseType reply = (DescribeAlarmHistoryResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            String alarmName = this.validateAlarmName(request.getAlarmName(), false);
            Date endDate = this.validateEndDate(request.getEndDate(), false);
            Date startDate = this.validateStartDate(request.getStartDate(), false);
            this.validateDateOrder(startDate, endDate, "StartDate", "EndDate", false, false);
            AlarmHistory.HistoryItemType historyItemType = this.validateHistoryItemType(request.getHistoryItemType(), false);
            Integer maxRecords = this.validateMaxRecords(request.getMaxRecords());
            String nextToken = request.getNextToken();
            List<AlarmHistory> results = AlarmManager.describeAlarmHistory(accountId, alarmName, endDate, historyItemType, maxRecords, startDate, nextToken, (Predicate<AlarmHistory>)Predicates.compose((Predicate)RestrictedTypes.filteringFor(CloudWatchMetadata.AlarmMetadata.class).byPrivileges().buildPredicate(), (Function)TransformationFunctions.AlarmHistoryToAlarmMetadata.INSTANCE));
            if (maxRecords != null && results.size() == maxRecords.intValue()) {
                reply.getDescribeAlarmHistoryResult().setNextToken(results.get(results.size() - 1).getNaturalId());
            }
            AlarmHistoryItems alarmHistoryItems = new AlarmHistoryItems();
            alarmHistoryItems.setMember(Lists.newArrayList((Iterable)Collections2.transform(results, (Function)TransformationFunctions.AlarmHistoryToAlarmHistoryItem.INSTANCE)));
            reply.getDescribeAlarmHistoryResult().setAlarmHistoryItems(alarmHistoryItems);
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public EnableAlarmActionsResponseType enableAlarmActions(EnableAlarmActionsType request) throws CloudWatchException {
        EnableAlarmActionsResponseType reply = (EnableAlarmActionsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            Collection<String> alarmNames;
            if (DISABLE_CLOUDWATCH_SERVICE.booleanValue()) {
                this.faultDisableCloudWatchServiceIfNecessary();
                throw new ServiceDisabledException("Service Disabled");
            }
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            if (!AlarmManager.enableAlarmActions(accountId, alarmNames = this.validateAlarmNames(request.getAlarmNames(), true), (Predicate<CloudWatchMetadata.AlarmMetadata>)RestrictedTypes.filterPrivileged())) {
                throw new EucalyptusCloudException("User does not have permission");
            }
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public DeleteAlarmsResponseType deleteAlarms(DeleteAlarmsType request) throws CloudWatchException {
        DeleteAlarmsResponseType reply = (DeleteAlarmsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            Collection<String> alarmNames;
            if (DISABLE_CLOUDWATCH_SERVICE.booleanValue()) {
                this.faultDisableCloudWatchServiceIfNecessary();
                throw new ServiceDisabledException("Service Disabled");
            }
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            if (!AlarmManager.deleteAlarms(accountId, alarmNames = this.validateAlarmNames(request.getAlarmNames(), true), (Predicate<CloudWatchMetadata.AlarmMetadata>)RestrictedTypes.filterPrivileged())) {
                throw new EucalyptusCloudException("User does not have permission");
            }
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    public SetAlarmStateResponseType setAlarmState(SetAlarmStateType request) throws CloudWatchException {
        SetAlarmStateResponseType reply = (SetAlarmStateResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            if (DISABLE_CLOUDWATCH_SERVICE.booleanValue()) {
                this.faultDisableCloudWatchServiceIfNecessary();
                throw new ServiceDisabledException("Service Disabled");
            }
            UserFullName ownerFullName = ctx.getUserFullName();
            String accountId = ownerFullName.getAccountNumber();
            String alarmName = this.validateAlarmName(request.getAlarmName(), true);
            String stateReason = this.validateStateReason(request.getStateReason(), true);
            String stateReasonData = this.validateStateReasonData(request.getStateReasonData(), false);
            AlarmEntity.StateValue stateValue = this.validateStateValue(request.getStateValue(), true);
            AlarmManager.setAlarmState(accountId, alarmName, stateReason, stateReasonData, stateValue, (Predicate<CloudWatchMetadata.AlarmMetadata>)RestrictedTypes.filterPrivileged());
        }
        catch (Exception ex) {
            CloudWatchBackendService.handleException(ex);
        }
        return reply;
    }

    private void faultDisableCloudWatchServiceIfNecessary() {
        if (!this.alreadyFaulted) {
            Faults.forComponent(CloudWatchBackend.class).havingId(1500).withVar("component", "cloudwatch").log();
            this.alreadyFaulted = true;
        }
    }

    private void validatePeriodAndEvaluationPeriodsNotAcrossDays(Integer period, Integer evaluationPeriods) throws CloudWatchException {
        if (period * evaluationPeriods > 86400) {
            throw new InvalidParameterCombinationException("Metrics cannot be checked across more than a day (EvaluationPeriods * Period must be <= 86400).");
        }
    }

    private void validateNotTooManyDataPoints(Date startTime, Date endTime, Integer period, long maxDataPoints) throws CloudWatchException {
        NumberFormat nf = NumberFormat.getInstance();
        long possibleRequestedDataPoints = (endTime.getTime() - startTime.getTime()) / (1000L * (long)period.intValue());
        if (possibleRequestedDataPoints > maxDataPoints) {
            throw new InvalidParameterCombinationException("You have requested up to " + nf.format(possibleRequestedDataPoints) + " datapoints, which exceeds the limit of " + nf.format(maxDataPoints) + ". You may reduce the datapoints requested by increasing Period, or decreasing the time range.");
        }
    }

    private List<MetricDatum> validateMetricData(MetricData metricData) throws CloudWatchException {
        ArrayList metricDataCollection = null;
        if (metricData != null) {
            metricDataCollection = metricData.getMember();
        }
        if (metricDataCollection == null) {
            throw new MissingParameterException("The parameter MetricData is required.");
        }
        if (metricDataCollection.size() < 1) {
            throw new MissingParameterException("The parameter MetricData is required.");
        }
        if (metricDataCollection.size() > 20) {
            throw new InvalidParameterValueException("The collection MetricData must not have a size greater than 20.");
        }
        int ctr = 1;
        for (MetricDatum metricDatum : metricDataCollection) {
            this.validateMetricDatum(metricDatum, "MetricData.member." + ctr);
            ++ctr;
        }
        return metricDataCollection;
    }

    private Date validateStartDate(Date startDate, boolean required) throws CloudWatchException {
        return this.validateTimestamp(startDate, "StartDate", required);
    }

    private Date validateEndDate(Date endDate, boolean required) throws CloudWatchException {
        return this.validateTimestamp(endDate, "EndDate", required);
    }

    private Date validateStartTime(Date startTime, boolean required) throws CloudWatchException {
        return this.validateTimestamp(startTime, "StartTime", required);
    }

    private Date validateEndTime(Date endTime, boolean required) throws CloudWatchException {
        return this.validateTimestamp(endTime, "EndTime", required);
    }

    private MetricDatum validateMetricDatum(MetricDatum metricDatum, String name) throws CloudWatchException {
        if (metricDatum == null) {
            throw new MissingParameterException("The parameter " + name + " is required.");
        }
        this.validateDimensions(metricDatum.getDimensions(), name + ".Dimensions");
        this.validateMetricName(metricDatum.getMetricName(), name + ".MetricName", true);
        this.validateWithinTwoWeeks(metricDatum.getTimestamp(), name + "Timestamp");
        this.validateUnits(metricDatum.getUnit(), name + ".Unit", true);
        this.validateValueAndStatisticSet(metricDatum.getValue(), name + ".Value", metricDatum.getStatisticValues(), name + ".StatisticValues");
        return metricDatum;
    }

    private void validateWithinTwoWeeks(Date timestamp, String name) throws CloudWatchException {
        if (timestamp == null) {
            return;
        }
        Date now = new Date();
        Date twoWeeksAgo = new Date(now.getTime() - 1209600000L);
        long BUFFER = 0x6DDD00L;
        if (timestamp.getTime() > now.getTime() + BUFFER || timestamp.getTime() < twoWeeksAgo.getTime() - BUFFER) {
            throw new InvalidParameterValueException("The parameter " + name + ".Timestamp must specify a time within the past two weeks.");
        }
    }

    private void validateValueAndStatisticSet(Double value, String valueName, StatisticSet statisticValues, String statisticValuesName) throws CloudWatchException {
        if (value == null && this.statisticSetHasNoFields(statisticValues)) {
            throw new MissingParameterException("At least one of the parameters " + valueName + " or " + statisticValuesName + " must be specified.");
        }
        if (value != null && !this.statisticSetHasNoFields(statisticValues)) {
            throw new InvalidParameterCombinationException("The parameters " + valueName + " and " + statisticValuesName + " are mutually exclusive and you have specified both.");
        }
        if (value != null) {
            return;
        }
        this.validateAllStatisticSetFields(statisticValues, statisticValuesName);
        if (statisticValues.getMaximum() < statisticValues.getMinimum()) {
            throw new MissingParameterException("The parameter " + statisticValuesName + ".Maximum must be greater than " + statisticValuesName + ".Minimum.");
        }
        if (statisticValues.getSampleCount() < 0.0) {
            throw new MissingParameterException("The parameter " + statisticValuesName + ".SampleCount must be greater than 0.");
        }
        if (statisticValues.getSampleCount() == 0.0) {
            throw new MissingParameterException("The parameter " + statisticValuesName + ".SampleCount must not equal 0.");
        }
    }

    private void validateAllStatisticSetFields(StatisticSet statisticValues, String statisticValuesName) throws CloudWatchException {
        StringBuilder errors = new StringBuilder();
        boolean haveErrors = false;
        if (statisticValues == null || statisticValues.getMaximum() == null) {
            if (haveErrors) {
                errors.append("\n");
            }
            errors.append("The parameter " + statisticValuesName + ".Maximum is required.");
            haveErrors = true;
        }
        if (statisticValues == null || statisticValues.getMinimum() == null) {
            if (haveErrors) {
                errors.append("\n");
            }
            errors.append("The parameter " + statisticValuesName + ".Minimum is required.");
            haveErrors = true;
        }
        if (statisticValues == null || statisticValues.getSampleCount() == null) {
            if (haveErrors) {
                errors.append("\n");
            }
            errors.append("The parameter " + statisticValuesName + ".SampleCount is required.");
            haveErrors = true;
        }
        if (statisticValues == null || statisticValues.getSum() == null) {
            if (haveErrors) {
                errors.append("\n");
            }
            errors.append("The parameter " + statisticValuesName + ".Sum is required.");
            haveErrors = true;
        }
        if (haveErrors) {
            throw new MissingParameterException(errors.toString());
        }
    }

    private boolean statisticSetHasNoFields(StatisticSet statisticValues) {
        return statisticValues == null || statisticValues.getMaximum() == null && statisticValues.getMinimum() == null && statisticValues.getSampleCount() == null && statisticValues.getSum() == null;
    }

    private MetricEntity.Units validateUnits(String unit, boolean useNoneIfNull) throws CloudWatchException {
        return this.validateUnits(unit, "Unit", useNoneIfNull);
    }

    private Date validateTimestamp(Date timestamp, String name, boolean required) throws CloudWatchException {
        if (timestamp == null && required) {
            throw new MissingParameterException("The parameter " + name + " is required.");
        }
        return timestamp;
    }

    private Integer validateEvaluationPeriods(Integer evaluationPeriods, boolean required) throws CloudWatchException {
        if (evaluationPeriods == null && required) {
            throw new MissingParameterException("The parameter EvaluationPeriods is required.");
        }
        if (evaluationPeriods < 1) {
            throw new InvalidParameterValueException("The parameter EvaluationPeriods must be greater than or equal to 1.");
        }
        return evaluationPeriods;
    }

    private String validateMetricName(String metricName, boolean required) throws CloudWatchException {
        return this.validateMetricName(metricName, "MetricName", required);
    }

    private Dimensions validateDimensions(Dimensions dimensions) throws CloudWatchException {
        return this.validateDimensions(dimensions, "Dimensions");
    }

    private DimensionFilters validateDimensionFilters(DimensionFilters dimensionFilters) throws CloudWatchException {
        return this.validateDimensionFilters(dimensionFilters, "Dimensions");
    }

    private Double validateDouble(Double value, String name, boolean required) throws CloudWatchException {
        if (value == null && required) {
            throw new MissingParameterException("The parameter " + name + " is required.");
        }
        return value;
    }

    private Double validateThreshold(Double threshold, boolean required) throws CloudWatchException {
        return this.validateDouble(threshold, "Threshold", required);
    }

    private AlarmEntity.ComparisonOperator validateComparisonOperator(String comparisonOperator, boolean required) throws CloudWatchException {
        return this.validateEnum(comparisonOperator, "ComparisonOperator", AlarmEntity.ComparisonOperator.class, required);
    }

    private String validateAlarmDescription(String alarmDescription) throws CloudWatchException {
        return this.validateStringLength(alarmDescription, "AlarmDescription", 0, 255, false);
    }

    private Boolean validateActionsEnabled(Boolean actionsEnabled, boolean useTrueIfNull) throws CloudWatchException {
        if (actionsEnabled == null && useTrueIfNull) {
            return Boolean.TRUE;
        }
        return actionsEnabled;
    }

    private Collection<String> validateActions(ResourceList actions, Map<String, String> dimensionMap, String name) throws CloudWatchException {
        ArrayList actionsCollection = null;
        if (actions != null) {
            actionsCollection = actions.getMember();
        }
        if (actionsCollection == null) {
            return actionsCollection;
        }
        if (actionsCollection.size() > 5) {
            throw new InvalidParameterValueException("The collection " + name + " must not have a size greater than 5.");
        }
        int ctr = 1;
        for (String action : actionsCollection) {
            this.validateAction(action, dimensionMap, name + ".member." + ctr);
            ++ctr;
        }
        return actionsCollection;
    }

    private void validateAction(String action, Map<String, String> dimensionMap, String name) throws CloudWatchException {
        if (AlarmManager.ActionManager.getAction(action, dimensionMap) == null) {
            throw new InvalidParameterValueException("The parameter " + name + "'" + action + "' is an unsupported action for this metric and dimension list.");
        }
    }

    private void validateNotBothAlarmNamesAndAlarmNamePrefix(Collection<String> alarmNames, String alarmNamePrefix) throws CloudWatchException {
        if (alarmNames != null && alarmNamePrefix != null) {
            throw new InvalidParameterCombinationException("AlarmNamePrefix and AlarmNames.member are mutually exclusive");
        }
    }

    private String validateAlarmNamePrefix(String alarmNamePrefix, boolean required) throws CloudWatchException {
        return this.validateStringLength(alarmNamePrefix, "AlarmNamePrefix", 1, 255, required);
    }

    private String validateActionPrefix(String actionPrefix, boolean required) throws CloudWatchException {
        return this.validateStringLength(actionPrefix, "ActionPrefix", 1, 1024, required);
    }

    private Statistics validateStatistics(Statistics statistics) throws CloudWatchException {
        ArrayList statisticCollection = null;
        if (statistics != null) {
            statisticCollection = statistics.getMember();
        }
        if (statisticCollection == null) {
            throw new MissingParameterException("The parameter Statistics is required.");
        }
        if (statisticCollection.size() < 1) {
            throw new MissingParameterException("The parameter Statistics is required.");
        }
        if (statisticCollection.size() > 5) {
            throw new InvalidParameterValueException("The collection MetricData must not have a size greater than 5.");
        }
        int ctr = 1;
        String[] statisticValues = new String[]{"Average", "Sum", "SampleCount", "Maximum", "Minimum"};
        for (String statistic : statisticCollection) {
            if (statistic == null) {
                throw new InvalidParameterValueException("The parameter Statistics.member." + ctr + " is required.");
            }
            if (!Arrays.asList(statisticValues).contains(statistic)) {
                throw new InvalidParameterValueException("The parameter Statistics.member." + ctr + " must be a value in the set " + Arrays.asList(statisticValues) + ".");
            }
            ++ctr;
        }
        return statistics;
    }

    private DimensionFilters validateDimensionFilters(DimensionFilters dimensionFilters, String name) throws CloudWatchException {
        ArrayList dimensionFiltersCollection = null;
        if (dimensionFilters != null) {
            dimensionFiltersCollection = dimensionFilters.getMember();
        }
        if (dimensionFiltersCollection == null) {
            return dimensionFilters;
        }
        if (dimensionFiltersCollection.size() > 10) {
            throw new InvalidParameterValueException("The collection " + name + " must not have a size greater than 10.");
        }
        int ctr = 1;
        for (DimensionFilter dimensionFilter : dimensionFiltersCollection) {
            this.validateStringLength(dimensionFilter.getName(), name + ".member." + ctr + ".Name", 1, 255, true);
            this.validateStringLength(dimensionFilter.getValue(), name + ".member." + ctr + ".Value", 1, 255, true);
            ++ctr;
        }
        return dimensionFilters;
    }

    private Dimensions validateDimensions(Dimensions dimensions, String name) throws CloudWatchException {
        ArrayList dimensionsCollection = null;
        if (dimensions != null) {
            dimensionsCollection = dimensions.getMember();
        }
        if (dimensions == null) {
            return dimensions;
        }
        if (dimensionsCollection.size() > 10) {
            throw new InvalidParameterValueException("The collection " + name + " must not have a size greater than 10.");
        }
        int ctr = 1;
        for (Dimension dimension : dimensionsCollection) {
            this.validateStringLength(dimension.getName(), name + ".member." + ctr + ".Name", 1, 255, true);
            this.validateStringLength(dimension.getValue(), name + ".member." + ctr + ".Value", 1, 255, true);
            ++ctr;
        }
        return dimensions;
    }

    private MetricEntity.Units validateUnits(String unit, String name, boolean useNoneIfNull) throws CloudWatchException {
        if (unit == null) {
            if (useNoneIfNull) {
                return MetricEntity.Units.None;
            }
            return null;
        }
        try {
            return MetricEntity.Units.fromValue(unit);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidParameterValueException("The parameter " + name + " must be a value in the set " + Arrays.asList(MetricEntity.Units.values()) + ".");
        }
    }

    private AlarmEntity.Statistic validateStatistic(String statistic, boolean required) throws CloudWatchException {
        return this.validateEnum(statistic, "Statistic", AlarmEntity.Statistic.class, required);
    }

    private Integer validatePeriod(Integer period, boolean required) throws CloudWatchException {
        if (period == null) {
            if (required) {
                throw new MissingParameterException("The parameter Period is required.");
            }
            return period;
        }
        if (period < 0) {
            throw new InvalidParameterValueException("The parameter Period must be greater than 0.");
        }
        if (period == 0) {
            throw new InvalidParameterValueException("The parameter Period must not equal 0.");
        }
        if (period % 60 != 0) {
            throw new InvalidParameterValueException("The parameter Period must be a multiple of 60.");
        }
        return period;
    }

    private String validateNamespace(String namespace, boolean required) throws CloudWatchException {
        namespace = this.validateStringLength(namespace, "Namespace", 1, 255, required);
        return namespace;
    }

    private String validateMetricName(String metricName, String name, boolean required) throws CloudWatchException {
        return this.validateStringLength(metricName, name, 1, 255, required);
    }

    private Integer validateMaxRecords(Integer maxRecords) throws CloudWatchException {
        if (maxRecords == null) {
            return 50;
        }
        if (maxRecords < 1) {
            throw new InvalidParameterValueException("The parameter MaxRecords must be greater than or equal to 1.");
        }
        if (maxRecords > 100) {
            throw new InvalidParameterValueException("The parameter MaxRecords must be less than or equal to 100.");
        }
        return maxRecords;
    }

    private void validateDateOrder(Date startDate, Date endDate, String startDateName, String endDateName, boolean startDateRequired, boolean endDateRequired) throws CloudWatchException {
        if (startDate != null && endDate != null) {
            if (startDate.after(endDate)) {
                throw new InvalidParameterValueException("The parameter " + endDateName + " must be greater than " + startDateName + ".");
            }
            if (startDate.equals(endDate)) {
                throw new InvalidParameterValueException("The parameter " + startDateName + " must not equal parameter " + endDateName + ".");
            }
        }
        if (startDate == null && startDateRequired) {
            throw new MissingParameterException("The parameter " + startDateName + " is required.");
        }
        if (endDate == null && endDateRequired) {
            throw new MissingParameterException("The parameter " + endDateName + " is required.");
        }
    }

    private AlarmHistory.HistoryItemType validateHistoryItemType(String historyItemType, boolean required) throws CloudWatchException {
        return this.validateEnum(historyItemType, "HistoryItemType", AlarmHistory.HistoryItemType.class, required);
    }

    private Collection<String> validateAlarmNames(AlarmNames alarmNames, boolean required) throws CloudWatchException {
        ArrayList alarmNamesCollection = null;
        if (alarmNames != null) {
            alarmNamesCollection = alarmNames.getMember();
        }
        if (alarmNamesCollection == null) {
            if (required) {
                throw new MissingParameterException("The parameter AlarmNames is required.");
            }
            return alarmNamesCollection;
        }
        if (alarmNamesCollection.size() < 1 && required) {
            throw new MissingParameterException("The parameter AlarmNames is required.");
        }
        if (alarmNamesCollection.size() > 100) {
            throw new InvalidParameterValueException("The collection AlarmNames must not have a size greater than 100.");
        }
        int ctr = 1;
        for (String alarmName : alarmNamesCollection) {
            this.validateAlarmName(alarmName, "AlarmName.member." + ctr++, true);
        }
        return alarmNamesCollection;
    }

    private <T extends Enum<T>> T validateEnum(String value, String name, Class<T> enumType, boolean required) throws CloudWatchException {
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidParameterValueException("The parameter " + name + " must be a value in the set " + Arrays.asList(enumType.getEnumConstants()) + ".");
        }
        catch (NullPointerException ex) {
            if (required) {
                throw new MissingParameterException("The parameter " + name + " is required.");
            }
            return null;
        }
    }

    private AlarmEntity.StateValue validateStateValue(String stateValue, boolean required) throws CloudWatchException {
        return this.validateEnum(stateValue, "StateValue", AlarmEntity.StateValue.class, required);
    }

    private String validateStateReasonData(String stateReasonData, boolean required) throws CloudWatchException {
        stateReasonData = this.validateStringLength(stateReasonData, "StateReasonData", 0, 4000, required);
        stateReasonData = this.validateJSON(stateReasonData, "StateReasonData", required);
        return stateReasonData;
    }

    private String validateJSON(String value, String name, boolean required) throws CloudWatchException {
        if (value == null) {
            if (required) {
                throw new MissingParameterException("The parameter " + name + " is required.");
            }
            return value;
        }
        try {
            JSONSerializer.toJSON((Object)value);
        }
        catch (JSONException ex) {
            throw new InvalidFormatException(name + " was not syntactically valid JSON");
        }
        return value;
    }

    private String validateStringLength(String value, String name, int minLength, int maxLength, boolean required) throws CloudWatchException {
        if (value == null || value.isEmpty()) {
            if (required) {
                throw new MissingParameterException("The parameter " + name + " is required.");
            }
            return value;
        }
        if (value.length() < minLength) {
            throw new InvalidParameterValueException("The parameter " + name + " must be longer than " + (minLength - 1) + " character" + (minLength == 2 ? "" : "s") + ".");
        }
        if (value.length() > maxLength) {
            throw new InvalidParameterValueException("The parameter " + name + " must be shorter than " + (maxLength + 1) + " character" + (maxLength == 0 ? "" : "s") + ".");
        }
        return value;
    }

    private String validateAlarmName(String alarmName, boolean required) throws CloudWatchException {
        return this.validateAlarmName(alarmName, "AlarmName", required);
    }

    private String validateAlarmName(String alarmNameValue, String alarmNameKey, boolean required) throws CloudWatchException {
        return this.validateStringLength(alarmNameValue, alarmNameKey, 1, 255, required);
    }

    private String validateStateReason(String stateReason, boolean required) throws CloudWatchException {
        return this.validateStringLength(stateReason, "StateReason", 0, 1024, required);
    }

    private void checkActionPermission(String actionType, Context ctx) throws EucalyptusCloudException {
        if (!Permissions.isAuthorized((String)"cloudwatch", (String)actionType, (String)"", (Account)ctx.getAccount(), (String)actionType, (AuthContextSupplier)ctx.getAuthContext())) {
            throw new EucalyptusCloudException("User does not have permission");
        }
    }

    private static void handleException(Exception e) throws CloudWatchException {
        CloudWatchException cause = (CloudWatchException)((Object)Exceptions.findCause((Throwable)e, CloudWatchException.class));
        if (cause != null) {
            throw cause;
        }
        InternalFailureException exception = new InternalFailureException(String.valueOf(e.getMessage()));
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            exception.initCause(e);
        }
        throw exception;
    }

    private MetricEntity.MetricType getMetricTypeFromNamespace(String namespace) {
        return namespace.startsWith(SystemMetricPrefix) ? MetricEntity.MetricType.System : MetricEntity.MetricType.Custom;
    }

    private ArrayList<Datapoint> convertMetricStatisticsToDataoints(Statistics statistics, Collection<MetricStatistics> metrics) {
        ArrayList datapoints = Lists.newArrayList();
        boolean wantsAverage = statistics.getMember().contains("Average");
        boolean wantsSum = statistics.getMember().contains("Sum");
        boolean wantsSampleCount = statistics.getMember().contains("SampleCount");
        boolean wantsMaximum = statistics.getMember().contains("Maximum");
        boolean wantsMinimum = statistics.getMember().contains("Minimum");
        for (MetricStatistics metricStatistics : metrics) {
            Datapoint datapoint = new Datapoint();
            datapoint.setTimestamp(metricStatistics.getTimestamp());
            datapoint.setUnit(metricStatistics.getUnits().toString());
            if (wantsSum) {
                datapoint.setSum(metricStatistics.getSampleSum());
            }
            if (wantsSampleCount) {
                datapoint.setSampleCount(metricStatistics.getSampleSize());
            }
            if (wantsMaximum) {
                datapoint.setMaximum(metricStatistics.getSampleMax());
            }
            if (wantsMinimum) {
                datapoint.setMinimum(metricStatistics.getSampleMin());
            }
            if (wantsAverage) {
                datapoint.setAverage(MetricUtils.average(metricStatistics.getSampleSum(), metricStatistics.getSampleSize()));
            }
            datapoints.add(datapoint);
        }
        return datapoints;
    }

    static {
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(5);
        ScheduledExecutorService alarmWorkerService = Executors.newSingleThreadScheduledExecutor();
        alarmWorkerService.scheduleAtFixedRate(new AlarmStateEvaluationDispatcher(fixedThreadPool), 0L, 1L, TimeUnit.MINUTES);
        ScheduledExecutorService dbCleanupService = Executors.newSingleThreadScheduledExecutor();
        dbCleanupService.scheduleAtFixedRate(new DBCleanupService(), 1L, 24L, TimeUnit.HOURS);
        LOG = Logger.getLogger(CloudWatchBackendService.class);
    }
}

