/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.ws;

import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.ws.SimpleWorkflowBinding;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.stages.HmacUserAuthenticationStage;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=SimpleWorkflow.class)
public class SimpleWorkflowPipeline
extends FilteredPipeline {
    private final HmacUserAuthenticationStage auth;
    private final Set<String> servicePathPrefixes = ImmutableSet.of((Object)"/services/SimpleWorkflow");

    public SimpleWorkflowPipeline() {
        this.auth = new HmacUserAuthenticationStage(EnumSet.allOf(TemporaryAccessKey.TemporaryKeyType.class));
    }

    public String getName() {
        return "simpleworkflow-query-pipeline";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        pipeline.addLast("simpleworkflow-binding", (ChannelHandler)new SimpleWorkflowBinding());
        return pipeline;
    }

    public boolean checkAccepts(HttpRequest message) {
        if (message instanceof MappingHttpRequest) {
            boolean targetHeaderIsSwf = Strings.startsWith((String)"SimpleWorkflowService.").apply((Object)message.getHeader("X-Amz-Target"));
            boolean usesServicePath = Iterables.any(this.servicePathPrefixes, (Predicate)Strings.isPrefixOf((String)message.getUri()));
            boolean noPath = message.getUri().isEmpty() || message.getUri().equals("/") || message.getUri().startsWith("/?");
            return targetHeaderIsSwf && (usesServicePath || noPath && this.resolvesByHost(message.getHeader("Host")));
        }
        return false;
    }
}

