/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.ws;

import com.eucalyptus.auth.InvalidAccessKeyAuthException;
import com.eucalyptus.auth.InvalidSignatureAuthException;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.simpleworkflow.SwfJsonUtils;
import com.eucalyptus.simpleworkflow.common.model.SimpleWorkflowMessage;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.handlers.ExceptionMarshallerHandler;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.jackson.JsonProcessingException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class SimpleWorkflowBinding
extends MessageStackHandler
implements ExceptionMarshallerHandler {
    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            try {
                BaseMessage msg = this.bind(httpRequest);
                httpRequest.setMessage((Object)msg);
            }
            catch (Exception e2) {
                BindingException e2;
                if (!(e2 instanceof BindingException)) {
                    e2 = new BindingException((Throwable)e2);
                }
                throw e2;
            }
        }
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            Object message;
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(8192);
            if (httpResponse.getMessage() instanceof EucalyptusErrorMessageType) {
                httpResponse.setStatus(HttpResponseStatus.BAD_REQUEST);
                Optional<String> correlationId = this.getCorrelationId((ChannelEvent)event);
                if (correlationId.isPresent()) {
                    httpResponse.addHeader("x-amzn-RequestId", correlationId.get());
                }
                SwfJsonUtils.writeObject(byteOut, ImmutableMap.of((Object)"__type", (Object)"InternalFailure", (Object)"message", (Object)((EucalyptusErrorMessageType)httpResponse.getMessage()).getMessage()));
            } else if (httpResponse.getMessage() instanceof ExceptionResponseType) {
                ExceptionResponseType msg = (ExceptionResponseType)httpResponse.getMessage();
                httpResponse.setStatus(msg.getHttpStatus());
                Optional<String> correlationId = this.getCorrelationId((ChannelEvent)event);
                if (correlationId.isPresent()) {
                    httpResponse.addHeader("x-amzn-RequestId", correlationId.get());
                }
                SwfJsonUtils.writeObject(byteOut, ImmutableMap.of((Object)"__type", (Object)"InternalFailure", (Object)"message", (Object)((ExceptionResponseType)httpResponse.getMessage()).getMessage()));
            } else if (httpResponse.getMessage() != null && (message = httpResponse.getMessage()) instanceof SimpleWorkflowMessage) {
                httpResponse.addHeader("x-amzn-RequestId", (Object)((SimpleWorkflowMessage)message).getCorrelationId());
                if (!SimpleWorkflowMessage.class.equals(message.getClass())) {
                    SwfJsonUtils.writeObject(byteOut, message);
                }
            }
            byte[] req = byteOut.toByteArray();
            ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])req);
            httpResponse.addHeader("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
            httpResponse.addHeader("Content-Type", (Object)"application/x-amz-json-1.0");
            httpResponse.setContent(buffer);
        }
    }

    @Nonnull
    public ExceptionMarshallerHandler.ExceptionResponse marshallException(@Nonnull ChannelEvent event, @Nonnull HttpResponseStatus status, @Nonnull Throwable throwable) throws Exception {
        HttpResponseStatus responseStatus = status;
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", "application/x-amz-json-1.0");
        Optional<String> correlationId = this.getCorrelationId(event);
        if (correlationId.isPresent()) {
            headers.put("x-amzn-RequestId", correlationId.get());
        }
        String type = "InternalFailure";
        String message = throwable.getMessage();
        if (Exceptions.isCausedBy((Throwable)throwable, InvalidAccessKeyAuthException.class)) {
            responseStatus = HttpResponseStatus.FORBIDDEN;
            type = "InvalidClientTokenId";
            message = "The security token included in the request is invalid.";
        } else if (Exceptions.isCausedBy((Throwable)throwable, InvalidSignatureAuthException.class)) {
            responseStatus = HttpResponseStatus.FORBIDDEN;
            type = "InvalidSignatureException";
            message = "The request signature we calculated does not match the signature you provided. Check your AWS Secret Access Key and signing method.";
        } else if (throwable instanceof BindingException) {
            responseStatus = HttpResponseStatus.BAD_REQUEST;
            type = "InvalidParameterValue";
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(8192);
        SwfJsonUtils.writeObject(byteOut, ImmutableMap.of((Object)"__type", (Object)type, (Object)"message", (Object)message));
        return new ExceptionMarshallerHandler.ExceptionResponse(responseStatus, ChannelBuffers.wrappedBuffer((byte[])byteOut.toByteArray()), (Map)ImmutableMap.copyOf((Map)headers));
    }

    private BaseMessage bind(MappingHttpRequest httpRequest) throws BindingException, IOException {
        BaseMessage message;
        String target = Objects.toString(httpRequest.getHeader("X-Amz-Target"), "");
        if (!target.startsWith("SimpleWorkflowService.")) {
            throw new BindingException("Unable to get action from target header: " + target);
        }
        String simpleClassName = target.substring(22) + "Request";
        ChannelBuffer buffer = httpRequest.getContent();
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        String content = new String(read, Charsets.UTF_8);
        buffer.resetReaderIndex();
        try {
            message = (BaseMessage)SwfJsonUtils.readObject(content, Class.forName(SimpleWorkflowMessage.class.getPackage().getName() + "." + simpleClassName));
        }
        catch (JsonProcessingException e) {
            throw new BindingException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new BindingException("Binding not found for target: " + target);
        }
        return message;
    }

    private Optional<String> getCorrelationId(ChannelEvent event) {
        return this.getCorrelationId(event.getChannel());
    }

    private Optional<String> getCorrelationId(Channel channel) {
        try {
            Context context = Contexts.lookup((Channel)channel);
            return Optional.fromNullable((Object)context.getCorrelationId());
        }
        catch (NoSuchContextException e) {
            return Optional.absent();
        }
    }
}

