/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.tokens;

import com.eucalyptus.bootstrap.SystemIds;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.simpleworkflow.tokens.TaskToken;
import com.eucalyptus.simpleworkflow.tokens.TaskTokenException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@ComponentNamed
public class TaskTokenManager {
    private static final Supplier<SecureRandom> randomSupplier = Crypto.getSecureRandomSupplier();

    @Nonnull
    public String encryptTaskToken(@Nonnull TaskToken taskToken) {
        EncryptedTaskToken encryptedToken = new EncryptedTaskToken(taskToken);
        return encryptedToken.encrypt(this.getEncryptionKey(taskToken.getAccountNumber()));
    }

    @Nonnull
    public TaskToken decryptTaskToken(String accountNumber, String taskToken) throws TaskTokenException {
        if (taskToken == null) {
            throw new TaskTokenException("Missing task token");
        }
        try {
            return EncryptedTaskToken.decrypt(this.getEncryptionKey(accountNumber), taskToken).getTaskToken();
        }
        catch (GeneralSecurityException e) {
            throw new TaskTokenException("Error decrypting task token", e);
        }
    }

    protected String getTokenPassword() {
        return SystemIds.securityTokenPassword();
    }

    private SecretKey getEncryptionKey(String salt) {
        MessageDigest digest = Digest.SHA256.get();
        digest.update(salt.getBytes(Charsets.UTF_8));
        digest.update(this.getTokenPassword().getBytes(Charsets.UTF_8));
        return new SecretKeySpec(digest.digest(), "AES");
    }

    private static final class TaskTokenInput {
        private final InputStream in;

        private TaskTokenInput(byte[] data) {
            this.in = new InflaterInputStream(new ByteArrayInputStream(data));
        }

        private String readString() throws IOException {
            byte[] data = new byte[this.readInt()];
            if (this.in.read(data) != data.length) {
                throw new IOException();
            }
            return new String(data, Charsets.UTF_8);
        }

        private int readInt() throws IOException {
            byte[] data = new byte[4];
            if (this.in.read(data) != 4) {
                throw new IOException();
            }
            return Ints.fromByteArray((byte[])data);
        }

        private long readLong() throws IOException {
            byte[] data = new byte[8];
            if (this.in.read(data) != 8) {
                throw new IOException();
            }
            return Longs.fromByteArray((byte[])data);
        }
    }

    private static final class TaskTokenOutput {
        private final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        private final Deflater deflater = new Deflater(9);
        private final DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)this.byteStream, this.deflater);

        private TaskTokenOutput() {
        }

        private void writeString(String value) throws IOException {
            byte[] data = value.getBytes(Charsets.UTF_8);
            this.writeInt(data.length);
            this.out.write(data);
        }

        private void writeInt(int value) throws IOException {
            this.out.write(Ints.toByteArray((int)value));
        }

        private void writeLong(long value) throws IOException {
            this.out.write(Longs.toByteArray((long)value));
        }

        private byte[] toByteArray() throws IOException {
            this.out.flush();
            this.out.close();
            return this.byteStream.toByteArray();
        }
    }

    private static final class EncryptedTaskToken {
        private static final byte[] TOKEN_PREFIX = new byte[]{101, 117, 115, 119, 0, 1};
        private final TaskToken taskToken;

        private EncryptedTaskToken(TaskToken taskToken) {
            this.taskToken = taskToken;
        }

        public TaskToken getTaskToken() {
            return this.taskToken;
        }

        private byte[] toBytes() {
            try {
                TaskTokenOutput out = new TaskTokenOutput();
                out.writeInt(1);
                out.writeString(this.taskToken.getAccountNumber());
                out.writeString(this.taskToken.getDomainUuid());
                out.writeString(this.taskToken.getRunId());
                out.writeLong(this.taskToken.getScheduledEventId());
                out.writeLong(this.taskToken.getStartedEventId());
                out.writeLong(this.taskToken.getCreated());
                out.writeLong(this.taskToken.getExpires());
                return out.toByteArray();
            }
            catch (IOException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }

        private String encrypt(SecretKey key) {
            try {
                Cipher cipher = Ciphers.AES_GCM.get();
                byte[] iv = new byte[32];
                ((SecureRandom)randomSupplier.get()).nextBytes(iv);
                cipher.init(1, (Key)key, new IvParameterSpec(iv), (SecureRandom)randomSupplier.get());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(TOKEN_PREFIX);
                out.write(iv);
                out.write(cipher.doFinal(this.toBytes()));
                return B64.standard.encString((byte[])out.toByteArray());
            }
            catch (IOException | GeneralSecurityException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }

        private static EncryptedTaskToken decrypt(SecretKey key, String taskToken) throws GeneralSecurityException {
            try {
                Cipher cipher = Ciphers.AES_GCM.get();
                byte[] taskTokenBytes = B64.standard.dec((String)taskToken);
                if (taskTokenBytes.length < 64 + TOKEN_PREFIX.length || !Arrays.equals(TOKEN_PREFIX, Arrays.copyOf(taskTokenBytes, TOKEN_PREFIX.length))) {
                    throw new GeneralSecurityException("Invalid token format");
                }
                cipher.init(2, (Key)key, new IvParameterSpec(taskTokenBytes, TOKEN_PREFIX.length, 32), (SecureRandom)randomSupplier.get());
                int offset = TOKEN_PREFIX.length + 32;
                TaskTokenInput in = new TaskTokenInput(cipher.doFinal(taskTokenBytes, offset, taskTokenBytes.length - offset));
                if (in.readInt() != 1) {
                    throw new GeneralSecurityException("Invalid token format");
                }
                String accountNumber = in.readString();
                String domainUuid = in.readString();
                String runId = in.readString();
                long scheduledEventId = in.readLong();
                long startedEventId = in.readLong();
                long created = in.readLong();
                long expires = in.readLong();
                return new EncryptedTaskToken(new TaskToken(accountNumber, domainUuid, runId, scheduledEventId, startedEventId, created, expires));
            }
            catch (IOException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }
}

