/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.stateful;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.simpleworkflow.ActivityTask;
import com.eucalyptus.simpleworkflow.ActivityTasks;
import com.eucalyptus.simpleworkflow.ActivityType;
import com.eucalyptus.simpleworkflow.ActivityTypes;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.Domains;
import com.eucalyptus.simpleworkflow.NotifyClient;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.Timer;
import com.eucalyptus.simpleworkflow.Timers;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.WorkflowExecutions;
import com.eucalyptus.simpleworkflow.WorkflowHistoryEvent;
import com.eucalyptus.simpleworkflow.WorkflowLock;
import com.eucalyptus.simpleworkflow.WorkflowType;
import com.eucalyptus.simpleworkflow.WorkflowTypes;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskTimedOutEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.DecisionTaskScheduledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.DecisionTaskTimedOutEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.TaskList;
import com.eucalyptus.simpleworkflow.common.model.TimerFiredEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionTimedOutEventAttributes;
import com.eucalyptus.simpleworkflow.persist.PersistenceActivityTasks;
import com.eucalyptus.simpleworkflow.persist.PersistenceActivityTypes;
import com.eucalyptus.simpleworkflow.persist.PersistenceDomains;
import com.eucalyptus.simpleworkflow.persist.PersistenceTimers;
import com.eucalyptus.simpleworkflow.persist.PersistenceWorkflowExecutions;
import com.eucalyptus.simpleworkflow.persist.PersistenceWorkflowTypes;
import com.eucalyptus.simpleworkflow.stateful.PolledNotifications;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimeoutManager {
    private static final Logger logger = Logger.getLogger(TimeoutManager.class);
    private final WorkflowExecutions workflowExecutions = new PersistenceWorkflowExecutions();
    private final WorkflowTypes workflowTypes = new PersistenceWorkflowTypes();
    private final ActivityTasks activityTasks = new PersistenceActivityTasks();
    private final ActivityTypes activityTypes = new PersistenceActivityTypes();
    private final Domains domains = new PersistenceDomains();
    private final Timers timers = new PersistenceTimers();

    public void doTimeouts() {
        this.timeoutActivityTasks();
        this.timeoutDecisionTasksAndWorkflows();
    }

    public void doTimers() {
        final HashSet taskLists = Sets.newHashSet();
        try {
            for (Timer timer : this.timers.listFired(Functions.identity())) {
                try {
                    WorkflowLock lock = WorkflowLock.lock(timer.getOwnerAccountNumber(), timer.getDomainUuid(), timer.getWorkflowRunId());
                    Throwable throwable = null;
                    try {
                        this.timers.withRetries().updateByExample((AbstractPersistent)timer, timer.getOwner(), timer.getDisplayName(), (Function)new Function<Timer, Void>(){

                            public Void apply(Timer timer) {
                                WorkflowExecution workflowExecution = timer.getWorkflowExecution();
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new TimerFiredEventAttributes().withStartedEventId(timer.getStartedEventId()).withTimerId(timer.getDisplayName())));
                                if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                    workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                    if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                        workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                        workflowExecution.setDecisionTimestamp(new Date());
                                        TimeoutManager.this.addToNotifyLists(taskLists, workflowExecution);
                                    }
                                }
                                Entities.delete((Object)((Object)timer));
                                return null;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (lock == null) continue;
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        lock.close();
                    }
                }
                catch (SwfMetadataException e) {
                    if (this.handleException(e)) continue;
                    logger.error((Object)("Error processing fired timer: " + timer.getWorkflowRunId() + "/" + timer.getStartedEventId()), (Throwable)e);
                }
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing fired timers", (Throwable)e);
        }
        this.notifyLists(taskLists);
    }

    public void doExpunge() {
        try {
            for (WorkflowExecution workflowExecution : this.workflowExecutions.listRetentionExpired(System.currentTimeMillis(), Functions.identity())) {
                logger.debug((Object)("Removing workflow execution with expired retention period: " + workflowExecution.getDisplayName() + "/" + workflowExecution.getWorkflowId()));
                this.workflowExecutions.deleteByExample(workflowExecution);
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing workflow execution retention expiry", (Throwable)e);
        }
        try {
            for (ActivityType activityType : this.activityTypes.listDeprecatedExpired(System.currentTimeMillis(), Functions.identity())) {
                logger.debug((Object)("Removing expired deprecated activity type: " + activityType.getDisplayName() + "/" + activityType.getActivityVersion()));
                this.activityTypes.deleteByExample(activityType);
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing deprecated activity type expiry", (Throwable)e);
        }
        try {
            for (WorkflowType workflowType : this.workflowTypes.listDeprecatedExpired(System.currentTimeMillis(), Functions.identity())) {
                logger.debug((Object)("Removing expired deprecated workflow type: " + workflowType.getDisplayName() + "/" + workflowType.getWorkflowVersion()));
                this.workflowTypes.deleteByExample(workflowType);
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing deprecated workflow type expiry", (Throwable)e);
        }
        try {
            for (Domain domain : this.domains.listDeprecatedExpired(System.currentTimeMillis(), Functions.identity())) {
                logger.debug((Object)("Removing domain with expired retention period: " + domain.getDisplayName()));
                this.domains.deleteByExample(domain);
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing domain retention expiry", (Throwable)e);
        }
    }

    private void timeoutActivityTasks() {
        final HashSet taskLists = Sets.newHashSet();
        try {
            for (ActivityTask task : this.activityTasks.listTimedOut(Functions.identity())) {
                try {
                    WorkflowLock lock = WorkflowLock.lock(task.getOwnerAccountNumber(), task.getDomainUuid(), task.getWorkflowRunId());
                    Throwable throwable = null;
                    try {
                        this.activityTasks.withRetries().updateByExample((AbstractPersistent)task, task.getOwner(), task.getDisplayName(), (Function)new Function<ActivityTask, Void>(){

                            public Void apply(ActivityTask activityTask) {
                                Pair<String, Date> timeout = activityTask.calculateNextTimeout();
                                if (timeout != null) {
                                    WorkflowExecution workflowExecution = activityTask.getWorkflowExecution();
                                    workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskTimedOutEventAttributes().withDetails(activityTask.getHeartbeatDetails()).withScheduledEventId(activityTask.getScheduledEventId()).withStartedEventId(activityTask.getStartedEventId()).withTimeoutType((String)timeout.getLeft())));
                                    if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                        workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                        if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                            workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                            workflowExecution.setDecisionTimestamp(new Date());
                                            TimeoutManager.this.addToNotifyLists(taskLists, workflowExecution);
                                        }
                                    }
                                    Entities.delete((Object)((Object)activityTask));
                                }
                                return null;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (lock == null) continue;
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        lock.close();
                    }
                }
                catch (SwfMetadataException e) {
                    if (this.handleException(e)) continue;
                    logger.error((Object)("Error processing activity task timeout: " + task.getWorkflowRunId() + "/" + task.getScheduledEventId()), (Throwable)e);
                }
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing activity task timeouts", (Throwable)e);
        }
        this.notifyLists(taskLists);
    }

    private void timeoutDecisionTasksAndWorkflows() {
        final HashSet taskLists = Sets.newHashSet();
        try {
            final long now = System.currentTimeMillis();
            for (WorkflowExecution workflowExecution : this.workflowExecutions.listTimedOut(now, Functions.identity())) {
                try {
                    WorkflowLock lock = WorkflowLock.lock(workflowExecution.getOwnerAccountNumber(), workflowExecution.getDomainUuid(), workflowExecution.getDisplayName());
                    Throwable throwable = null;
                    try {
                        this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)workflowExecution, workflowExecution.getOwner(), workflowExecution.getDisplayName(), (Function)new Function<WorkflowExecution, Void>(){

                            public Void apply(WorkflowExecution workflowExecution) {
                                Date timeout = workflowExecution.calculateNextTimeout();
                                if (timeout != null) {
                                    if (workflowExecution.isWorkflowTimedOut(now, SimpleWorkflowProperties.getWorkflowExecutionDurationMillis())) {
                                        workflowExecution.closeWorkflow(WorkflowExecution.CloseStatus.Timed_Out, WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionTimedOutEventAttributes().withTimeoutType("START_TO_CLOSE").withChildPolicy(workflowExecution.getChildPolicy())));
                                    } else {
                                        List<WorkflowHistoryEvent> events = workflowExecution.getWorkflowHistory();
                                        List reverseEvents = Lists.reverse(events);
                                        WorkflowHistoryEvent scheduled = (WorkflowHistoryEvent)((Object)Iterables.find((Iterable)reverseEvents, (Predicate)CollectionUtils.propertyPredicate((Object)"DecisionTaskScheduled", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE)));
                                        Optional previousStarted = Iterables.tryFind((Iterable)reverseEvents, (Predicate)CollectionUtils.propertyPredicate((Object)"DecisionTaskStarted", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE));
                                        workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskTimedOutEventAttributes().withTimeoutType("START_TO_CLOSE").withScheduledEventId(scheduled.getEventId()).withStartedEventId((Long)previousStarted.transform((Function)WorkflowExecutions.WorkflowHistoryEventLongFunctions.EVENT_ID).orNull())));
                                        workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                        workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                        workflowExecution.setDecisionTimestamp(new Date());
                                        TimeoutManager.this.addToNotifyLists(taskLists, workflowExecution);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (lock == null) continue;
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        lock.close();
                    }
                }
                catch (SwfMetadataException e) {
                    if (this.handleException(e)) continue;
                    logger.error((Object)("Error processing workflow execution/decision task timeout: " + workflowExecution.getDisplayName()), (Throwable)e);
                }
            }
        }
        catch (SwfMetadataException e) {
            logger.error((Object)"Error processing workflow execution/decision task timeouts", (Throwable)e);
        }
        this.notifyLists(taskLists);
    }

    private boolean handleException(Throwable e) {
        WorkflowExecution.WorkflowHistorySizeLimitException historySizeLimitCause = (WorkflowExecution.WorkflowHistorySizeLimitException)Exceptions.findCause((Throwable)e, WorkflowExecution.WorkflowHistorySizeLimitException.class);
        if (historySizeLimitCause != null) {
            WorkflowExecutions.Utils.terminateWorkflowExecution(this.workflowExecutions, "EVENT_LIMIT_EXCEEDED", historySizeLimitCause.getAccountNumber(), historySizeLimitCause.getDomain(), historySizeLimitCause.getWorkflowId());
            return true;
        }
        return false;
    }

    private void addToNotifyLists(Collection<NotifyClient.NotifyTaskList> taskLists, WorkflowExecution workflowExecution) {
        taskLists.add(new NotifyClient.NotifyTaskList(workflowExecution.getOwnerAccountNumber(), workflowExecution.getDomainName(), "decision", workflowExecution.getTaskList()));
    }

    private void notifyLists(Set<NotifyClient.NotifyTaskList> taskLists) {
        for (NotifyClient.NotifyTaskList list : taskLists) {
            NotifyClient.notifyTaskList(list);
        }
    }

    public static class TimeoutManagerEventListener
    implements EventListener<ClockTick> {
        private final TimeoutManager timeoutManager = new TimeoutManager();

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new TimeoutManagerEventListener());
        }

        public void fireEvent(ClockTick event) {
            if (Bootstrap.isOperational().booleanValue() && Topology.isEnabledLocally(PolledNotifications.class) && Topology.isEnabled(SimpleWorkflow.class)) {
                this.timeoutManager.doTimeouts();
                this.timeoutManager.doTimers();
                this.timeoutManager.doExpunge();
            }
        }
    }
}

