/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.stateful;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.simpleworkflow.stateful.PolledNotificationChecker;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.lang.reflect.Modifier;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class PolledNotificationCheckerDiscovery
extends ServiceJarDiscovery {
    private static final Logger logger = Logger.getLogger(PolledNotificationCheckerDiscovery.class);
    private static final CopyOnWriteArrayList<PolledNotificationChecker> checkers = new CopyOnWriteArrayList();

    public boolean processClass(Class candidate) throws Exception {
        if (!(!PolledNotificationChecker.class.isAssignableFrom(candidate) || Modifier.isAbstract(candidate.getModifiers()) || Modifier.isInterface(candidate.getModifiers()) || candidate.isLocalClass() || candidate.isAnonymousClass())) {
            try {
                checkers.add((PolledNotificationChecker)candidate.newInstance());
                logger.debug((Object)("Discovered polled notification checker: " + candidate.getName()));
            }
            catch (Throwable ex) {
                logger.error((Object)("Error in discovery for " + candidate.getName()), ex);
            }
            return true;
        }
        return false;
    }

    static Supplier<Iterable<PolledNotificationChecker>> supplier() {
        return new Supplier<Iterable<PolledNotificationChecker>>(){

            public Iterable<PolledNotificationChecker> get() {
                return Iterables.unmodifiableIterable((Iterable)checkers);
            }
        };
    }

    public Double getPriority() {
        return 0.3;
    }
}

