/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.util.RestrictedTypes;
import net.sf.json.JSONException;

@PolicyKey(value="swf:quota-domainnumber")
public class DomainNumberQuotaKey
extends QuotaKey {
    public static final String KEY = "swf:quota-domainnumber";

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"swf", (String)"registerdomain").equals(action);
    }

    public String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        switch (scope) {
            case ACCOUNT: {
                return Long.toString((Long)RestrictedTypes.quantityMetricFunction(SimpleWorkflowMetadata.DomainMetadata.class).apply((Object)AccountFullName.getInstance((String)id, (String[])new String[0])) + quantity);
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return Long.toString((Long)RestrictedTypes.quantityMetricFunction(SimpleWorkflowMetadata.DomainMetadata.class).apply((Object)UserFullName.getInstance((String)id, (String[])new String[0])) + quantity);
            }
        }
        throw new AuthException("Invalid scope");
    }
}

