/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.WorkflowType;
import com.eucalyptus.simpleworkflow.WorkflowTypes;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.persist.SwfPersistenceSupport;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceWorkflowTypes
extends SwfPersistenceSupport<SimpleWorkflowMetadata.WorkflowTypeMetadata, WorkflowType>
implements WorkflowTypes {
    public PersistenceWorkflowTypes() {
        super("workflow-type");
    }

    @Override
    public long countByDomain(OwnerFullName ownerFullName, String domain) throws SwfMetadataException {
        return this.countByExample((AbstractPersistent)WorkflowType.exampleWithOwner(ownerFullName), (Criterion)Restrictions.eq((String)"domain.displayName", (Object)domain), Collections.singletonMap("domain", "domain"));
    }

    @Override
    public <T> List<T> listDeprecatedExpired(long time, Function<? super WorkflowType, T> transform) throws SwfMetadataException {
        return this.listByExample((AbstractPersistent)WorkflowType.exampleWithOwner(null), Predicates.alwaysTrue(), (Criterion)Restrictions.conjunction().add(Restrictions.isEmpty((String)"executions")).add((Criterion)Restrictions.lt((String)"deprecationTimestamp", (Object)new Date(time - SimpleWorkflowProperties.getDeprecatedWorkflowTypeRetentionDurationMillis()))), Collections.emptyMap(), transform);
    }

    protected WorkflowType exampleWithOwner(OwnerFullName ownerFullName) {
        return WorkflowType.exampleWithOwner(ownerFullName);
    }

    protected WorkflowType exampleWithName(OwnerFullName ownerFullName, String name) {
        return WorkflowType.exampleWithName(ownerFullName, name);
    }
}

