/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.WorkflowExecutions;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.persist.SwfPersistenceSupport;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceWorkflowExecutions
extends SwfPersistenceSupport<SimpleWorkflowMetadata.WorkflowExecutionMetadata, WorkflowExecution>
implements WorkflowExecutions {
    public PersistenceWorkflowExecutions() {
        super("workflow-execution");
    }

    @Override
    public <T> List<T> listTimedOut(long time, Function<? super WorkflowExecution, T> transform) throws SwfMetadataException {
        return this.listByExample((AbstractPersistent)WorkflowExecution.exampleForOpenWorkflow(), Predicates.alwaysTrue(), (Criterion)Restrictions.disjunction().add((Criterion)Restrictions.lt((String)"timeoutTimestamp", (Object)new Date(time))).add((Criterion)Restrictions.lt((String)"creationTimestamp", (Object)new Date(time - SimpleWorkflowProperties.getWorkflowExecutionDurationMillis()))), Collections.emptyMap(), transform);
    }

    @Override
    public <T> List<T> listRetentionExpired(long time, Function<? super WorkflowExecution, T> transform) throws SwfMetadataException {
        return this.listByExample((AbstractPersistent)WorkflowExecution.exampleForClosedWorkflow(), Predicates.alwaysTrue(), (Criterion)Restrictions.disjunction().add((Criterion)Restrictions.lt((String)"retentionTimestamp", (Object)new Date(time))).add((Criterion)Restrictions.lt((String)"closeTimestamp", (Object)new Date(time - SimpleWorkflowProperties.getWorkflowExecutionRetentionDurationMillis()))), Collections.emptyMap(), transform);
    }

    @Override
    public long countOpenByDomain(OwnerFullName ownerFullName, String domain) throws SwfMetadataException {
        return this.countByExample((AbstractPersistent)WorkflowExecution.exampleForOpenWorkflow(ownerFullName, domain, null));
    }

    protected WorkflowExecution exampleWithOwner(OwnerFullName ownerFullName) {
        return WorkflowExecution.exampleWithOwner(ownerFullName);
    }

    protected WorkflowExecution exampleWithName(OwnerFullName ownerFullName, String name) {
        return WorkflowExecution.exampleWithName(ownerFullName, name);
    }
}

