/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.Domains;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.persist.SwfPersistenceSupport;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceDomains
extends SwfPersistenceSupport<SimpleWorkflowMetadata.DomainMetadata, Domain>
implements Domains {
    public PersistenceDomains() {
        super("domain");
    }

    @Override
    public <T> List<T> listDeprecatedExpired(long time, Function<? super Domain, T> transform) throws SwfMetadataException {
        return this.listByExample((AbstractPersistent)Domain.exampleWithStatus(Domain.Status.Deprecated), Predicates.alwaysTrue(), (Criterion)Restrictions.conjunction().add(Restrictions.isEmpty((String)"workflowTypes")).add((Criterion)Restrictions.lt((String)"lastUpdateTimestamp", (Object)new Date(time - SimpleWorkflowProperties.getDeprecatedDomainRetentionDurationMillis()))), Collections.emptyMap(), transform);
    }

    protected Domain exampleWithOwner(OwnerFullName ownerFullName) {
        return Domain.exampleWithOwner(ownerFullName);
    }

    protected Domain exampleWithName(OwnerFullName ownerFullName, String name) {
        return Domain.exampleWithName(ownerFullName, name);
    }
}

