/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.simpleworkflow.ActivityType;
import com.eucalyptus.simpleworkflow.ActivityTypes;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.persist.SwfPersistenceSupport;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceActivityTypes
extends SwfPersistenceSupport<SimpleWorkflowMetadata.ActivityTypeMetadata, ActivityType>
implements ActivityTypes {
    public PersistenceActivityTypes() {
        super("activity-type");
    }

    @Override
    public long countByDomain(OwnerFullName ownerFullName, String domain) throws SwfMetadataException {
        return this.countByExample((AbstractPersistent)ActivityType.exampleWithOwner(ownerFullName), (Criterion)Restrictions.eq((String)"domain.displayName", (Object)domain), Collections.singletonMap("domain", "domain"));
    }

    @Override
    public <T> List<T> listDeprecatedExpired(long time, Function<? super ActivityType, T> transform) throws SwfMetadataException {
        return this.listByExample((AbstractPersistent)ActivityType.exampleWithOwner(null), Predicates.alwaysTrue(), (Criterion)Restrictions.lt((String)"deprecationTimestamp", (Object)new Date(time - SimpleWorkflowProperties.getDeprecatedActivityTypeRetentionDurationMillis())), Collections.emptyMap(), transform);
    }

    protected ActivityType exampleWithOwner(OwnerFullName ownerFullName) {
        return ActivityType.exampleWithOwner(ownerFullName);
    }

    protected ActivityType exampleWithName(OwnerFullName ownerFullName, String name) {
        return ActivityType.exampleWithName(ownerFullName, name);
    }
}

