/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.WorkflowType;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadatas;
import com.eucalyptus.simpleworkflow.common.model.TaskList;
import com.eucalyptus.simpleworkflow.common.model.WorkflowTypeConfiguration;
import com.eucalyptus.simpleworkflow.common.model.WorkflowTypeDetail;
import com.eucalyptus.simpleworkflow.common.model.WorkflowTypeInfo;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface WorkflowTypes {
    public <T> T lookupByExample(WorkflowType var1, @Nullable OwnerFullName var2, String var3, Predicate<? super WorkflowType> var4, Function<? super WorkflowType, T> var5) throws SwfMetadataException;

    public <T> List<T> list(OwnerFullName var1, Predicate<? super WorkflowType> var2, Function<? super WorkflowType, T> var3) throws SwfMetadataException;

    public <T> List<T> listDeprecatedExpired(long var1, Function<? super WorkflowType, T> var3) throws SwfMetadataException;

    public WorkflowType updateByExample(WorkflowType var1, OwnerFullName var2, String var3, Callback<WorkflowType> var4) throws SwfMetadataException;

    public WorkflowType save(WorkflowType var1) throws SwfMetadataException;

    public long countByDomain(OwnerFullName var1, String var2) throws SwfMetadataException;

    public List<WorkflowType> deleteByExample(WorkflowType var1) throws SwfMetadataException;

    public static enum WorkflowTypeInfoStringFunctions implements Function<WorkflowTypeInfo, String>
    {
        NAME{

            @Nullable
            public String apply(@Nullable WorkflowTypeInfo workflowTypeInfo) {
                return workflowTypeInfo == null || workflowTypeInfo.getWorkflowType() == null ? null : workflowTypeInfo.getWorkflowType().getName();
            }
        };

    }

    public static enum StringFunctions implements Function<WorkflowType, String>
    {
        DOMAIN{

            @Nullable
            public String apply(@Nullable WorkflowType workflowType) {
                return workflowType == null ? null : (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)workflowType.getDomain());
            }
        }
        ,
        REGISTRATION_STATUS{

            @Nullable
            public String apply(@Nullable WorkflowType workflowType) {
                return workflowType == null ? null : Objects.toString(workflowType.getState(), null);
            }
        };

    }

    @TypeMapper
    public static enum WorkflowTypeToWorkflowTypeInfoTransform implements Function<WorkflowType, WorkflowTypeInfo>
    {
        INSTANCE;


        @Nullable
        public WorkflowTypeInfo apply(@Nullable WorkflowType workflowType) {
            return workflowType == null ? null : new WorkflowTypeInfo().withWorkflowType(new com.eucalyptus.simpleworkflow.common.model.WorkflowType().withName(workflowType.getDisplayName()).withVersion(workflowType.getWorkflowVersion())).withDescription(workflowType.getDescription()).withCreationDate(workflowType.getCreationTimestamp()).withDeprecationDate(workflowType.getDeprecationTimestamp()).withStatus(Objects.toString(workflowType.getState(), null));
        }
    }

    @TypeMapper
    public static enum WorkflowTypeToWorkflowTypeDetailTransform implements Function<WorkflowType, WorkflowTypeDetail>
    {
        INSTANCE;


        @Nullable
        public WorkflowTypeDetail apply(@Nullable WorkflowType workflowType) {
            return workflowType == null ? null : new WorkflowTypeDetail().withConfiguration(new WorkflowTypeConfiguration().withDefaultTaskList(new TaskList().withName(workflowType.getDefaultTaskList())).withDefaultChildPolicy(workflowType.getDefaultChildPolicy()).withDefaultExecutionStartToCloseTimeout(this.timeout(workflowType.getDefaultExecutionStartToCloseTimeout())).withDefaultTaskStartToCloseTimeout(this.timeout(workflowType.getDefaultTaskStartToCloseTimeout()))).withTypeInfo((WorkflowTypeInfo)TypeMappers.transform((Object)((Object)workflowType), WorkflowTypeInfo.class));
        }

        private String timeout(Integer timeout) {
            return (String)Optional.fromNullable((Object)timeout).transform(Functions.toStringFunction()).or((Object)"NONE");
        }
    }
}

