/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadatas;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_workflow_type")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class WorkflowType
extends UserMetadata<Status>
implements SimpleWorkflowMetadata.WorkflowTypeMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="domain_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Domain domain;
    @Column(name="workflow_version", length=64, nullable=false, updatable=false)
    private String workflowVersion;
    @Column(name="description", length=1024, updatable=false)
    private String description;
    @Column(name="default_task_list", length=256, updatable=false)
    private String defaultTaskList;
    @Column(name="default_task_start_to_close_timeout")
    private Integer defaultTaskStartToCloseTimeout;
    @Column(name="default_exec_start_to_close_timeout")
    private Integer defaultExecutionStartToCloseTimeout;
    @Column(name="default_child_policy")
    private String defaultChildPolicy;
    @Column(name="deprecation_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deprecationTimestamp;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="workflowType")
    private Collection<WorkflowExecution> executions;

    protected WorkflowType() {
    }

    protected WorkflowType(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static WorkflowType create(OwnerFullName owner, String name, String version, Domain domain, String description, String defaultTaskList, String defaultChildPolicy, Integer defaultExecutionStartToCloseTimeout, Integer defaultTaskStartToCloseTimeout) {
        WorkflowType workflowType = new WorkflowType(owner, name);
        workflowType.setState(Status.Registered);
        workflowType.setWorkflowVersion(version);
        workflowType.setDomain(domain);
        workflowType.setDescription(description);
        workflowType.setDefaultTaskList(defaultTaskList);
        workflowType.setDefaultChildPolicy(defaultChildPolicy);
        workflowType.setDefaultExecutionStartToCloseTimeout(defaultExecutionStartToCloseTimeout);
        workflowType.setDefaultTaskStartToCloseTimeout(defaultTaskStartToCloseTimeout);
        return workflowType;
    }

    public static WorkflowType exampleWithOwner(OwnerFullName owner) {
        return new WorkflowType(owner, null);
    }

    public static WorkflowType exampleWithName(OwnerFullName owner, String name) {
        return new WorkflowType(owner, name);
    }

    public static WorkflowType exampleWithUniqueName(OwnerFullName owner, String domain, String name, String version) {
        WorkflowType workflowType = new WorkflowType(owner, name);
        workflowType.setUniqueName(WorkflowType.createUniqueName(owner.getAccountNumber(), domain, name, version));
        return workflowType;
    }

    protected String createUniqueName() {
        return WorkflowType.createUniqueName(this.getOwnerAccountNumber(), (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)this.getDomain()), this.getDisplayName(), this.getWorkflowVersion());
    }

    private static String createUniqueName(String accountNumber, String domain, String name, String version) {
        return accountNumber + ":" + domain + ":" + name + ":" + version;
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((SimpleWorkflow)ComponentIds.lookup(SimpleWorkflow.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"domain", (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)this.getDomain()), "workflow-type", this.getDisplayName(), "version", this.getWorkflowVersion()});
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public String getWorkflowVersion() {
        return this.workflowVersion;
    }

    public void setWorkflowVersion(String workflowVersion) {
        this.workflowVersion = workflowVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultTaskList() {
        return this.defaultTaskList;
    }

    public void setDefaultTaskList(String defaultTaskList) {
        this.defaultTaskList = defaultTaskList;
    }

    public Integer getDefaultTaskStartToCloseTimeout() {
        return this.defaultTaskStartToCloseTimeout;
    }

    public void setDefaultTaskStartToCloseTimeout(Integer defaultTaskStartToCloseTimeout) {
        this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
    }

    public Integer getDefaultExecutionStartToCloseTimeout() {
        return this.defaultExecutionStartToCloseTimeout;
    }

    public void setDefaultExecutionStartToCloseTimeout(Integer defaultExecutionStartToCloseTimeout) {
        this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
    }

    public String getDefaultChildPolicy() {
        return this.defaultChildPolicy;
    }

    public void setDefaultChildPolicy(String defaultChildPolicy) {
        this.defaultChildPolicy = defaultChildPolicy;
    }

    public Date getDeprecationTimestamp() {
        return this.deprecationTimestamp;
    }

    public void setDeprecationTimestamp(Date deprecationTimestamp) {
        this.deprecationTimestamp = deprecationTimestamp;
    }

    public static enum Status implements Predicate<UserMetadata<Status>>
    {
        Registered,
        Deprecated;


        public String toString() {
            return this.name().toUpperCase();
        }

        public boolean apply(@Nullable UserMetadata<Status> metadata) {
            return metadata != null && metadata.getState() == this;
        }

        public Function<WorkflowType, WorkflowType> set() {
            return new Function<WorkflowType, WorkflowType>(){

                @Nullable
                public WorkflowType apply(@Nullable WorkflowType workflowType) {
                    if (workflowType != null && !Status.this.apply(workflowType)) {
                        workflowType.setState(Status.this);
                        workflowType.setDeprecationTimestamp(new Date());
                    }
                    return workflowType;
                }
            };
        }
    }
}

