/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.util.Pair;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class WorkflowLock
implements AutoCloseable {
    private static final Interner<WorkflowLock> workflowLockInterner = Interners.newWeakInterner();
    private final Lock lock = new ReentrantLock();
    private final String accountNumber;
    private final String domainUuid;
    private final String runId;

    public static WorkflowLock lock(AccountFullName accountFullName, Domain domain, String runId) {
        return WorkflowLock.lock(accountFullName.getAccountNumber(), domain.getNaturalId(), runId);
    }

    public static WorkflowLock lock(AccountFullName accountFullName, Pair<String, String> domainUuidRunIdPair) {
        return WorkflowLock.lock(accountFullName.getAccountNumber(), (String)domainUuidRunIdPair.getLeft(), (String)domainUuidRunIdPair.getRight());
    }

    public static WorkflowLock lock(AccountFullName accountFullName, String domainUuid, String runId) {
        return WorkflowLock.lock(accountFullName.getAccountNumber(), domainUuid, runId);
    }

    public static WorkflowLock lock(String accountNumber, String domainUuid, String runId) {
        return ((WorkflowLock)workflowLockInterner.intern((Object)new WorkflowLock(accountNumber, domainUuid, runId))).lock();
    }

    WorkflowLock(String accountNumber, String domainUuid, String runId) {
        this.accountNumber = accountNumber;
        this.domainUuid = domainUuid;
        this.runId = runId;
    }

    public WorkflowLock lock() {
        this.lock.lock();
        return this;
    }

    @Override
    public void close() {
        this.lock.unlock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowLock that = (WorkflowLock)o;
        if (!this.accountNumber.equals(that.accountNumber)) {
            return false;
        }
        if (!this.domainUuid.equals(that.domainUuid)) {
            return false;
        }
        return this.runId.equals(that.runId);
    }

    public int hashCode() {
        int result = this.accountNumber.hashCode();
        result = 31 * result + this.domainUuid.hashCode();
        result = 31 * result + this.runId.hashCode();
        return result;
    }
}

