/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.simpleworkflow.SwfJsonUtils;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.common.model.WorkflowEventAttributes;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Strings;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_workflow_history_event")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class WorkflowHistoryEvent
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="workflow_execution_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private WorkflowExecution workflowExecution;
    @Column(name="event_order", nullable=false, updatable=false)
    private Long eventOrder;
    @Column(name="event_type", nullable=false, updatable=false)
    private String eventType;
    @Column(name="event_attributes", nullable=false, updatable=false)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String eventAttributes;

    protected WorkflowHistoryEvent() {
    }

    public static WorkflowHistoryEvent create(WorkflowExecution execution, WorkflowEventAttributes attributes) {
        WorkflowHistoryEvent workflowHistoryEvent = new WorkflowHistoryEvent();
        workflowHistoryEvent.setWorkflowExecution(execution);
        workflowHistoryEvent.setEventType(Strings.trimSuffix((String)"EventAttributes", (String)attributes.getClass().getSimpleName()));
        workflowHistoryEvent.setEventAttributes(SwfJsonUtils.writeObjectAsString(attributes));
        workflowHistoryEvent.updateTimeStamps();
        return workflowHistoryEvent;
    }

    public WorkflowEventAttributes toAttributes() {
        try {
            return (WorkflowEventAttributes)SwfJsonUtils.readObject(this.getEventAttributes(), Class.forName(WorkflowEventAttributes.class.getPackage().getName() + "." + this.getEventType() + "EventAttributes"));
        }
        catch (Exception e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    public Long getEventId() {
        return (Long)Objects.firstNonNull((Object)this.getEventOrder(), (Object)0L) + 1L;
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    public Long getEventOrder() {
        return this.eventOrder;
    }

    public void setEventOrder(Long eventOrder) {
        this.eventOrder = eventOrder;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventAttributes() {
        return this.eventAttributes;
    }

    public void setEventAttributes(String eventAttributes) {
        this.eventAttributes = eventAttributes;
    }
}

