/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.entities.AbstractPersistentSupport;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.WorkflowHistoryEvent;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.common.model.HistoryEvent;
import com.eucalyptus.simpleworkflow.common.model.TaskList;
import com.eucalyptus.simpleworkflow.common.model.WorkflowEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecution;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionConfiguration;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionDetail;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionInfo;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionTerminatedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowType;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;

public interface WorkflowExecutions {
    public static final Set<String> ACTIVITY_CLOSE_EVENT_TYPES = ImmutableSet.of((Object)"ActivityTaskCompleted", (Object)"ActivityTaskFailed", (Object)"ActivityTaskTimedOut", (Object)"ActivityTaskCanceled");
    public static final Set<String> TIMER_CLOSE_EVENT_TYPES = ImmutableSet.of((Object)"TimerCanceled", (Object)"TimerFired");

    public <T> List<T> listByExample(com.eucalyptus.simpleworkflow.WorkflowExecution var1, Predicate<? super com.eucalyptus.simpleworkflow.WorkflowExecution> var2, Function<? super com.eucalyptus.simpleworkflow.WorkflowExecution, T> var3) throws SwfMetadataException;

    public <T> List<T> listByExample(com.eucalyptus.simpleworkflow.WorkflowExecution var1, Predicate<? super com.eucalyptus.simpleworkflow.WorkflowExecution> var2, Criterion var3, Map<String, String> var4, Function<? super com.eucalyptus.simpleworkflow.WorkflowExecution, T> var5) throws SwfMetadataException;

    public <T> List<T> listTimedOut(long var1, Function<? super com.eucalyptus.simpleworkflow.WorkflowExecution, T> var3) throws SwfMetadataException;

    public <T> List<T> listRetentionExpired(long var1, Function<? super com.eucalyptus.simpleworkflow.WorkflowExecution, T> var3) throws SwfMetadataException;

    public <T> T lookupByExample(com.eucalyptus.simpleworkflow.WorkflowExecution var1, @Nullable OwnerFullName var2, String var3, Predicate<? super com.eucalyptus.simpleworkflow.WorkflowExecution> var4, Function<? super com.eucalyptus.simpleworkflow.WorkflowExecution, T> var5) throws SwfMetadataException;

    public <T> T updateByExample(com.eucalyptus.simpleworkflow.WorkflowExecution var1, OwnerFullName var2, String var3, Function<? super com.eucalyptus.simpleworkflow.WorkflowExecution, T> var4) throws SwfMetadataException;

    public com.eucalyptus.simpleworkflow.WorkflowExecution save(com.eucalyptus.simpleworkflow.WorkflowExecution var1) throws SwfMetadataException;

    public List<com.eucalyptus.simpleworkflow.WorkflowExecution> deleteByExample(com.eucalyptus.simpleworkflow.WorkflowExecution var1) throws SwfMetadataException;

    public long countOpenByDomain(OwnerFullName var1, String var2) throws SwfMetadataException;

    public AbstractPersistentSupport<SimpleWorkflowMetadata.WorkflowExecutionMetadata, com.eucalyptus.simpleworkflow.WorkflowExecution, SwfMetadataException> withRetries();

    public static enum WorkflowHistoryEventLongFunctions implements Function<WorkflowHistoryEvent, Long>
    {
        EVENT_ID{

            @Nullable
            public Long apply(@Nullable WorkflowHistoryEvent workflowHistoryEvent) {
                return workflowHistoryEvent == null ? null : workflowHistoryEvent.getEventId();
            }
        };

    }

    public static enum WorkflowHistoryEventStringFunctions implements Function<WorkflowHistoryEvent, String>
    {
        EVENT_TYPE{

            @Nullable
            public String apply(@Nullable WorkflowHistoryEvent workflowHistoryEvent) {
                return workflowHistoryEvent == null ? null : workflowHistoryEvent.getEventType();
            }
        };

    }

    public static enum WorkflowExecutionInfoDateFunctions implements Function<WorkflowExecutionInfo, Date>
    {
        START_TIMESTAMP{

            @Nullable
            public Date apply(@Nullable WorkflowExecutionInfo workflowExecutionInfo) {
                return workflowExecutionInfo == null ? null : workflowExecutionInfo.getStartTimestamp();
            }
        };

    }

    public static enum WorkflowExecutionStringFunctions implements Function<com.eucalyptus.simpleworkflow.WorkflowExecution, String>
    {
        DOMAIN_UUID{

            @Nullable
            public String apply(@Nullable com.eucalyptus.simpleworkflow.WorkflowExecution workflowExecution) {
                return workflowExecution == null ? null : workflowExecution.getDomainUuid();
            }
        };

    }

    @TypeMapper
    public static enum WorkflowHistoryEventToHistoryEventTransform implements Function<WorkflowHistoryEvent, HistoryEvent>
    {
        INSTANCE;


        @Nullable
        public HistoryEvent apply(@Nullable WorkflowHistoryEvent event) {
            if (event == null) {
                return null;
            }
            HistoryEvent historyEvent = new HistoryEvent().withEventId(event.getEventId()).withEventType(event.getEventType()).withEventTimestamp(event.getCreationTimestamp());
            WorkflowEventAttributes attributes = event.toAttributes();
            attributes.attach(historyEvent);
            return historyEvent;
        }
    }

    @TypeMapper
    public static enum WorkflowExecutionToWorkflowExecutionInfoTransform implements Function<com.eucalyptus.simpleworkflow.WorkflowExecution, WorkflowExecutionInfo>
    {
        INSTANCE;


        @Nullable
        public WorkflowExecutionInfo apply(@Nullable com.eucalyptus.simpleworkflow.WorkflowExecution execution) {
            if (execution == null) {
                return null;
            }
            return new WorkflowExecutionInfo().withCancelRequested(execution.getCancelRequested()).withCloseStatus(Objects.toString((Object)execution.getCloseStatus(), null)).withCloseTimestamp(execution.getCloseTimestamp()).withExecution(new WorkflowExecution().withRunId(execution.getDisplayName()).withWorkflowId(execution.getWorkflowId())).withExecutionStatus(Objects.toString(execution.getState())).withStartTimestamp(execution.getCreationTimestamp()).withTagList(execution.getTagList()).withWorkflowType(new WorkflowType().withName(execution.getWorkflowType().getDisplayName()).withVersion(execution.getWorkflowType().getWorkflowVersion()));
        }
    }

    @TypeMapper
    public static enum WorkflowExecutionToWorkflowExecutionDetailTransform implements Function<com.eucalyptus.simpleworkflow.WorkflowExecution, WorkflowExecutionDetail>
    {
        INSTANCE;


        @Nullable
        public WorkflowExecutionDetail apply(@Nullable com.eucalyptus.simpleworkflow.WorkflowExecution execution) {
            if (execution == null) {
                return null;
            }
            return new WorkflowExecutionDetail().withExecutionConfiguration(new WorkflowExecutionConfiguration().withChildPolicy(execution.getChildPolicy()).withExecutionStartToCloseTimeout(Objects.toString(execution.getExecutionStartToCloseTimeout(), "NONE")).withTaskList(new TaskList().withName(execution.getTaskList())).withTaskStartToCloseTimeout(Objects.toString(execution.getTaskStartToCloseTimeout(), "NONE"))).withExecutionInfo((WorkflowExecutionInfo)TypeMappers.transform((Object)((Object)execution), WorkflowExecutionInfo.class)).withLatestActivityTaskTimestamp(execution.getLatestActivityTaskScheduled()).withLatestExecutionContext(execution.getLatestExecutionContext());
        }
    }

    public static class Utils {
        private static final Logger logger = Logger.getLogger(WorkflowExecutions.class);

        public static void terminateWorkflowExecution(WorkflowExecutions workflowExecutions, final String cause, String accountNumber, String domain, String workflowId) {
            try {
                AccountFullName accountFullName = AccountFullName.getInstance((String)accountNumber, (String[])new String[0]);
                workflowExecutions.updateByExample(com.eucalyptus.simpleworkflow.WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, domain, workflowId), (OwnerFullName)accountFullName, workflowId, new Function<com.eucalyptus.simpleworkflow.WorkflowExecution, Void>(){

                    public Void apply(com.eucalyptus.simpleworkflow.WorkflowExecution workflowExecution) {
                        workflowExecution.closeWorkflow(WorkflowExecution.CloseStatus.Terminated, WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionTerminatedEventAttributes().withCause(cause).withChildPolicy(workflowExecution.getChildPolicy())));
                        return null;
                    }
                });
            }
            catch (SwfMetadataException e) {
                logger.error((Object)("Error terminating workflow execution for account " + accountNumber + ", domain " + domain + ", " + workflowId), (Throwable)e);
            }
        }
    }
}

