/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.simpleworkflow.ActivityTask;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.Timer;
import com.eucalyptus.simpleworkflow.WorkflowHistoryEvent;
import com.eucalyptus.simpleworkflow.WorkflowType;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadatas;
import com.eucalyptus.simpleworkflow.common.model.WorkflowEventAttributes;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_workflow_execution")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class WorkflowExecution
extends UserMetadata<ExecutionStatus>
implements SimpleWorkflowMetadata.WorkflowExecutionMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="domain_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Domain domain;
    @ManyToOne
    @JoinColumn(name="workflow_type_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private WorkflowType workflowType;
    @Column(name="workflow_id", length=256, nullable=false, updatable=false)
    private String workflowId;
    @Column(name="child_policy", nullable=false, updatable=false)
    private String childPolicy;
    @Column(name="domain", length=256, nullable=false, updatable=false)
    private String domainName;
    @Column(name="domain_uuid", nullable=false, updatable=false)
    private String domainUuid;
    @Column(name="task_list", length=256, nullable=false, updatable=false)
    private String taskList;
    @Column(name="exec_start_to_close_timeout", nullable=false, updatable=false)
    private Integer executionStartToCloseTimeout;
    @Column(name="task_start_to_close_timeout", updatable=false)
    private Integer taskStartToCloseTimeout;
    @Column(name="cancel_requested", nullable=false)
    private Boolean cancelRequested;
    @Column(name="decision_status")
    @Enumerated(value=EnumType.STRING)
    private DecisionStatus decisionStatus;
    @Column(name="decision_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date decisionTimestamp;
    @Column(name="close_status")
    @Enumerated(value=EnumType.STRING)
    private CloseStatus closeStatus;
    @Column(name="close_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date closeTimestamp;
    @Column(name="retention_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date retentionTimestamp;
    @ElementCollection
    @CollectionTable(name="swf_workflow_execution_tags")
    @Column(name="tag", length=256)
    @JoinColumn(name="workflow_execution_id")
    @OrderColumn(name="tag_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<String> tagList;
    @Column(name="latest_activity_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date latestActivityTaskScheduled;
    @Column(name="latest_execution_context")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String latestExecutionContext;
    @Column(name="timeout_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timeoutTimestamp;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="workflowExecution")
    @OrderBy(value="eventOrder")
    private List<WorkflowHistoryEvent> workflowHistory;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="workflowExecution")
    @OrderColumn(name="scheduled_event_id")
    private List<ActivityTask> activityTasks;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="workflowExecution")
    @OrderColumn(name="decision_task_comp_event_id")
    private List<Timer> timers;

    protected WorkflowExecution() {
    }

    protected WorkflowExecution(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static WorkflowExecution create(OwnerFullName owner, String name, Domain domain, WorkflowType workflowType, String workflowId, String childPolicy, String taskList, @Nullable Integer executionStartToCloseTimeout, @Nullable Integer taskStartToCloseTimeout, List<String> tags, List<WorkflowEventAttributes> eventAttributes) {
        WorkflowExecution workflowExecution = new WorkflowExecution(owner, name);
        workflowExecution.setDomain(domain);
        workflowExecution.setDomainName(domain.getDisplayName());
        workflowExecution.setDomainUuid(domain.getNaturalId());
        workflowExecution.setWorkflowType(workflowType);
        workflowExecution.setWorkflowId(workflowId);
        workflowExecution.setState(ExecutionStatus.Open);
        workflowExecution.setChildPolicy(childPolicy);
        workflowExecution.setTaskList(taskList);
        workflowExecution.setExecutionStartToCloseTimeout(executionStartToCloseTimeout);
        workflowExecution.setTaskStartToCloseTimeout(taskStartToCloseTimeout);
        workflowExecution.setTagList(tags);
        workflowExecution.setCancelRequested(false);
        workflowExecution.setDecisionStatus(DecisionStatus.Pending);
        workflowExecution.setDecisionTimestamp(new Date());
        workflowExecution.setWorkflowHistory(Lists.newArrayList());
        for (WorkflowEventAttributes attributes : eventAttributes) {
            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, attributes));
        }
        return workflowExecution;
    }

    public Date calculateNextTimeout() {
        Long timeout = (Long)CollectionUtils.reduce((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])new Long[]{WorkflowExecution.toTimeout(this.getCreationTimestamp(), this.getExecutionStartToCloseTimeout()), WorkflowExecution.toTimeout(this.getDecisionTimestamp(), this.getDecisionStatus() == DecisionStatus.Active ? this.getTaskStartToCloseTimeout() : null)}), (Predicate)Predicates.notNull()), (Object)Long.MAX_VALUE, (Function)CollectionUtils.lmin());
        return timeout == Long.MAX_VALUE ? null : new Date(timeout);
    }

    public boolean isWorkflowTimedOut(long timestamp, long maximumDurationMillis) {
        Long timeout = WorkflowExecution.toTimeout(this.getCreationTimestamp(), this.getExecutionStartToCloseTimeout());
        return timeout != null && timeout < timestamp || maximumDurationMillis > 0L && this.getCreationTimestamp().getTime() + maximumDurationMillis < timestamp;
    }

    private static Long toTimeout(Date from, Integer period) {
        return period == null ? null : Long.valueOf(from.getTime() + TimeUnit.SECONDS.toMillis(period.intValue()));
    }

    public static WorkflowExecution exampleWithOwner(OwnerFullName owner) {
        return new WorkflowExecution(owner, null);
    }

    public static WorkflowExecution exampleWithName(OwnerFullName owner, String name) {
        return new WorkflowExecution(owner, name);
    }

    public static WorkflowExecution exampleWithPendingDecision(OwnerFullName owner, String domain, String taskList) {
        WorkflowExecution workflowExecution = new WorkflowExecution(owner, null);
        workflowExecution.setDomainName(domain);
        workflowExecution.setTaskList(taskList);
        workflowExecution.setDecisionStatus(DecisionStatus.Pending);
        workflowExecution.setState(ExecutionStatus.Open);
        return workflowExecution;
    }

    public static WorkflowExecution exampleWithUniqueName(OwnerFullName owner, String domain, String runId) {
        WorkflowExecution workflowExecution = new WorkflowExecution(owner, runId);
        workflowExecution.setUniqueName(WorkflowExecution.createUniqueName(owner.getAccountNumber(), domain, runId));
        return workflowExecution;
    }

    public static WorkflowExecution exampleForOpenWorkflow() {
        return WorkflowExecution.exampleForOpenWorkflow(null, null, null);
    }

    public static WorkflowExecution exampleForOpenWorkflow(OwnerFullName owner, String domain, String workflowId) {
        return WorkflowExecution.exampleForOpenWorkflow(owner, domain, workflowId, null);
    }

    public static WorkflowExecution exampleForOpenWorkflow(OwnerFullName owner, String domain, String workflowId, String runId) {
        WorkflowExecution workflowExecution = new WorkflowExecution(owner, runId);
        workflowExecution.setDomainName(domain);
        workflowExecution.setWorkflowId(workflowId);
        workflowExecution.setState(ExecutionStatus.Open);
        workflowExecution.setStateChangeStack(null);
        workflowExecution.setLastState(null);
        return workflowExecution;
    }

    public static WorkflowExecution exampleForClosedWorkflow() {
        return WorkflowExecution.exampleForClosedWorkflow(null, null, null);
    }

    public static WorkflowExecution exampleForClosedWorkflow(OwnerFullName owner, String domain, String workflowId) {
        WorkflowExecution workflowExecution = new WorkflowExecution(owner, null);
        workflowExecution.setDomainName(domain);
        workflowExecution.setWorkflowId(workflowId);
        workflowExecution.setState(ExecutionStatus.Closed);
        workflowExecution.setStateChangeStack(null);
        workflowExecution.setLastState(null);
        return workflowExecution;
    }

    protected String createUniqueName() {
        return WorkflowExecution.createUniqueName(this.getOwnerAccountNumber(), (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)this.getDomain()), this.getDisplayName());
    }

    private static String createUniqueName(String accountNumber, String domain, String runId) {
        return accountNumber + ":" + domain + ":" + runId;
    }

    public Long addHistoryEvent(WorkflowHistoryEvent event) throws WorkflowHistorySizeLimitException {
        event.setEventOrder(Long.valueOf(this.workflowHistory.size()));
        this.workflowHistory.add(event);
        if (this.workflowHistory.size() > SimpleWorkflowProperties.getWorkflowExecutionHistorySize()) {
            throw new WorkflowHistorySizeLimitException(this);
        }
        this.updateTimeStamps();
        return event.getEventId();
    }

    public void closeWorkflow(CloseStatus closeStatus, WorkflowHistoryEvent event) {
        this.setState(ExecutionStatus.Closed);
        this.setCloseStatus(closeStatus);
        this.setCloseTimestamp(new Date());
        this.setRetentionTimestamp(new Date(this.getCloseTimestamp().getTime() + TimeUnit.DAYS.toMillis(this.getDomain().getWorkflowExecutionRetentionPeriodInDays().intValue())));
        this.addHistoryEvent(event);
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((SimpleWorkflow)ComponentIds.lookup(SimpleWorkflow.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"domain", (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)this.getDomain()), "run-id", this.getDisplayName()});
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getChildPolicy() {
        return this.childPolicy;
    }

    public void setChildPolicy(String childPolicy) {
        this.childPolicy = childPolicy;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainUuid() {
        return this.domainUuid;
    }

    public void setDomainUuid(String domainUuid) {
        this.domainUuid = domainUuid;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public Integer getExecutionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public void setExecutionStartToCloseTimeout(Integer executionStartToCloseTimeout) {
        this.executionStartToCloseTimeout = executionStartToCloseTimeout;
    }

    public Integer getTaskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public void setTaskStartToCloseTimeout(Integer taskStartToCloseTimeout) {
        this.taskStartToCloseTimeout = taskStartToCloseTimeout;
    }

    public Boolean getCancelRequested() {
        return this.cancelRequested;
    }

    public void setCancelRequested(Boolean cancelRequested) {
        this.cancelRequested = cancelRequested;
    }

    public DecisionStatus getDecisionStatus() {
        return this.decisionStatus;
    }

    public void setDecisionStatus(DecisionStatus decisionStatus) {
        this.decisionStatus = decisionStatus;
    }

    public Date getDecisionTimestamp() {
        return this.decisionTimestamp;
    }

    public void setDecisionTimestamp(Date decisionTimestamp) {
        this.decisionTimestamp = decisionTimestamp;
    }

    public CloseStatus getCloseStatus() {
        return this.closeStatus;
    }

    public void setCloseStatus(CloseStatus closeStatus) {
        this.closeStatus = closeStatus;
    }

    public Date getCloseTimestamp() {
        return this.closeTimestamp;
    }

    public void setCloseTimestamp(Date closeTimestamp) {
        this.closeTimestamp = closeTimestamp;
    }

    public Date getRetentionTimestamp() {
        return this.retentionTimestamp;
    }

    public void setRetentionTimestamp(Date retentionTimestamp) {
        this.retentionTimestamp = retentionTimestamp;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public Date getLatestActivityTaskScheduled() {
        return this.latestActivityTaskScheduled;
    }

    public void setLatestActivityTaskScheduled(Date latestActivityTaskScheduled) {
        this.latestActivityTaskScheduled = latestActivityTaskScheduled;
    }

    public String getLatestExecutionContext() {
        return this.latestExecutionContext;
    }

    public void setLatestExecutionContext(String latestExecutionContext) {
        this.latestExecutionContext = latestExecutionContext;
    }

    public Date getTimeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    public void setTimeoutTimestamp(Date timeoutTimestamp) {
        this.timeoutTimestamp = timeoutTimestamp;
    }

    public List<WorkflowHistoryEvent> getWorkflowHistory() {
        return this.workflowHistory;
    }

    public void setWorkflowHistory(List<WorkflowHistoryEvent> workflowHistory) {
        this.workflowHistory = workflowHistory;
    }

    @PreUpdate
    @PrePersist
    protected void updateTimeout() {
        this.updateTimeStamps();
        this.setTimeoutTimestamp(this.calculateNextTimeout());
    }

    public static final class WorkflowHistorySizeLimitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String accountNumber;
        private final String domain;
        private final String runId;
        private final String workflowId;

        public WorkflowHistorySizeLimitException(WorkflowExecution workflowExecution) {
            this(workflowExecution.getOwnerAccountNumber(), workflowExecution.getDomainName(), workflowExecution.getDisplayName(), workflowExecution.getWorkflowId());
        }

        public WorkflowHistorySizeLimitException(String accountNumber, String domain, String runId, String workflowId) {
            this.accountNumber = accountNumber;
            this.domain = domain;
            this.runId = runId;
            this.workflowId = workflowId;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getRunId() {
            return this.runId;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }
    }

    public static enum DecisionStatus {
        Idle,
        Pending,
        Active;

    }

    public static enum CloseStatus {
        Completed,
        Failed,
        Canceled,
        Terminated,
        Continued_As_New,
        Timed_Out;


        public String toString() {
            return this.name().toUpperCase();
        }

        public static CloseStatus fromString(String value) {
            return (CloseStatus)((Object)Iterables.tryFind(Arrays.asList(CloseStatus.values()), (Predicate)CollectionUtils.propertyPredicate((Object)value, (Function)Functions.toStringFunction())).or((Object)Completed));
        }
    }

    public static enum ExecutionStatus {
        Open,
        Closed;


        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

