/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.util.OwnerFullName;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_timer")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Timer
extends AbstractOwnedPersistent
implements SimpleWorkflowMetadata.ActivityTaskMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="workflow_execution_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private WorkflowExecution workflowExecution;
    @Column(name="domain", length=256, nullable=false, updatable=false)
    private String domain;
    @Column(name="domain_uuid", nullable=false, updatable=false)
    private String domainUuid;
    @Column(name="workflow_run_id", nullable=false, updatable=false)
    private String workflowRunId;
    @Column(name="decision_task_comp_event_id", nullable=false, updatable=false)
    private Long decisionTaskCompletedEventId;
    @Column(name="started_event_id", nullable=false, updatable=false)
    private Long startedEventId;
    @Column(name="control", updatable=false)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String control;
    @Column(name="start_to_fire_timeout", nullable=false, updatable=false)
    private Integer startToFireTimeout;
    @Column(name="timeout_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timeoutTimestamp;

    protected Timer() {
    }

    protected Timer(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static Timer create(OwnerFullName ownerFullName, WorkflowExecution workflowExecution, String domain, String domainUuid, String timerId, String control, Integer startToFireTimeout, Long decisionTaskCompletedEventId, Long startedEventId) {
        Timer timer = new Timer(ownerFullName, timerId);
        timer.setWorkflowExecution(workflowExecution);
        timer.setDomain(domain);
        timer.setDomainUuid(domainUuid);
        timer.setWorkflowRunId(workflowExecution.getDisplayName());
        timer.setControl(control);
        timer.setStartToFireTimeout(startToFireTimeout);
        timer.setDecisionTaskCompletedEventId(decisionTaskCompletedEventId);
        timer.setStartedEventId(startedEventId);
        return timer;
    }

    public static Timer exampleWithOwner(OwnerFullName owner) {
        return new Timer(owner, null);
    }

    public static Timer exampleWithTimerId(OwnerFullName owner, String domainName, String runId, String timerId) {
        Timer timer = new Timer(owner, timerId);
        timer.setDomain(domainName);
        timer.setWorkflowRunId(runId);
        return timer;
    }

    public static Timer exampleWithWorkflowExecution(OwnerFullName owner, String domainName, String runId) {
        Timer timer = new Timer(owner, null);
        timer.setDomain(domainName);
        timer.setWorkflowRunId(runId);
        return timer;
    }

    public static Timer exampleWithUniqueName(OwnerFullName owner, String runId, String timerId) {
        Timer timer = new Timer(owner, null);
        timer.setUniqueName(Timer.createUniqueName(owner.getAccountNumber(), runId, timerId));
        return timer;
    }

    private static String createUniqueName(String accountNumber, String runId, String timerId) {
        return accountNumber + ":" + runId + ":" + timerId;
    }

    protected String createUniqueName() {
        return Timer.createUniqueName(this.getOwnerAccountNumber(), this.getWorkflowExecution().getDisplayName(), this.getDisplayName());
    }

    public Date calculateTimeout() {
        Long timeout = Timer.toTimeout(this.getCreationTimestamp(), this.startToFireTimeout);
        return timeout == Long.MAX_VALUE ? null : new Date(timeout);
    }

    private static Long toTimeout(Date from, Integer period) {
        return period == null ? null : Long.valueOf(from.getTime() + TimeUnit.SECONDS.toMillis(period.intValue()));
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomainUuid() {
        return this.domainUuid;
    }

    public void setDomainUuid(String domainUuid) {
        this.domainUuid = domainUuid;
    }

    public String getWorkflowRunId() {
        return this.workflowRunId;
    }

    public void setWorkflowRunId(String workflowRunId) {
        this.workflowRunId = workflowRunId;
    }

    public Long getDecisionTaskCompletedEventId() {
        return this.decisionTaskCompletedEventId;
    }

    public void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
        this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
    }

    public Long getStartedEventId() {
        return this.startedEventId;
    }

    public void setStartedEventId(Long startedEventId) {
        this.startedEventId = startedEventId;
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public Integer getStartToFireTimeout() {
        return this.startToFireTimeout;
    }

    public void setStartToFireTimeout(Integer startToFireTimeout) {
        this.startToFireTimeout = startToFireTimeout;
    }

    public Date getTimeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    public void setTimeoutTimestamp(Date timeoutTimestamp) {
        this.timeoutTimestamp = timeoutTimestamp;
    }

    @PreUpdate
    @PrePersist
    protected void updateTimeout() {
        this.updateTimeStamps();
        this.setTimeoutTimestamp(this.calculateTimeout());
    }
}

