/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.simpleworkflow.common.model.ActivityTaskStatus;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskTimeoutType;
import com.eucalyptus.simpleworkflow.common.model.CancelTimerFailedCause;
import com.eucalyptus.simpleworkflow.common.model.CancelWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.ChildPolicy;
import com.eucalyptus.simpleworkflow.common.model.CloseStatus;
import com.eucalyptus.simpleworkflow.common.model.CloseStatusFilter;
import com.eucalyptus.simpleworkflow.common.model.CompleteWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.ContinueAsNewWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.Decision;
import com.eucalyptus.simpleworkflow.common.model.DecisionTaskTimeoutType;
import com.eucalyptus.simpleworkflow.common.model.DecisionType;
import com.eucalyptus.simpleworkflow.common.model.EventType;
import com.eucalyptus.simpleworkflow.common.model.ExecutionStatus;
import com.eucalyptus.simpleworkflow.common.model.FailWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.RecordMarkerFailedCause;
import com.eucalyptus.simpleworkflow.common.model.RegistrationStatus;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelActivityTaskFailedCause;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelExternalWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.ScheduleActivityTaskFailedCause;
import com.eucalyptus.simpleworkflow.common.model.SignalExternalWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.SimpleWorkflowMessage;
import com.eucalyptus.simpleworkflow.common.model.StartChildWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.StartChildWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.StartTimerFailedCause;
import com.eucalyptus.simpleworkflow.common.model.WorkflowEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionCancelRequestedCause;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionCount;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionInfo;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionTerminatedCause;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionTimeoutType;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.DateDeserializer;
import org.codehaus.jackson.map.module.SimpleModule;

public class SwfJsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String writeObjectAsString(Object object) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        try {
            mapper.writeValue((OutputStream)out, object);
        }
        catch (IOException ioe) {
            throw Exceptions.toUndeclared((Throwable)ioe);
        }
        return new String(out.toByteArray(), Charsets.UTF_8);
    }

    public static void writeObject(OutputStream out, Object object) throws IOException {
        mapper.writeValue(out, object);
    }

    public static <T> T readObject(String in, Class<T> type) throws IOException {
        return (T)mapper.readValue((Reader)new StringReader(in){

            public String toString() {
                return "message";
            }
        }, type);
    }

    static {
        SimpleModule module = new SimpleModule("SwfModule", new Version(1, 0, 0, null)).addSerializer(Date.class, (JsonSerializer)new EpochSecondsDateSerializer()).addDeserializer(Date.class, (JsonDeserializer)new EpochSecondsDateDeserializer());
        mapper.registerModule((Module)module);
        mapper.setDateFormat((DateFormat)new EpochSecondsDateFormat());
        mapper.getSerializationConfig().addMixInAnnotations(SimpleWorkflowMessage.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(WorkflowEventAttributes.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(Decision.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(ContinueAsNewWorkflowExecutionDecisionAttributes.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(StartChildWorkflowExecutionDecisionAttributes.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(ActivityTaskStatus.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(CloseStatusFilter.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(WorkflowExecutionCount.class, BindingMixIn.class);
        mapper.getSerializationConfig().addMixInAnnotations(WorkflowExecutionInfo.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(SimpleWorkflowMessage.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(WorkflowEventAttributes.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(ContinueAsNewWorkflowExecutionDecisionAttributes.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(StartChildWorkflowExecutionDecisionAttributes.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(Decision.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(ActivityTaskStatus.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(CloseStatusFilter.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(WorkflowExecutionCount.class, BindingMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(WorkflowExecutionInfo.class, BindingMixIn.class);
        mapper.getSerializationConfig().set(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    private static final class EpochSecondsDateFormat
    extends DateFormat
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        private EpochSecondsDateFormat() {
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            StringBuffer out;
            StringBuffer stringBuffer = out = toAppendTo == null ? new StringBuffer() : toAppendTo;
            if (date != null) {
                out.append(date.getTime() / 1000L);
                out.append('.');
                out.append(Strings.padStart((String)Long.toString(date.getTime() % 1000L), (int)3, (char)'0'));
            }
            return out;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            if (source != null) {
                try {
                    Number number = DecimalFormat.getInstance(new Locale("en")).parse(source);
                    pos.setIndex(source.length());
                    return new Date((long)(number.doubleValue() * 1000.0));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Object clone() {
            return this;
        }
    }

    private static final class EpochSecondsDateSerializer
    extends JsonSerializer<Date> {
        private EpochSecondsDateSerializer() {
        }

        public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeRawValue(String.valueOf(date.getTime() / 1000L) + "." + Strings.padStart((String)Long.toString(date.getTime() % 1000L), (int)3, (char)'0'));
        }
    }

    private static final class EpochSecondsDateDeserializer
    extends JsonDeserializer<Date> {
        private EpochSecondsDateDeserializer() {
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            switch (token) {
                case VALUE_NUMBER_FLOAT: {
                    return new Date(jsonParser.getDecimalValue().movePointRight(3).longValue());
                }
                case VALUE_NUMBER_INT: {
                    return new Date(jsonParser.getLongValue() * 1000L);
                }
            }
            return new DateDeserializer().deserialize(jsonParser, deserializationContext);
        }
    }

    @JsonIgnoreProperties(value={"correlationId", "effectiveUserId", "reply", "statusMessage", "userId", "_disabledServices", "_notreadyServices", "_stoppedServices", "_epoch", "_services", "_return", "callerContext"})
    private static interface BindingMixIn {
        @JsonIgnore
        public void setCause(CancelTimerFailedCause var1);

        @JsonIgnore
        public void setCause(CancelWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(CompleteWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(ContinueAsNewWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(FailWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(RecordMarkerFailedCause var1);

        @JsonIgnore
        public void setCause(RequestCancelActivityTaskFailedCause var1);

        @JsonIgnore
        public void setCause(RequestCancelExternalWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(ScheduleActivityTaskFailedCause var1);

        @JsonIgnore
        public void setCause(SignalExternalWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(StartChildWorkflowExecutionFailedCause var1);

        @JsonIgnore
        public void setCause(StartTimerFailedCause var1);

        @JsonIgnore
        public void setCause(WorkflowExecutionCancelRequestedCause var1);

        @JsonIgnore
        public void setCause(WorkflowExecutionTerminatedCause var1);

        @JsonIgnore
        public void setChildPolicy(ChildPolicy var1);

        @JsonIgnore
        public void setDecisionType(DecisionType var1);

        @JsonIgnore
        public void setDefaultChildPolicy(ChildPolicy var1);

        @JsonIgnore
        public void setEventType(EventType var1);

        @JsonIgnore
        public void setExecutionStatus(ExecutionStatus var1);

        @JsonIgnore
        public void setRegistrationStatus(RegistrationStatus var1);

        @JsonIgnore
        public void setStatus(CloseStatus var1);

        @JsonIgnore
        public void setStatus(RegistrationStatus var1);

        @JsonIgnore
        public void setTimeoutType(ActivityTaskTimeoutType var1);

        @JsonIgnore
        public void setTimeoutType(DecisionTaskTimeoutType var1);

        @JsonIgnore
        public void setTimeoutType(WorkflowExecutionTimeoutType var1);

        @JsonIgnore
        public Boolean isCancelRequested();

        @JsonIgnore
        public Boolean isTruncated();
    }
}

