/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.auth.AuthQuotaException;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.AbstractPersistentSupport;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.PersistenceExceptions;
import com.eucalyptus.simpleworkflow.ActivityTask;
import com.eucalyptus.simpleworkflow.ActivityTasks;
import com.eucalyptus.simpleworkflow.ActivityType;
import com.eucalyptus.simpleworkflow.ActivityTypes;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.Domains;
import com.eucalyptus.simpleworkflow.NotifyClient;
import com.eucalyptus.simpleworkflow.SimpleWorkflowClientException;
import com.eucalyptus.simpleworkflow.SimpleWorkflowException;
import com.eucalyptus.simpleworkflow.SimpleWorkflowProperties;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.SwfMetadataNotFoundException;
import com.eucalyptus.simpleworkflow.Timer;
import com.eucalyptus.simpleworkflow.Timers;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.WorkflowExecutions;
import com.eucalyptus.simpleworkflow.WorkflowHistoryEvent;
import com.eucalyptus.simpleworkflow.WorkflowLock;
import com.eucalyptus.simpleworkflow.WorkflowType;
import com.eucalyptus.simpleworkflow.WorkflowTypes;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadatas;
import com.eucalyptus.simpleworkflow.common.model.ActivityTask;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskCancelRequestedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskCanceledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskCompletedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskScheduledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskStartedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.ActivityTaskStatus;
import com.eucalyptus.simpleworkflow.common.model.ActivityTypeDetail;
import com.eucalyptus.simpleworkflow.common.model.ActivityTypeInfo;
import com.eucalyptus.simpleworkflow.common.model.ActivityTypeInfos;
import com.eucalyptus.simpleworkflow.common.model.CancelTimerDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.CancelTimerFailedCause;
import com.eucalyptus.simpleworkflow.common.model.CancelTimerFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.CancelWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.ClosedWorkflowExecutionFilterParameters;
import com.eucalyptus.simpleworkflow.common.model.CompleteWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.ContinueAsNewWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.ContinueAsNewWorkflowExecutionFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.CountClosedWorkflowExecutionsRequest;
import com.eucalyptus.simpleworkflow.common.model.CountOpenWorkflowExecutionsRequest;
import com.eucalyptus.simpleworkflow.common.model.CountPendingActivityTasksRequest;
import com.eucalyptus.simpleworkflow.common.model.CountPendingDecisionTasksRequest;
import com.eucalyptus.simpleworkflow.common.model.Decision;
import com.eucalyptus.simpleworkflow.common.model.DecisionTask;
import com.eucalyptus.simpleworkflow.common.model.DecisionTaskCompletedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.DecisionTaskScheduledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.DecisionTaskStartedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.DeprecateActivityTypeRequest;
import com.eucalyptus.simpleworkflow.common.model.DeprecateDomainRequest;
import com.eucalyptus.simpleworkflow.common.model.DeprecateWorkflowTypeRequest;
import com.eucalyptus.simpleworkflow.common.model.DescribeActivityTypeRequest;
import com.eucalyptus.simpleworkflow.common.model.DescribeDomainRequest;
import com.eucalyptus.simpleworkflow.common.model.DescribeWorkflowExecutionRequest;
import com.eucalyptus.simpleworkflow.common.model.DescribeWorkflowTypeRequest;
import com.eucalyptus.simpleworkflow.common.model.DomainDetail;
import com.eucalyptus.simpleworkflow.common.model.DomainInfo;
import com.eucalyptus.simpleworkflow.common.model.DomainInfos;
import com.eucalyptus.simpleworkflow.common.model.FailWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.GetWorkflowExecutionHistoryRequest;
import com.eucalyptus.simpleworkflow.common.model.History;
import com.eucalyptus.simpleworkflow.common.model.HistoryEvent;
import com.eucalyptus.simpleworkflow.common.model.ListActivityTypesRequest;
import com.eucalyptus.simpleworkflow.common.model.ListClosedWorkflowExecutionsRequest;
import com.eucalyptus.simpleworkflow.common.model.ListDomainsRequest;
import com.eucalyptus.simpleworkflow.common.model.ListOpenWorkflowExecutionsRequest;
import com.eucalyptus.simpleworkflow.common.model.ListWorkflowTypesRequest;
import com.eucalyptus.simpleworkflow.common.model.MarkerRecordedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.PendingTaskCount;
import com.eucalyptus.simpleworkflow.common.model.PollForActivityTaskRequest;
import com.eucalyptus.simpleworkflow.common.model.PollForDecisionTaskRequest;
import com.eucalyptus.simpleworkflow.common.model.RecordActivityTaskHeartbeatRequest;
import com.eucalyptus.simpleworkflow.common.model.RecordMarkerDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.RegisterActivityTypeRequest;
import com.eucalyptus.simpleworkflow.common.model.RegisterDomainRequest;
import com.eucalyptus.simpleworkflow.common.model.RegisterWorkflowTypeRequest;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelActivityTaskDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelActivityTaskFailedCause;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelActivityTaskFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelExternalWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.RequestCancelWorkflowExecutionRequest;
import com.eucalyptus.simpleworkflow.common.model.RespondActivityTaskCanceledRequest;
import com.eucalyptus.simpleworkflow.common.model.RespondActivityTaskCompletedRequest;
import com.eucalyptus.simpleworkflow.common.model.RespondActivityTaskFailedRequest;
import com.eucalyptus.simpleworkflow.common.model.RespondDecisionTaskCompletedRequest;
import com.eucalyptus.simpleworkflow.common.model.Run;
import com.eucalyptus.simpleworkflow.common.model.ScheduleActivityTaskDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.ScheduleActivityTaskFailedCause;
import com.eucalyptus.simpleworkflow.common.model.ScheduleActivityTaskFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.SignalExternalWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.SignalExternalWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.SignalExternalWorkflowExecutionFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.SignalWorkflowExecutionRequest;
import com.eucalyptus.simpleworkflow.common.model.SimpleWorkflowMessage;
import com.eucalyptus.simpleworkflow.common.model.StartChildWorkflowExecutionDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.StartChildWorkflowExecutionFailedCause;
import com.eucalyptus.simpleworkflow.common.model.StartChildWorkflowExecutionFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.StartTimerDecisionAttributes;
import com.eucalyptus.simpleworkflow.common.model.StartTimerFailedCause;
import com.eucalyptus.simpleworkflow.common.model.StartTimerFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.StartWorkflowExecutionRequest;
import com.eucalyptus.simpleworkflow.common.model.TaskList;
import com.eucalyptus.simpleworkflow.common.model.TerminateWorkflowExecutionRequest;
import com.eucalyptus.simpleworkflow.common.model.TimerCanceledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.TimerStartedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionCancelRequestedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionCanceledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionCompletedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionCount;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionDetail;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionFailedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionFilterParameters;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionInfo;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionInfos;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionOpenCounts;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionSignaledEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionStartedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowExecutionTerminatedEventAttributes;
import com.eucalyptus.simpleworkflow.common.model.WorkflowTypeDetail;
import com.eucalyptus.simpleworkflow.common.model.WorkflowTypeInfo;
import com.eucalyptus.simpleworkflow.common.model.WorkflowTypeInfos;
import com.eucalyptus.simpleworkflow.tokens.TaskToken;
import com.eucalyptus.simpleworkflow.tokens.TaskTokenException;
import com.eucalyptus.simpleworkflow.tokens.TaskTokenManager;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Consumer;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Pair;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.ws.Role;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.StaleObjectStateException;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;

@ComponentNamed
public class SimpleWorkflowService {
    private static final Logger logger = Logger.getLogger(SimpleWorkflowService.class);
    private final Domains domains;
    private final ActivityTasks activityTasks;
    private final ActivityTypes activityTypes;
    private final WorkflowTypes workflowTypes;
    private final WorkflowExecutions workflowExecutions;
    private final TaskTokenManager taskTokenManager;
    private final Timers timers;

    @Inject
    public SimpleWorkflowService(Domains domains, ActivityTasks activityTasks, ActivityTypes activityTypes, WorkflowTypes workflowTypes, WorkflowExecutions workflowExecutions, TaskTokenManager taskTokenManager, Timers timers) {
        this.domains = domains;
        this.activityTasks = activityTasks;
        this.activityTypes = activityTypes;
        this.workflowTypes = workflowTypes;
        this.workflowExecutions = workflowExecutions;
        this.taskTokenManager = taskTokenManager;
        this.timers = timers;
    }

    public SimpleWorkflowMessage registerDomain(final RegisterDomainRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        this.allocate(new Supplier<Domain>(){

            public Domain get() {
                try {
                    Domain domain = Domain.create((OwnerFullName)userFullName, request.getName(), request.getDescription(), (Integer)Objects.firstNonNull((Object)SimpleWorkflowService.parsePeriod(request.getWorkflowExecutionRetentionPeriodInDays(), 0), (Object)0));
                    return SimpleWorkflowService.this.domains.save(domain);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, Domain.class, request.getName());
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage deprecateDomain(final DeprecateDomainRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byPrivileges().buildPredicate();
        try {
            this.domains.withRetries().updateByExample((AbstractPersistent)Domain.exampleWithName((OwnerFullName)accountFullName, request.getName()), (OwnerFullName)accountFullName, request.getName(), (Callback)new Callback<Domain>(){

                public void fire(Domain domain) {
                    if (accessible.apply((Object)domain)) {
                        try {
                            if (domain.getState() == Domain.Status.Deprecated) {
                                throw SimpleWorkflowService.upClient("DomainDeprecatedFault", "Domain already deprecated: " + request.getName());
                            }
                            domain.setState(Domain.Status.Deprecated);
                            SimpleWorkflowService.this.activityTypes.list((OwnerFullName)accountFullName, (Predicate<? super ActivityType>)CollectionUtils.propertyPredicate((Object)domain.getDisplayName(), (Function)ActivityTypes.StringFunctions.DOMAIN), ActivityType.Status.Deprecated.set());
                            SimpleWorkflowService.this.workflowTypes.list((OwnerFullName)accountFullName, (Predicate<? super WorkflowType>)CollectionUtils.propertyPredicate((Object)domain.getDisplayName(), (Function)WorkflowTypes.StringFunctions.DOMAIN), WorkflowType.Status.Deprecated.set());
                        }
                        catch (Exception e) {
                            throw SimpleWorkflowService.up(e);
                        }
                    }
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Domain not found: " + request.getName());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public DomainInfos listDomains(ListDomainsRequest request) throws SimpleWorkflowException {
        DomainInfos domainInfos = new DomainInfos();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byProperty((Collection)Optional.fromNullable((Object)request.getRegistrationStatus()).asSet(), (Function)Domains.StringFunctions.REGISTRATION_STATUS).byPrivileges().buildPredicate();
        try {
            domainInfos.getDomainInfos().addAll(this.domains.list((OwnerFullName)accountFullName, (Criterion)Restrictions.conjunction(), Collections.emptyMap(), (Predicate<? super Domain>)requestedAndAccessible, TypeMappers.lookup(Domain.class, DomainInfo.class)));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (DomainInfos)request.reply((SimpleWorkflowMessage)domainInfos);
    }

    public DomainDetail describeDomain(DescribeDomainRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byId((Collection)Lists.newArrayList((Object[])new String[]{request.getName()})).byPrivileges().buildPredicate();
        try {
            return (DomainDetail)request.reply((SimpleWorkflowMessage)this.domains.lookupByExample(Domain.exampleWithName((OwnerFullName)accountFullName, request.getName()), (OwnerFullName)accountFullName, request.getName(), (Predicate<? super Domain>)requestedAndAccessible, TypeMappers.lookup(Domain.class, DomainDetail.class)));
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Domain not found: " + request.getName());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public SimpleWorkflowMessage registerActivityType(final RegisterActivityTypeRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        this.allocate(new Supplier<ActivityType>(){

            public ActivityType get() {
                try {
                    Domain domain = (Domain)((Object)SimpleWorkflowService.this.domains.lookupByName((OwnerFullName)accountFullName, request.getDomain(), Domain.Status.Registered, Functions.identity()));
                    if (SimpleWorkflowService.this.activityTypes.countByDomain((OwnerFullName)accountFullName, domain.getDisplayName()) >= (long)SimpleWorkflowProperties.getActivityTypesPerDomain()) {
                        throw SimpleWorkflowService.upClient("LimitExceededFault", "Request would exceed limit for type: activity-type");
                    }
                    ActivityType activityType = ActivityType.create((OwnerFullName)userFullName, request.getName(), request.getVersion(), domain, request.getDescription(), request.getDefaultTaskList() == null ? null : request.getDefaultTaskList().getName(), SimpleWorkflowService.parsePeriod(request.getDefaultTaskHeartbeatTimeout(), -1), SimpleWorkflowService.parsePeriod(request.getDefaultTaskScheduleToCloseTimeout(), -1), SimpleWorkflowService.parsePeriod(request.getDefaultTaskScheduleToStartTimeout(), -1), SimpleWorkflowService.parsePeriod(request.getDefaultTaskStartToCloseTimeout(), -1));
                    return SimpleWorkflowService.this.activityTypes.save(activityType);
                }
                catch (Exception ex) {
                    throw SimpleWorkflowService.up(ex);
                }
            }
        }, ActivityType.class, request.getName());
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage deprecateActivityType(final DeprecateActivityTypeRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(ActivityType.class).byPrivileges().buildPredicate();
        try {
            this.activityTypes.updateByExample(ActivityType.exampleWithUniqueName((OwnerFullName)accountFullName, request.getDomain(), request.getActivityType().getName(), request.getActivityType().getVersion()), (OwnerFullName)accountFullName, request.getActivityType().getName(), new Callback<ActivityType>(){

                public void fire(ActivityType activityType) {
                    if (accessible.apply((Object)activityType)) {
                        if (activityType.getState() == ActivityType.Status.Deprecated) {
                            throw SimpleWorkflowService.upClient("TypeDeprecatedFault", "Activity type already deprecated: " + request.getActivityType().getName());
                        }
                        activityType.setState(ActivityType.Status.Deprecated);
                        activityType.setDeprecationTimestamp(new Date());
                    }
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Activity type not found: " + request.getActivityType().getName());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public ActivityTypeInfos listActivityTypes(ListActivityTypesRequest request) throws SimpleWorkflowException {
        ActivityTypeInfos activityTypeInfos = new ActivityTypeInfos();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = SimpleWorkflowMetadatas.filteringFor(ActivityType.class).byProperty((Collection)Optional.fromNullable((Object)request.getDomain()).asSet(), (Function)ActivityTypes.StringFunctions.DOMAIN).byProperty((Collection)Optional.fromNullable((Object)request.getRegistrationStatus()).asSet(), (Function)ActivityTypes.StringFunctions.REGISTRATION_STATUS).byId((Collection)Optional.fromNullable((Object)request.getName()).asSet()).byPrivileges().buildPredicate();
        try {
            activityTypeInfos.getTypeInfos().addAll(this.activityTypes.list((OwnerFullName)accountFullName, (Predicate<? super ActivityType>)requestedAndAccessible, TypeMappers.lookup(ActivityType.class, ActivityTypeInfo.class)));
            Ordering ordering = Ordering.natural().onResultOf((Function)ActivityTypes.ActivityTypeInfoStringFunctions.NAME);
            Collections.sort(activityTypeInfos.getTypeInfos(), (Boolean)Objects.firstNonNull((Object)request.getReverseOrder(), (Object)Boolean.FALSE) != false ? ordering.reverse() : ordering);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (ActivityTypeInfos)request.reply((SimpleWorkflowMessage)activityTypeInfos);
    }

    public ActivityTypeDetail describeActivityType(DescribeActivityTypeRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(ActivityType.class).byPrivileges().buildPredicate();
        try {
            return (ActivityTypeDetail)request.reply((SimpleWorkflowMessage)this.activityTypes.lookupByExample(ActivityType.exampleWithUniqueName((OwnerFullName)accountFullName, request.getDomain(), request.getActivityType().getName(), request.getActivityType().getVersion()), (OwnerFullName)accountFullName, request.getActivityType().getName(), (Predicate<? super ActivityType>)accessible, TypeMappers.lookup(ActivityType.class, ActivityTypeDetail.class)));
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Activity type not found: " + request.getActivityType().getName());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public SimpleWorkflowMessage registerWorkflowType(final RegisterWorkflowTypeRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        this.allocate(new Supplier<WorkflowType>(){

            public WorkflowType get() {
                try {
                    Domain domain = (Domain)((Object)SimpleWorkflowService.this.domains.lookupByName((OwnerFullName)accountFullName, request.getDomain(), Domain.Status.Registered, Functions.identity()));
                    if (SimpleWorkflowService.this.workflowTypes.countByDomain((OwnerFullName)accountFullName, domain.getDisplayName()) >= (long)SimpleWorkflowProperties.getWorkflowTypesPerDomain()) {
                        throw SimpleWorkflowService.upClient("LimitExceededFault", "Request would exceed limit for type: workflow-type");
                    }
                    WorkflowType workflowType = WorkflowType.create((OwnerFullName)userFullName, request.getName(), request.getVersion(), domain, request.getDescription(), request.getDefaultTaskList() == null ? null : request.getDefaultTaskList().getName(), request.getDefaultChildPolicy(), SimpleWorkflowService.parsePeriod(request.getDefaultExecutionStartToCloseTimeout(), -1), SimpleWorkflowService.parsePeriod(request.getDefaultTaskStartToCloseTimeout(), -1));
                    return SimpleWorkflowService.this.workflowTypes.save(workflowType);
                }
                catch (SwfMetadataNotFoundException e) {
                    throw SimpleWorkflowService.upClient("UnknownResourceFault", "Unknown domain: " + request.getDomain());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, WorkflowType.class, request.getName());
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage deprecateWorkflowType(final DeprecateWorkflowTypeRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowType.class).byPrivileges().buildPredicate();
        try {
            this.workflowTypes.updateByExample(WorkflowType.exampleWithUniqueName((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowType().getName(), request.getWorkflowType().getVersion()), (OwnerFullName)accountFullName, request.getWorkflowType().getName(), new Callback<WorkflowType>(){

                public void fire(WorkflowType workflowType) {
                    if (accessible.apply((Object)workflowType)) {
                        if (workflowType.getState() == WorkflowType.Status.Deprecated) {
                            throw SimpleWorkflowService.upClient("TypeDeprecatedFault", "Workflow type already deprecated: " + request.getWorkflowType().getName());
                        }
                        workflowType.setState(WorkflowType.Status.Deprecated);
                        workflowType.setDeprecationTimestamp(new Date());
                    }
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Workflow type not found: " + request.getWorkflowType().getName());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public WorkflowTypeInfos listWorkflowTypes(ListWorkflowTypesRequest request) throws SimpleWorkflowException {
        WorkflowTypeInfos workflowTypeInfos = new WorkflowTypeInfos();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = SimpleWorkflowMetadatas.filteringFor(WorkflowType.class).byProperty((Collection)Optional.fromNullable((Object)request.getDomain()).asSet(), (Function)WorkflowTypes.StringFunctions.DOMAIN).byProperty((Collection)Optional.fromNullable((Object)request.getRegistrationStatus()).asSet(), (Function)WorkflowTypes.StringFunctions.REGISTRATION_STATUS).byId((Collection)Optional.fromNullable((Object)request.getName()).asSet()).byPrivileges().buildPredicate();
        try {
            workflowTypeInfos.getTypeInfos().addAll(this.workflowTypes.list((OwnerFullName)accountFullName, (Predicate<? super WorkflowType>)requestedAndAccessible, TypeMappers.lookup(WorkflowType.class, WorkflowTypeInfo.class)));
            Ordering ordering = Ordering.natural().onResultOf((Function)WorkflowTypes.WorkflowTypeInfoStringFunctions.NAME);
            Collections.sort(workflowTypeInfos.getTypeInfos(), (Boolean)Objects.firstNonNull((Object)request.getReverseOrder(), (Object)Boolean.FALSE) != false ? ordering.reverse() : ordering);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (WorkflowTypeInfos)request.reply((SimpleWorkflowMessage)workflowTypeInfos);
    }

    public WorkflowTypeDetail describeWorkflowType(DescribeWorkflowTypeRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowType.class).byPrivileges().buildPredicate();
        try {
            return (WorkflowTypeDetail)request.reply((SimpleWorkflowMessage)this.workflowTypes.lookupByExample(WorkflowType.exampleWithUniqueName((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowType().getName(), request.getWorkflowType().getVersion()), (OwnerFullName)accountFullName, request.getWorkflowType().getName(), (Predicate<? super WorkflowType>)accessible, TypeMappers.lookup(WorkflowType.class, WorkflowTypeDetail.class)));
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Workflow type not found: " + request.getWorkflowType().getName());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public WorkflowExecutionDetail describeWorkflowExecution(DescribeWorkflowExecutionRequest request) throws SimpleWorkflowException {
        WorkflowExecutionDetail workflowExecutionDetail;
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            workflowExecutionDetail = this.workflowExecutions.lookupByExample(WorkflowExecution.exampleWithName((OwnerFullName)accountFullName, request.getExecution().getRunId()), (OwnerFullName)accountFullName, request.getExecution().getRunId(), (Predicate<? super WorkflowExecution>)accessible, new Function<WorkflowExecution, WorkflowExecutionDetail>(){

                public WorkflowExecutionDetail apply(WorkflowExecution workflowExecution) {
                    WorkflowExecutionDetail detail = (WorkflowExecutionDetail)TypeMappers.transform((Object)((Object)workflowExecution), WorkflowExecutionDetail.class);
                    List<WorkflowHistoryEvent> events = workflowExecution.getWorkflowHistory();
                    int openActivities = (Integer)CollectionUtils.reduce(events, (Object)0, (Function)CollectionUtils.count((Predicate)CollectionUtils.propertyPredicate((Object)"ActivityTaskScheduled", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE))) - (Integer)CollectionUtils.reduce(events, (Object)0, (Function)CollectionUtils.count((Predicate)CollectionUtils.propertyPredicate(WorkflowExecutions.ACTIVITY_CLOSE_EVENT_TYPES, (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE)));
                    int openTimers = (Integer)CollectionUtils.reduce(events, (Object)0, (Function)CollectionUtils.count((Predicate)CollectionUtils.propertyPredicate((Object)"TimerStarted", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE))) - (Integer)CollectionUtils.reduce(events, (Object)0, (Function)CollectionUtils.count((Predicate)CollectionUtils.propertyPredicate(WorkflowExecutions.TIMER_CLOSE_EVENT_TYPES, (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE)));
                    detail.withOpenCounts(new WorkflowExecutionOpenCounts().withOpenActivityTasks(Integer.valueOf(openActivities)).withOpenChildWorkflowExecutions(Integer.valueOf(0)).withOpenDecisionTasks(Integer.valueOf(workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Idle ? 1 : 0)).withOpenTimers(Integer.valueOf(openTimers)));
                    return detail;
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown execution, runId = " + request.getExecution().getRunId());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (WorkflowExecutionDetail)request.reply((SimpleWorkflowMessage)workflowExecutionDetail);
    }

    public WorkflowExecutionCount countClosedWorkflowExecutions(final CountClosedWorkflowExecutionsRequest request) throws SimpleWorkflowException {
        WorkflowExecutionCount workflowExecutionCount;
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byPrivileges().buildPredicate();
        try {
            workflowExecutionCount = this.domains.lookupByExample(Domain.exampleWithName((OwnerFullName)accountFullName, request.getDomain()), (OwnerFullName)accountFullName, request.getDomain(), (Predicate<? super Domain>)accessible, new Function<Domain, WorkflowExecutionCount>(){

                public WorkflowExecutionCount apply(Domain domain) {
                    Conjunction filter = Restrictions.conjunction();
                    HashMap aliases = Maps.newHashMap();
                    SimpleWorkflowService.buildFilters((ClosedWorkflowExecutionFilterParameters)request, filter, (Map<String, String>)aliases);
                    return new WorkflowExecutionCount().withCount(Integer.valueOf((int)Entities.count((Object)((Object)WorkflowExecution.exampleForClosedWorkflow((OwnerFullName)accountFullName, request.getDomain(), null)), (Criterion)filter, (Map)aliases))).withTruncated(Boolean.valueOf(false));
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown domain, name = " + request.getDomain());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (WorkflowExecutionCount)request.reply((SimpleWorkflowMessage)workflowExecutionCount);
    }

    public WorkflowExecutionCount countOpenWorkflowExecutions(final CountOpenWorkflowExecutionsRequest request) throws SimpleWorkflowException {
        WorkflowExecutionCount workflowExecutionCount;
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byPrivileges().buildPredicate();
        try {
            workflowExecutionCount = this.domains.lookupByExample(Domain.exampleWithName((OwnerFullName)accountFullName, request.getDomain()), (OwnerFullName)accountFullName, request.getDomain(), (Predicate<? super Domain>)accessible, new Function<Domain, WorkflowExecutionCount>(){

                public WorkflowExecutionCount apply(Domain domain) {
                    Conjunction filter = Restrictions.conjunction();
                    HashMap aliases = Maps.newHashMap();
                    SimpleWorkflowService.buildFilters((WorkflowExecutionFilterParameters)request, filter, (Map<String, String>)aliases);
                    return new WorkflowExecutionCount().withCount(Integer.valueOf((int)Entities.count((Object)((Object)WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, request.getDomain(), null)), (Criterion)filter, (Map)aliases))).withTruncated(Boolean.valueOf(false));
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown domain, name = " + request.getDomain());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (WorkflowExecutionCount)request.reply((SimpleWorkflowMessage)workflowExecutionCount);
    }

    public PendingTaskCount countPendingActivityTasks(final CountPendingActivityTasksRequest request) throws SimpleWorkflowException {
        PendingTaskCount pendingTaskCount;
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byPrivileges().buildPredicate();
        try {
            pendingTaskCount = this.domains.lookupByExample(Domain.exampleWithName((OwnerFullName)accountFullName, request.getDomain()), (OwnerFullName)accountFullName, request.getDomain(), (Predicate<? super Domain>)accessible, new Function<Domain, PendingTaskCount>(){

                public PendingTaskCount apply(Domain domain) {
                    return new PendingTaskCount().withCount(Integer.valueOf((int)Entities.count((Object)((Object)com.eucalyptus.simpleworkflow.ActivityTask.examplePending((OwnerFullName)accountFullName, request.getDomain(), request.getTaskList().getName()))))).withTruncated(Boolean.valueOf(false));
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown domain, name = " + request.getDomain());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (PendingTaskCount)request.reply((SimpleWorkflowMessage)pendingTaskCount);
    }

    public PendingTaskCount countPendingDecisionTasks(final CountPendingDecisionTasksRequest request) throws SimpleWorkflowException {
        PendingTaskCount pendingTaskCount;
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(Domain.class).byPrivileges().buildPredicate();
        try {
            pendingTaskCount = this.domains.lookupByExample(Domain.exampleWithName((OwnerFullName)accountFullName, request.getDomain()), (OwnerFullName)accountFullName, request.getDomain(), (Predicate<? super Domain>)accessible, new Function<Domain, PendingTaskCount>(){

                public PendingTaskCount apply(Domain domain) {
                    return new PendingTaskCount().withCount(Integer.valueOf((int)Entities.count((Object)((Object)WorkflowExecution.exampleWithPendingDecision((OwnerFullName)accountFullName, request.getDomain(), request.getTaskList().getName()))))).withTruncated(Boolean.valueOf(false));
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown domain, name = " + request.getDomain());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (PendingTaskCount)request.reply((SimpleWorkflowMessage)pendingTaskCount);
    }

    public WorkflowExecutionInfos listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        WorkflowExecutionInfos workflowExecutionInfos = new WorkflowExecutionInfos();
        try {
            Conjunction filter = Restrictions.conjunction();
            HashMap aliases = Maps.newHashMap();
            SimpleWorkflowService.buildFilters((ClosedWorkflowExecutionFilterParameters)request, filter, (Map<String, String>)aliases);
            workflowExecutionInfos.getExecutionInfos().addAll(this.workflowExecutions.listByExample(WorkflowExecution.exampleForClosedWorkflow((OwnerFullName)accountFullName, request.getDomain(), null), (Predicate<? super WorkflowExecution>)accessible, (Criterion)filter, aliases, TypeMappers.lookup(WorkflowExecution.class, WorkflowExecutionInfo.class)));
            Ordering ordering = Ordering.natural().onResultOf((Function)WorkflowExecutions.WorkflowExecutionInfoDateFunctions.START_TIMESTAMP);
            Collections.sort(workflowExecutionInfos.getExecutionInfos(), (Boolean)Objects.firstNonNull((Object)request.getReverseOrder(), (Object)Boolean.FALSE) != false ? ordering.reverse() : ordering);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (WorkflowExecutionInfos)request.reply((SimpleWorkflowMessage)workflowExecutionInfos);
    }

    public WorkflowExecutionInfos listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        WorkflowExecutionInfos workflowExecutionInfos = new WorkflowExecutionInfos();
        try {
            Conjunction filter = Restrictions.conjunction();
            HashMap aliases = Maps.newHashMap();
            SimpleWorkflowService.buildFilters((WorkflowExecutionFilterParameters)request, filter, (Map<String, String>)aliases);
            workflowExecutionInfos.getExecutionInfos().addAll(this.workflowExecutions.listByExample(WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, request.getDomain(), null), (Predicate<? super WorkflowExecution>)accessible, (Criterion)filter, aliases, TypeMappers.lookup(WorkflowExecution.class, WorkflowExecutionInfo.class)));
            Ordering ordering = Ordering.natural().onResultOf((Function)WorkflowExecutions.WorkflowExecutionInfoDateFunctions.START_TIMESTAMP);
            Collections.sort(workflowExecutionInfos.getExecutionInfos(), (Boolean)Objects.firstNonNull((Object)request.getReverseOrder(), (Object)Boolean.FALSE) != false ? ordering.reverse() : ordering);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (WorkflowExecutionInfos)request.reply((SimpleWorkflowMessage)workflowExecutionInfos);
    }

    public Run startWorkflowExecution(final StartWorkflowExecutionRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowType.class).byPrivileges().buildPredicate();
        WorkflowExecution workflowExecution = this.allocate(new Supplier<WorkflowExecution>(){

            public WorkflowExecution get() {
                try {
                    WorkflowType workflowType;
                    Domain domain;
                    if (!SimpleWorkflowService.this.workflowExecutions.listByExample(WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowId()), (Predicate<? super WorkflowExecution>)Predicates.alwaysTrue(), Functions.identity()).isEmpty()) {
                        throw new SimpleWorkflowClientException("WorkflowExecutionAlreadyStartedFault", "Workflow open with ID " + request.getWorkflowId());
                    }
                    try {
                        domain = (Domain)((Object)SimpleWorkflowService.this.domains.lookupByName((OwnerFullName)accountFullName, request.getDomain(), Domain.Status.Registered, Functions.identity()));
                    }
                    catch (SwfMetadataNotFoundException e) {
                        throw SimpleWorkflowService.upClient("UnknownResourceFault", "Unknown domain: " + request.getDomain());
                    }
                    if (SimpleWorkflowService.this.workflowExecutions.countOpenByDomain((OwnerFullName)accountFullName, domain.getDisplayName()) >= (long)SimpleWorkflowProperties.getOpenWorkflowExecutionsPerDomain()) {
                        throw SimpleWorkflowService.upClient("LimitExceededFault", "Request would exceed limit for open workflow executions");
                    }
                    try {
                        workflowType = (WorkflowType)((Object)SimpleWorkflowService.this.workflowTypes.lookupByExample(WorkflowType.exampleWithUniqueName((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowType().getName(), request.getWorkflowType().getVersion()), (OwnerFullName)accountFullName, request.getWorkflowType().getName(), (Predicate<? super WorkflowType>)Predicates.and((Predicate)accessible, (Predicate)WorkflowType.Status.Registered), Functions.identity()));
                    }
                    catch (SwfMetadataNotFoundException e) {
                        throw SimpleWorkflowService.upClient("UnknownResourceFault", "Unknown workflow type: " + request.getWorkflowType().getName());
                    }
                    if (request.getChildPolicy() == null && workflowType.getDefaultChildPolicy() == null) {
                        throw SimpleWorkflowService.upClient("DefaultUndefinedFault", "Default child policy undefined");
                    }
                    if (request.getTaskList() == null && workflowType.getDefaultTaskList() == null) {
                        throw SimpleWorkflowService.upClient("DefaultUndefinedFault", "Default task list undefined");
                    }
                    String childPolicy = (String)Objects.firstNonNull((Object)request.getChildPolicy(), (Object)workflowType.getDefaultChildPolicy());
                    String taskList = request.getTaskList() == null ? workflowType.getDefaultTaskList() : request.getTaskList().getName();
                    Integer executionStartToCloseTimeout = SimpleWorkflowService.requireDefault(SimpleWorkflowService.parsePeriod(request.getExecutionStartToCloseTimeout(), -1), workflowType.getDefaultExecutionStartToCloseTimeout(), "ExecutionStartToCloseTimeout");
                    Integer taskStartToCloseTimeout = SimpleWorkflowService.requireDefault(SimpleWorkflowService.parsePeriod(request.getTaskStartToCloseTimeout(), -1), workflowType.getDefaultTaskStartToCloseTimeout(), "TaskStartToCloseTimeout");
                    String taskStartToCloseTimeoutStr = taskStartToCloseTimeout < 0 ? "NONE" : String.valueOf(taskStartToCloseTimeout);
                    WorkflowExecution workflowExecution = WorkflowExecution.create((OwnerFullName)userFullName, UUID.randomUUID().toString(), domain, workflowType, request.getWorkflowId(), childPolicy, taskList, executionStartToCloseTimeout, taskStartToCloseTimeout < 0 ? null : taskStartToCloseTimeout, request.getTagList(), Lists.newArrayList((Object[])new WorkflowEventAttributes[]{new WorkflowExecutionStartedEventAttributes().withChildPolicy(childPolicy).withExecutionStartToCloseTimeout(String.valueOf(executionStartToCloseTimeout)).withInput(request.getInput()).withParentInitiatedEventId(Long.valueOf(0L)).withTaskList(new TaskList().withName(taskList)).withTagList((Collection)request.getTagList()).withTaskStartToCloseTimeout(taskStartToCloseTimeoutStr).withWorkflowType(request.getWorkflowType()), new DecisionTaskScheduledEventAttributes().withStartToCloseTimeout(taskStartToCloseTimeoutStr).withTaskList(request.getTaskList())}));
                    return SimpleWorkflowService.this.workflowExecutions.save(workflowExecution);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, WorkflowExecution.class, request.getWorkflowId());
        SimpleWorkflowService.notifyTaskList(accountFullName, workflowExecution.getDomainName(), "decision", workflowExecution.getTaskList());
        Run run = new Run();
        run.setRunId(workflowExecution.getDisplayName());
        return (Run)request.reply((SimpleWorkflowMessage)run);
    }

    public ActivityTask pollForActivityTask(final PollForActivityTaskRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(com.eucalyptus.simpleworkflow.ActivityTask.class).byPrivileges().buildPredicate();
        final String domain = request.getDomain();
        final String taskList = request.getTaskList().getName();
        Callable<ActivityTask> taskCallable = new Callable<ActivityTask>(){

            @Override
            public ActivityTask call() throws Exception {
                ActivityTask activityTask = null;
                List pending = SimpleWorkflowService.this.activityTasks.listByExample(com.eucalyptus.simpleworkflow.ActivityTask.examplePending((OwnerFullName)accountFullName, domain, taskList), (Predicate<? super com.eucalyptus.simpleworkflow.ActivityTask>)accessible, Functions.identity());
                Collections.sort(pending, Ordering.natural().onResultOf(AbstractPersistentSupport.creation()));
                for (com.eucalyptus.simpleworkflow.ActivityTask pendingTask : pending) {
                    if (activityTask != null) break;
                    boolean retry = true;
                    while (retry) {
                        try {
                            WorkflowLock lock = WorkflowLock.lock(accountFullName, pendingTask.getDomainUuid(), pendingTask.getWorkflowRunId());
                            Throwable throwable = null;
                            try {
                                retry = false;
                                activityTask = SimpleWorkflowService.this.activityTasks.updateByExample(pendingTask, (OwnerFullName)accountFullName, pendingTask.getDisplayName(), new Function<com.eucalyptus.simpleworkflow.ActivityTask, ActivityTask>(){

                                    @Nullable
                                    public ActivityTask apply(com.eucalyptus.simpleworkflow.ActivityTask activityTask) {
                                        if (activityTask.getState() == ActivityTask.State.Pending) {
                                            WorkflowExecution workflowExecution = activityTask.getWorkflowExecution();
                                            Long startedId = workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskStartedEventAttributes().withIdentity(request.getIdentity()).withScheduledEventId(activityTask.getScheduledEventId())));
                                            activityTask.setState(ActivityTask.State.Active);
                                            activityTask.setStartedEventId(startedId);
                                            return new ActivityTask().withStartedEventId(startedId).withInput(activityTask.getInput()).withTaskToken(SimpleWorkflowService.this.taskTokenManager.encryptTaskToken(new TaskToken(accountFullName.getAccountNumber(), workflowExecution.getDomain().getNaturalId(), workflowExecution.getDisplayName(), activityTask.getScheduledEventId(), startedId, System.currentTimeMillis(), System.currentTimeMillis()))).withActivityId(activityTask.getDisplayName()).withActivityType(new com.eucalyptus.simpleworkflow.common.model.ActivityType().withName(activityTask.getActivityType()).withVersion(activityTask.getActivityVersion())).withWorkflowExecution(new com.eucalyptus.simpleworkflow.common.model.WorkflowExecution().withRunId(workflowExecution.getDisplayName()).withWorkflowId(workflowExecution.getWorkflowId()));
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (lock == null) continue;
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                lock.close();
                            }
                        }
                        catch (SwfMetadataException e) {
                            logger.info((Object)("Activity task for domain " + domain + ", list " + taskList + " not found"));
                        }
                        catch (Exception e) {
                            StaleObjectStateException stale = (StaleObjectStateException)Exceptions.findCause((Throwable)e, StaleObjectStateException.class);
                            if (stale != null) {
                                try {
                                    Entities.evictCache(Class.forName(stale.getEntityName()));
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                            if (PersistenceExceptions.isStaleUpdate((Throwable)e)) {
                                logger.info((Object)("Activity task for domain " + domain + ", list " + taskList + " already taken"));
                                continue;
                            }
                            if (PersistenceExceptions.isLockError((Throwable)e)) {
                                logger.info((Object)("Activity task for domain " + domain + ", list " + taskList + " locking error, will retry."));
                                Thread.sleep(10L);
                                retry = true;
                                continue;
                            }
                            logger.error((Object)("Error taking activity task for domain " + domain + ", list " + taskList), (Throwable)e);
                        }
                    }
                }
                return activityTask;
            }
        };
        try {
            SimpleWorkflowService.handleTaskPolling(accountFullName, domain, "activity", taskList, request.getCorrelationId(), (SimpleWorkflowMessage)new ActivityTask(), (Callable<? extends SimpleWorkflowMessage>)taskCallable);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return null;
    }

    public ActivityTaskStatus recordActivityTaskHeartbeat(final RecordActivityTaskHeartbeatRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(com.eucalyptus.simpleworkflow.ActivityTask.class).byPrivileges().buildPredicate();
        final ActivityTaskStatus status = new ActivityTaskStatus();
        status.setCancelRequested(Boolean.valueOf(false));
        try {
            TaskToken token = this.taskTokenManager.decryptTaskToken(accountFullName.getAccountNumber(), request.getTaskToken());
            this.activityTasks.withRetries().updateByExample((AbstractPersistent)com.eucalyptus.simpleworkflow.ActivityTask.exampleWithUniqueName((OwnerFullName)accountFullName, token.getRunId(), token.getScheduledEventId()), (OwnerFullName)accountFullName, token.getRunId() + "/" + token.getScheduledEventId(), (Function)new Function<com.eucalyptus.simpleworkflow.ActivityTask, com.eucalyptus.simpleworkflow.ActivityTask>(){

                public com.eucalyptus.simpleworkflow.ActivityTask apply(com.eucalyptus.simpleworkflow.ActivityTask activityTask) {
                    if (accessible.apply((Object)activityTask)) {
                        activityTask.setHeartbeatDetails(request.getDetails());
                        activityTask.updateTimeStamps();
                        status.setCancelRequested(Boolean.valueOf(activityTask.getCancelRequestedEventId() != null));
                    }
                    return activityTask;
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown activity task, token = " + request.getTaskToken());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (ActivityTaskStatus)request.reply((SimpleWorkflowMessage)status);
    }

    public SimpleWorkflowMessage respondActivityTaskCanceled(final RespondActivityTaskCanceledRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(com.eucalyptus.simpleworkflow.ActivityTask.class).byPrivileges().buildPredicate();
        ActivityTaskStatus status = new ActivityTaskStatus();
        status.setCancelRequested(Boolean.valueOf(false));
        try {
            Pair domainTaskListPair;
            TaskToken token = this.taskTokenManager.decryptTaskToken(accountFullName.getAccountNumber(), request.getTaskToken());
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, token.getDomainUuid(), token.getRunId());){
                domainTaskListPair = (Pair)this.activityTasks.withRetries().updateByExample((AbstractPersistent)com.eucalyptus.simpleworkflow.ActivityTask.exampleWithUniqueName((OwnerFullName)accountFullName, token.getRunId(), token.getScheduledEventId()), (OwnerFullName)accountFullName, token.getRunId() + "/" + token.getScheduledEventId(), (Function)new Function<com.eucalyptus.simpleworkflow.ActivityTask, Pair<String, String>>(){

                    public Pair<String, String> apply(com.eucalyptus.simpleworkflow.ActivityTask activityTask) {
                        if (accessible.apply((Object)activityTask)) {
                            WorkflowExecution workflowExecution = activityTask.getWorkflowExecution();
                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskCanceledEventAttributes().withDetails(request.getDetails()).withLatestCancelRequestedEventId(activityTask.getCancelRequestedEventId()).withScheduledEventId(activityTask.getScheduledEventId()).withStartedEventId(activityTask.getStartedEventId())));
                            if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                    workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                    workflowExecution.setDecisionTimestamp(new Date());
                                }
                            }
                            Entities.delete((Object)((Object)activityTask));
                            return workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Pending ? Pair.pair((Object)workflowExecution.getDomainName(), (Object)workflowExecution.getTaskList()) : null;
                        }
                        return null;
                    }
                });
            }
            if (domainTaskListPair != null) {
                SimpleWorkflowService.notifyTaskList(accountFullName, (String)domainTaskListPair.getLeft(), "decision", (String)domainTaskListPair.getRight());
            }
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown activity task, token = " + request.getTaskToken());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage respondActivityTaskCompleted(final RespondActivityTaskCompletedRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            WorkflowExecution workflowExecution;
            final TaskToken token = this.taskTokenManager.decryptTaskToken(accountFullName.getAccountNumber(), request.getTaskToken());
            Domain domain = (Domain)((Object)this.domains.lookupByExample(Domain.exampleWithUuid((OwnerFullName)accountFullName, token.getDomainUuid()), (OwnerFullName)accountFullName, token.getDomainUuid(), (Predicate<? super Domain>)Predicates.alwaysTrue(), Functions.identity()));
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, domain, token.getRunId());){
                workflowExecution = (WorkflowExecution)((Object)this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)WorkflowExecution.exampleWithUniqueName((OwnerFullName)accountFullName, domain.getDisplayName(), token.getRunId()), (OwnerFullName)accountFullName, token.getRunId(), (Function)new Function<WorkflowExecution, WorkflowExecution>(){

                    @Nullable
                    public WorkflowExecution apply(WorkflowExecution workflowExecution) {
                        if (accessible.apply((Object)workflowExecution)) {
                            try {
                                SimpleWorkflowService.this.activityTasks.deleteByExample(com.eucalyptus.simpleworkflow.ActivityTask.exampleWithUniqueName((OwnerFullName)accountFullName, token.getRunId(), token.getScheduledEventId()));
                            }
                            catch (SwfMetadataException e) {
                                throw SimpleWorkflowService.up(e);
                            }
                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskCompletedEventAttributes().withResult(request.getResult()).withScheduledEventId(token.getScheduledEventId()).withStartedEventId(token.getStartedEventId())));
                            if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                    workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                    workflowExecution.setDecisionTimestamp(new Date());
                                }
                            }
                        }
                        return workflowExecution;
                    }
                }));
            }
            if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Pending) {
                SimpleWorkflowService.notifyTaskList(accountFullName, workflowExecution.getDomainName(), "decision", workflowExecution.getTaskList());
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage respondActivityTaskFailed(final RespondActivityTaskFailedRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            WorkflowExecution workflowExecution;
            final TaskToken token = this.taskTokenManager.decryptTaskToken(accountFullName.getAccountNumber(), request.getTaskToken());
            Domain domain = (Domain)((Object)this.domains.lookupByExample(Domain.exampleWithUuid((OwnerFullName)accountFullName, token.getDomainUuid()), (OwnerFullName)accountFullName, token.getDomainUuid(), (Predicate<? super Domain>)Predicates.alwaysTrue(), Functions.identity()));
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, domain, token.getRunId());){
                workflowExecution = (WorkflowExecution)((Object)this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)WorkflowExecution.exampleWithUniqueName((OwnerFullName)accountFullName, domain.getDisplayName(), token.getRunId()), (OwnerFullName)accountFullName, token.getRunId(), (Function)new Function<WorkflowExecution, WorkflowExecution>(){

                    @Nullable
                    public WorkflowExecution apply(WorkflowExecution workflowExecution) {
                        if (accessible.apply((Object)workflowExecution)) {
                            try {
                                SimpleWorkflowService.this.activityTasks.deleteByExample(com.eucalyptus.simpleworkflow.ActivityTask.exampleWithUniqueName((OwnerFullName)accountFullName, token.getRunId(), token.getScheduledEventId()));
                            }
                            catch (SwfMetadataException e) {
                                throw SimpleWorkflowService.up(e);
                            }
                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskFailedEventAttributes().withDetails(request.getDetails()).withReason(request.getReason()).withScheduledEventId(token.getScheduledEventId()).withStartedEventId(token.getStartedEventId())));
                            if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                    workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                    workflowExecution.setDecisionTimestamp(new Date());
                                }
                            }
                        }
                        return workflowExecution;
                    }
                }));
            }
            if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Pending) {
                SimpleWorkflowService.notifyTaskList(accountFullName, workflowExecution.getDomainName(), "decision", workflowExecution.getTaskList());
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public DecisionTask pollForDecisionTask(final PollForDecisionTaskRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        final String domain = request.getDomain();
        final String taskList = request.getTaskList().getName();
        Callable<DecisionTask> taskCallable = new Callable<DecisionTask>(){

            @Override
            public DecisionTask call() throws Exception {
                List pending = SimpleWorkflowService.this.workflowExecutions.listByExample(WorkflowExecution.exampleWithPendingDecision((OwnerFullName)accountFullName, domain, taskList), (Predicate<? super WorkflowExecution>)accessible, Functions.identity());
                Collections.sort(pending, Ordering.natural().onResultOf(AbstractPersistentSupport.creation()));
                DecisionTask decisionTask = null;
                for (WorkflowExecution execution : pending) {
                    if (decisionTask != null) break;
                    boolean retry = true;
                    while (retry) {
                        try {
                            WorkflowLock lock = WorkflowLock.lock(accountFullName, execution.getDomainUuid(), execution.getDisplayName());
                            Throwable throwable = null;
                            try {
                                retry = false;
                                decisionTask = SimpleWorkflowService.this.workflowExecutions.updateByExample(WorkflowExecution.exampleWithUniqueName((OwnerFullName)accountFullName, execution.getDomainName(), execution.getDisplayName()), (OwnerFullName)accountFullName, execution.getDisplayName(), new Function<WorkflowExecution, DecisionTask>(){

                                    @Nullable
                                    public DecisionTask apply(WorkflowExecution workflowExecution) {
                                        if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Pending) {
                                            List<WorkflowHistoryEvent> events = workflowExecution.getWorkflowHistory();
                                            List<WorkflowHistoryEvent> reverseEvents = Lists.reverse(events);
                                            WorkflowHistoryEvent scheduled = (WorkflowHistoryEvent)((Object)Iterables.find((Iterable)reverseEvents, (Predicate)CollectionUtils.propertyPredicate((Object)"DecisionTaskScheduled", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE)));
                                            Optional previousStarted = Iterables.tryFind((Iterable)reverseEvents, (Predicate)CollectionUtils.propertyPredicate((Object)"DecisionTaskStarted", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE));
                                            workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Active);
                                            workflowExecution.setDecisionTimestamp(new Date());
                                            WorkflowHistoryEvent started = WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskStartedEventAttributes().withIdentity(request.getIdentity()).withScheduledEventId(scheduled.getEventId()));
                                            workflowExecution.addHistoryEvent(started);
                                            return new DecisionTask().withWorkflowExecution(new com.eucalyptus.simpleworkflow.common.model.WorkflowExecution().withWorkflowId(workflowExecution.getWorkflowId()).withRunId(workflowExecution.getDisplayName())).withWorkflowType(new com.eucalyptus.simpleworkflow.common.model.WorkflowType().withName(workflowExecution.getWorkflowType().getDisplayName()).withVersion(workflowExecution.getWorkflowType().getWorkflowVersion())).withTaskToken(SimpleWorkflowService.this.taskTokenManager.encryptTaskToken(new TaskToken(accountFullName.getAccountNumber(), workflowExecution.getDomain().getNaturalId(), workflowExecution.getDisplayName(), scheduled.getEventId(), started.getEventId(), System.currentTimeMillis(), System.currentTimeMillis()))).withStartedEventId(started.getEventId()).withPreviousStartedEventId((Long)previousStarted.transform((Function)WorkflowExecutions.WorkflowHistoryEventLongFunctions.EVENT_ID).or((Object)0L)).withEvents(Collections2.transform((Boolean)Objects.firstNonNull((Object)request.isReverseOrder(), (Object)Boolean.FALSE) != false ? reverseEvents : events, (Function)TypeMappers.lookup(WorkflowHistoryEvent.class, HistoryEvent.class)));
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (lock == null) continue;
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                lock.close();
                            }
                        }
                        catch (Exception e) {
                            StaleObjectStateException stale = (StaleObjectStateException)Exceptions.findCause((Throwable)e, StaleObjectStateException.class);
                            if (stale != null) {
                                try {
                                    Entities.evictCache(Class.forName(stale.getEntityName()));
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                            if (PersistenceExceptions.isStaleUpdate((Throwable)e)) {
                                logger.info((Object)("Decision task for workflow " + execution.getDisplayName() + " already taken."));
                                continue;
                            }
                            if (PersistenceExceptions.isLockError((Throwable)e)) {
                                logger.info((Object)("Decision task for workflow " + execution.getDisplayName() + " locking error, will retry."));
                                Thread.sleep(10L);
                                retry = true;
                                continue;
                            }
                            logger.error((Object)("Error taking decision task for workflow " + execution.getDisplayName()), (Throwable)e);
                        }
                    }
                }
                return decisionTask;
            }
        };
        try {
            SimpleWorkflowService.handleTaskPolling(accountFullName, domain, "decision", taskList, request.getCorrelationId(), (SimpleWorkflowMessage)new DecisionTask(), (Callable<? extends SimpleWorkflowMessage>)taskCallable);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return null;
    }

    public SimpleWorkflowMessage respondDecisionTaskCompleted(final RespondDecisionTaskCompletedRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            final TaskToken token = this.taskTokenManager.decryptTaskToken(accountFullName.getAccountNumber(), request.getTaskToken());
            final Domain domain = (Domain)((Object)this.domains.lookupByExample(Domain.exampleWithUuid((OwnerFullName)accountFullName, token.getDomainUuid()), (OwnerFullName)accountFullName, token.getDomainUuid(), (Predicate<? super Domain>)Predicates.alwaysTrue(), Functions.identity()));
            final HashSet notificationTypeListPairs = Sets.newHashSet();
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, domain, token.getRunId());){
                this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)WorkflowExecution.exampleWithUniqueName((OwnerFullName)accountFullName, domain.getDisplayName(), token.getRunId()), (OwnerFullName)accountFullName, token.getRunId(), (Function)new Function<WorkflowExecution, WorkflowExecution>(){

                    @Nullable
                    public WorkflowExecution apply(final WorkflowExecution workflowExecution) {
                        if (accessible.apply((Object)workflowExecution)) {
                            notificationTypeListPairs.clear();
                            List<WorkflowHistoryEvent> events = workflowExecution.getWorkflowHistory();
                            List reverseEvents = Lists.reverse(events);
                            WorkflowHistoryEvent started = (WorkflowHistoryEvent)((Object)Iterables.find((Iterable)reverseEvents, (Predicate)CollectionUtils.propertyPredicate((Object)"DecisionTaskStarted", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE)));
                            if (!started.getEventId().equals(token.getStartedEventId())) {
                                throw SimpleWorkflowService.upClient("ValidationError", "Bad token");
                            }
                            WorkflowHistoryEvent scheduled = (WorkflowHistoryEvent)((Object)Iterables.find((Iterable)reverseEvents, (Predicate)CollectionUtils.propertyPredicate((Object)"DecisionTaskScheduled", (Function)WorkflowExecutions.WorkflowHistoryEventStringFunctions.EVENT_TYPE)));
                            if (scheduled.getEventId() < started.getEventId()) {
                                workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Idle);
                                workflowExecution.setDecisionTimestamp(new Date());
                            } else {
                                workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                workflowExecution.setDecisionTimestamp(new Date());
                                notificationTypeListPairs.add(Pair.pair((Object)"decision", (Object)workflowExecution.getTaskList()));
                            }
                            int activityTaskScheduledCount = 0;
                            Supplier activityTaskCounter = Suppliers.memoize((Supplier)new Supplier<Long>(){

                                public Long get() {
                                    try {
                                        return SimpleWorkflowService.this.activityTasks.countByWorkflowExecution((OwnerFullName)accountFullName, domain.getDisplayName(), workflowExecution.getDisplayName());
                                    }
                                    catch (SwfMetadataException e) {
                                        throw SimpleWorkflowService.up(e);
                                    }
                                }
                            });
                            workflowExecution.setLatestExecutionContext(request.getExecutionContext());
                            final Long completedId = workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskCompletedEventAttributes().withExecutionContext(request.getExecutionContext()).withScheduledEventId(token.getScheduledEventId()).withStartedEventId(token.getStartedEventId())));
                            boolean scheduleDecisionTask = false;
                            if (request.getDecisions() != null) {
                                for (Decision decision : request.getDecisions()) {
                                    switch (decision.getDecisionType()) {
                                        case "CancelTimer": {
                                            CancelTimerDecisionAttributes cancelTimer = decision.getCancelTimerDecisionAttributes();
                                            try {
                                                List timerList = SimpleWorkflowService.this.timers.listByExample(Timer.exampleWithTimerId((OwnerFullName)accountFullName, workflowExecution.getDomainName(), workflowExecution.getDisplayName(), cancelTimer.getTimerId()), (Predicate<? super Timer>)Predicates.alwaysTrue(), Functions.identity());
                                                if (!timerList.isEmpty()) {
                                                    Timer timer = (Timer)((Object)Iterables.getOnlyElement(timerList));
                                                    SimpleWorkflowService.this.timers.deleteByExample(timer);
                                                    workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new TimerCanceledEventAttributes().withDecisionTaskCompletedEventId(completedId).withStartedEventId(timer.getStartedEventId()).withTimerId(cancelTimer.getTimerId())));
                                                    break;
                                                }
                                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new CancelTimerFailedEventAttributes().withCause(CancelTimerFailedCause.TIMER_ID_UNKNOWN).withDecisionTaskCompletedEventId(completedId).withTimerId(cancelTimer.getTimerId())));
                                                scheduleDecisionTask = true;
                                                break;
                                            }
                                            catch (SwfMetadataException e) {
                                                throw SimpleWorkflowService.up(e);
                                            }
                                        }
                                        case "CancelWorkflowExecution": {
                                            CancelWorkflowExecutionDecisionAttributes cancelWorkflowExecution = decision.getCancelWorkflowExecutionDecisionAttributes();
                                            workflowExecution.closeWorkflow(WorkflowExecution.CloseStatus.Canceled, WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionCanceledEventAttributes().withDecisionTaskCompletedEventId(completedId).withDetails(cancelWorkflowExecution.getDetails())));
                                            SimpleWorkflowService.deleteActivities(SimpleWorkflowService.this.activityTasks, accountFullName, workflowExecution);
                                            break;
                                        }
                                        case "CompleteWorkflowExecution": {
                                            CompleteWorkflowExecutionDecisionAttributes completed = decision.getCompleteWorkflowExecutionDecisionAttributes();
                                            workflowExecution.closeWorkflow(WorkflowExecution.CloseStatus.Completed, WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionCompletedEventAttributes().withDecisionTaskCompletedEventId(completedId).withResult(completed.getResult())));
                                            break;
                                        }
                                        case "ContinueAsNewWorkflowExecution": {
                                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ContinueAsNewWorkflowExecutionFailedEventAttributes().withCause(ContinueAsNewWorkflowExecutionFailedCause.OPERATION_NOT_PERMITTED).withDecisionTaskCompletedEventId(completedId)));
                                            scheduleDecisionTask = true;
                                            break;
                                        }
                                        case "FailWorkflowExecution": {
                                            FailWorkflowExecutionDecisionAttributes failed = decision.getFailWorkflowExecutionDecisionAttributes();
                                            workflowExecution.closeWorkflow(WorkflowExecution.CloseStatus.Failed, WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionFailedEventAttributes().withDecisionTaskCompletedEventId(completedId).withDetails(failed.getDetails()).withReason(failed.getReason())));
                                            SimpleWorkflowService.deleteActivities(SimpleWorkflowService.this.activityTasks, accountFullName, workflowExecution);
                                            break;
                                        }
                                        case "RecordMarker": {
                                            RecordMarkerDecisionAttributes mark = decision.getRecordMarkerDecisionAttributes();
                                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new MarkerRecordedEventAttributes().withDetails(mark.getDetails()).withDecisionTaskCompletedEventId(completedId).withMarkerName(mark.getMarkerName())));
                                            break;
                                        }
                                        case "RequestCancelActivityTask": {
                                            final RequestCancelActivityTaskDecisionAttributes cancelActivity = decision.getRequestCancelActivityTaskDecisionAttributes();
                                            try {
                                                SimpleWorkflowService.this.activityTasks.updateByExample(com.eucalyptus.simpleworkflow.ActivityTask.exampleWithActivityId((OwnerFullName)accountFullName, workflowExecution.getDomainName(), workflowExecution.getDisplayName(), cancelActivity.getActivityId()), (OwnerFullName)accountFullName, cancelActivity.getActivityId(), new Function<com.eucalyptus.simpleworkflow.ActivityTask, Void>(){

                                                    public Void apply(com.eucalyptus.simpleworkflow.ActivityTask activityTask) {
                                                        Long cancelRequestedId = workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskCancelRequestedEventAttributes().withDecisionTaskCompletedEventId(completedId).withActivityId(cancelActivity.getActivityId())));
                                                        if (activityTask.getState() == ActivityTask.State.Active) {
                                                            activityTask.setCancelRequestedEventId(cancelRequestedId);
                                                        } else {
                                                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskCanceledEventAttributes().withLatestCancelRequestedEventId(cancelRequestedId).withScheduledEventId(activityTask.getScheduledEventId()).withStartedEventId(activityTask.getStartedEventId())));
                                                            Entities.delete((Object)((Object)activityTask));
                                                        }
                                                        return null;
                                                    }
                                                });
                                            }
                                            catch (SwfMetadataNotFoundException e) {
                                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new RequestCancelActivityTaskFailedEventAttributes().withCause(RequestCancelActivityTaskFailedCause.ACTIVITY_ID_UNKNOWN).withDecisionTaskCompletedEventId(completedId).withActivityId(cancelActivity.getActivityId())));
                                            }
                                            catch (SwfMetadataException e) {
                                                throw SimpleWorkflowService.up(e);
                                            }
                                            scheduleDecisionTask = true;
                                            break;
                                        }
                                        case "RequestCancelExternalWorkflowExecution": {
                                            RequestCancelExternalWorkflowExecutionDecisionAttributes cancelExternalWorkflow = decision.getRequestCancelExternalWorkflowExecutionDecisionAttributes();
                                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new RequestCancelExternalWorkflowExecutionFailedEventAttributes().withCause(RequestCancelExternalWorkflowExecutionFailedCause.UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION).withControl(cancelExternalWorkflow.getControl()).withDecisionTaskCompletedEventId(completedId).withRunId(cancelExternalWorkflow.getRunId()).withWorkflowId(cancelExternalWorkflow.getWorkflowId())));
                                            scheduleDecisionTask = true;
                                            break;
                                        }
                                        case "ScheduleActivityTask": {
                                            workflowExecution.setLatestActivityTaskScheduled(new Date());
                                            ScheduleActivityTaskDecisionAttributes scheduleActivity = decision.getScheduleActivityTaskDecisionAttributes();
                                            Long scheduledId = workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ActivityTaskScheduledEventAttributes().withDecisionTaskCompletedEventId(completedId).withActivityId(scheduleActivity.getActivityId()).withActivityType(scheduleActivity.getActivityType()).withControl(scheduleActivity.getControl()).withHeartbeatTimeout(scheduleActivity.getHeartbeatTimeout()).withInput(scheduleActivity.getInput()).withScheduleToCloseTimeout(scheduleActivity.getScheduleToCloseTimeout()).withScheduleToStartTimeout(scheduleActivity.getScheduleToStartTimeout()).withStartToCloseTimeout(scheduleActivity.getStartToCloseTimeout()).withTaskList(scheduleActivity.getTaskList())));
                                            try {
                                                String list;
                                                ActivityType activityType;
                                                try {
                                                    activityType = (ActivityType)((Object)SimpleWorkflowService.this.activityTypes.lookupByExample(ActivityType.exampleWithUniqueName((OwnerFullName)accountFullName, domain.getDisplayName(), scheduleActivity.getActivityType().getName(), scheduleActivity.getActivityType().getVersion()), (OwnerFullName)accountFullName, scheduleActivity.getActivityType().getName(), (Predicate<? super ActivityType>)Predicates.alwaysTrue(), Functions.identity()));
                                                }
                                                catch (SwfMetadataNotFoundException e) {
                                                    throw new ScheduleActivityTaskException(ScheduleActivityTaskFailedCause.ACTIVITY_TYPE_DOES_NOT_EXIST);
                                                }
                                                if (ActivityType.Status.Deprecated.apply(activityType)) {
                                                    throw new ScheduleActivityTaskException(ScheduleActivityTaskFailedCause.ACTIVITY_TYPE_DEPRECATED);
                                                }
                                                String string = list = scheduleActivity.getTaskList() == null ? activityType.getDefaultTaskList() : scheduleActivity.getTaskList().getName();
                                                if (list == null) {
                                                    throw new ScheduleActivityTaskException(ScheduleActivityTaskFailedCause.DEFAULT_TASK_LIST_UNDEFINED);
                                                }
                                                if ((Long)activityTaskCounter.get() + (long)activityTaskScheduledCount >= (long)SimpleWorkflowProperties.getOpenActivityTasksPerWorkflowExecution()) {
                                                    throw new ScheduleActivityTaskException(ScheduleActivityTaskFailedCause.OPEN_ACTIVITIES_LIMIT_EXCEEDED);
                                                }
                                                SimpleWorkflowService.this.activityTasks.save(com.eucalyptus.simpleworkflow.ActivityTask.create((OwnerFullName)userFullName, workflowExecution, domain.getDisplayName(), domain.getNaturalId(), scheduleActivity.getActivityId(), scheduleActivity.getActivityType().getName(), scheduleActivity.getActivityType().getVersion(), scheduleActivity.getInput(), scheduledId, list, SimpleWorkflowService.parseActivityPeriod(scheduleActivity.getScheduleToCloseTimeout(), activityType.getDefaultTaskScheduleToCloseTimeout(), ScheduleActivityTaskFailedCause.DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED), SimpleWorkflowService.parseActivityPeriod(scheduleActivity.getScheduleToStartTimeout(), activityType.getDefaultTaskScheduleToStartTimeout(), ScheduleActivityTaskFailedCause.DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED), SimpleWorkflowService.parseActivityPeriod(scheduleActivity.getStartToCloseTimeout(), activityType.getDefaultTaskStartToCloseTimeout(), ScheduleActivityTaskFailedCause.DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED), SimpleWorkflowService.parseActivityPeriod(scheduleActivity.getHeartbeatTimeout(), activityType.getDefaultTaskHeartbeatTimeout(), ScheduleActivityTaskFailedCause.DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED)));
                                                ++activityTaskScheduledCount;
                                                notificationTypeListPairs.add(Pair.pair((Object)"activity", (Object)list));
                                                break;
                                            }
                                            catch (ScheduleActivityTaskException e) {
                                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new ScheduleActivityTaskFailedEventAttributes().withActivityId(scheduleActivity.getActivityId()).withActivityType(scheduleActivity.getActivityType()).withCause(e.getFailedCause()).withDecisionTaskCompletedEventId(completedId)));
                                                scheduleDecisionTask = true;
                                                break;
                                            }
                                            catch (Exception e) {
                                                throw SimpleWorkflowService.up(e);
                                            }
                                        }
                                        case "SignalExternalWorkflowExecution": {
                                            SignalExternalWorkflowExecutionDecisionAttributes signalExternalWorkflow = decision.getSignalExternalWorkflowExecutionDecisionAttributes();
                                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new SignalExternalWorkflowExecutionFailedEventAttributes().withCause(SignalExternalWorkflowExecutionFailedCause.UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION).withControl(signalExternalWorkflow.getControl()).withDecisionTaskCompletedEventId(completedId).withRunId(signalExternalWorkflow.getRunId()).withWorkflowId(signalExternalWorkflow.getWorkflowId())));
                                            scheduleDecisionTask = true;
                                            break;
                                        }
                                        case "StartChildWorkflowExecution": {
                                            StartChildWorkflowExecutionDecisionAttributes startChildWorkflow = decision.getStartChildWorkflowExecutionDecisionAttributes();
                                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new StartChildWorkflowExecutionFailedEventAttributes().withCause(StartChildWorkflowExecutionFailedCause.OPERATION_NOT_PERMITTED).withControl(startChildWorkflow.getControl()).withDecisionTaskCompletedEventId(completedId).withWorkflowId(startChildWorkflow.getWorkflowId()).withWorkflowType(startChildWorkflow.getWorkflowType())));
                                            scheduleDecisionTask = true;
                                            break;
                                        }
                                        case "StartTimer": {
                                            StartTimerDecisionAttributes startTimer = decision.getStartTimerDecisionAttributes();
                                            try {
                                                if (!SimpleWorkflowService.this.timers.listByExample(Timer.exampleWithTimerId((OwnerFullName)accountFullName, workflowExecution.getDomainName(), workflowExecution.getDisplayName(), startTimer.getTimerId()), (Predicate<? super Timer>)Predicates.alwaysTrue(), Functions.identity()).isEmpty()) {
                                                    throw new StartTimerException(StartTimerFailedCause.TIMER_ID_ALREADY_IN_USE);
                                                }
                                                Long startedId = workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new TimerStartedEventAttributes().withControl(startTimer.getControl()).withDecisionTaskCompletedEventId(completedId).withStartToFireTimeout(startTimer.getStartToFireTimeout()).withTimerId(startTimer.getTimerId())));
                                                if (SimpleWorkflowService.this.timers.countByWorkflowExecution((OwnerFullName)accountFullName, domain.getDisplayName(), workflowExecution.getDisplayName()) >= (long)SimpleWorkflowProperties.getOpenTimersPerWorkflowExecution()) {
                                                    throw new StartTimerException(StartTimerFailedCause.OPEN_TIMERS_LIMIT_EXCEEDED);
                                                }
                                                SimpleWorkflowService.this.timers.save(Timer.create((OwnerFullName)userFullName, workflowExecution, workflowExecution.getDomainName(), workflowExecution.getDomainUuid(), startTimer.getTimerId(), startTimer.getControl(), SimpleWorkflowService.parsePeriod(startTimer.getStartToFireTimeout(), 0), completedId, startedId));
                                                break;
                                            }
                                            catch (StartTimerException e) {
                                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new StartTimerFailedEventAttributes().withCause(e.getFailedCause()).withDecisionTaskCompletedEventId(completedId).withTimerId(startTimer.getTimerId())));
                                                scheduleDecisionTask = true;
                                                break;
                                            }
                                            catch (SwfMetadataException e) {
                                                throw SimpleWorkflowService.up(e);
                                            }
                                        }
                                        default: {
                                            throw SimpleWorkflowService.up((Throwable)((Object)new SimpleWorkflowException("InternalFailure", Role.Receiver, "Unsupported decision type: " + decision.getDecisionType())));
                                        }
                                    }
                                }
                            }
                            if (scheduleDecisionTask && workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                workflowExecution.setDecisionTimestamp(new Date());
                                notificationTypeListPairs.add(Pair.pair((Object)"decision", (Object)workflowExecution.getTaskList()));
                            } else {
                                workflowExecution.updateTimeStamps();
                            }
                        }
                        return workflowExecution;
                    }
                });
            }
            for (Pair notificationTypeListPair : notificationTypeListPairs) {
                SimpleWorkflowService.notifyTaskList(accountFullName, domain.getDisplayName(), (String)notificationTypeListPair.getLeft(), (String)notificationTypeListPair.getRight());
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage signalWorkflowExecution(final SignalWorkflowExecutionRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            Pair domainTaskListPair;
            WorkflowExecution example = WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowId(), request.getRunId());
            Pair domainUuidRunIdPair = (Pair)this.workflowExecutions.lookupByExample(example, (OwnerFullName)accountFullName, request.getWorkflowId(), (Predicate<? super WorkflowExecution>)Predicates.alwaysTrue(), Pair.builder((Function)WorkflowExecutions.WorkflowExecutionStringFunctions.DOMAIN_UUID, (Function)SimpleWorkflowMetadatas.toDisplayName()));
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, (Pair<String, String>)domainUuidRunIdPair);){
                domainTaskListPair = (Pair)this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)example, (OwnerFullName)accountFullName, request.getWorkflowId(), (Function)new Function<WorkflowExecution, Pair<String, String>>(){

                    public Pair<String, String> apply(WorkflowExecution workflowExecution) {
                        if (accessible.apply((Object)workflowExecution)) {
                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionSignaledEventAttributes().withExternalInitiatedEventId(Long.valueOf(0L)).withInput(request.getInput()).withSignalName(request.getSignalName())));
                            if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                    workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                    workflowExecution.setDecisionTimestamp(new Date());
                                    return Pair.pair((Object)workflowExecution.getDomainName(), (Object)workflowExecution.getTaskList());
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            if (domainTaskListPair != null) {
                SimpleWorkflowService.notifyTaskList(accountFullName, (String)domainTaskListPair.getLeft(), "decision", (String)domainTaskListPair.getRight());
            }
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", request.getRunId() == null ? "Unknown execution, workflowId = " + request.getWorkflowId() : "Unknown execution: WorkflowExecution=[workflowId=" + request.getWorkflowId() + ", runId=" + request.getRunId() + "]");
        }
        catch (SwfMetadataException e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            Pair domainTaskListPair;
            WorkflowExecution example = WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowId(), request.getRunId());
            Pair domainUuidRunIdPair = (Pair)this.workflowExecutions.lookupByExample(example, (OwnerFullName)accountFullName, request.getWorkflowId(), (Predicate<? super WorkflowExecution>)Predicates.alwaysTrue(), Pair.builder((Function)WorkflowExecutions.WorkflowExecutionStringFunctions.DOMAIN_UUID, (Function)SimpleWorkflowMetadatas.toDisplayName()));
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, (Pair<String, String>)domainUuidRunIdPair);){
                domainTaskListPair = (Pair)this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)example, (OwnerFullName)accountFullName, request.getWorkflowId(), (Function)new Function<WorkflowExecution, Pair<String, String>>(){

                    public Pair<String, String> apply(WorkflowExecution workflowExecution) {
                        if (accessible.apply((Object)workflowExecution)) {
                            workflowExecution.setCancelRequested(true);
                            workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionCancelRequestedEventAttributes().withExternalInitiatedEventId(Long.valueOf(0L))));
                            if (workflowExecution.getDecisionStatus() != WorkflowExecution.DecisionStatus.Pending) {
                                workflowExecution.addHistoryEvent(WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new DecisionTaskScheduledEventAttributes().withTaskList(new TaskList().withName(workflowExecution.getTaskList())).withStartToCloseTimeout(String.valueOf(workflowExecution.getTaskStartToCloseTimeout()))));
                                if (workflowExecution.getDecisionStatus() == WorkflowExecution.DecisionStatus.Idle) {
                                    workflowExecution.setDecisionStatus(WorkflowExecution.DecisionStatus.Pending);
                                    workflowExecution.setDecisionTimestamp(new Date());
                                    return Pair.pair((Object)workflowExecution.getDomainName(), (Object)workflowExecution.getTaskList());
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            if (domainTaskListPair != null) {
                SimpleWorkflowService.notifyTaskList(accountFullName, (String)domainTaskListPair.getLeft(), "decision", (String)domainTaskListPair.getRight());
            }
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", request.getRunId() == null ? "Unknown execution, workflowId = " + request.getWorkflowId() : "Unknown execution: WorkflowExecution=[workflowId=" + request.getWorkflowId() + ", runId=" + request.getRunId() + "]");
        }
        catch (SwfMetadataException e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public SimpleWorkflowMessage terminateWorkflowExecution(final TerminateWorkflowExecutionRequest request) throws SimpleWorkflowException {
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            WorkflowExecution example = WorkflowExecution.exampleForOpenWorkflow((OwnerFullName)accountFullName, request.getDomain(), request.getWorkflowId(), request.getRunId());
            Pair domainUuidRunIdPair = (Pair)this.workflowExecutions.lookupByExample(example, (OwnerFullName)accountFullName, request.getWorkflowId(), (Predicate<? super WorkflowExecution>)Predicates.alwaysTrue(), Pair.builder((Function)WorkflowExecutions.WorkflowExecutionStringFunctions.DOMAIN_UUID, (Function)SimpleWorkflowMetadatas.toDisplayName()));
            try (WorkflowLock lock = WorkflowLock.lock(accountFullName, (Pair<String, String>)domainUuidRunIdPair);){
                this.workflowExecutions.withRetries().updateByExample((AbstractPersistent)example, (OwnerFullName)accountFullName, request.getWorkflowId(), (Function)new Function<WorkflowExecution, Void>(){

                    public Void apply(WorkflowExecution workflowExecution) {
                        if (accessible.apply((Object)workflowExecution)) {
                            workflowExecution.closeWorkflow(WorkflowExecution.CloseStatus.Terminated, WorkflowHistoryEvent.create(workflowExecution, (WorkflowEventAttributes)new WorkflowExecutionTerminatedEventAttributes().withChildPolicy((String)Objects.firstNonNull((Object)request.getChildPolicy(), (Object)workflowExecution.getChildPolicy())).withDetails(request.getDetails()).withReason(request.getReason())));
                        }
                        SimpleWorkflowService.deleteActivities(SimpleWorkflowService.this.activityTasks, accountFullName, workflowExecution);
                        return null;
                    }
                });
            }
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", request.getRunId() == null ? "Unknown execution, workflowId = " + request.getWorkflowId() : "Unknown execution: WorkflowExecution=[workflowId=" + request.getWorkflowId() + ", runId=" + request.getRunId() + "]");
        }
        catch (SwfMetadataException e) {
            throw this.handleException(e);
        }
        return request.reply(new SimpleWorkflowMessage());
    }

    public History getWorkflowExecutionHistory(final GetWorkflowExecutionHistoryRequest request) throws SimpleWorkflowException {
        History history;
        Context ctx = Contexts.lookup();
        UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        Predicate accessible = SimpleWorkflowMetadatas.filteringFor(WorkflowExecution.class).byPrivileges().buildPredicate();
        try {
            history = this.workflowExecutions.lookupByExample(WorkflowExecution.exampleWithName((OwnerFullName)accountFullName, request.getExecution().getRunId()), (OwnerFullName)accountFullName, request.getExecution().getRunId(), (Predicate<? super WorkflowExecution>)accessible, new Function<WorkflowExecution, History>(){

                public History apply(WorkflowExecution workflowExecution) {
                    List<WorkflowHistoryEvent> events = workflowExecution.getWorkflowHistory();
                    List<WorkflowHistoryEvent> reverseEvents = Lists.reverse(events);
                    return new History().withEvents(Collections2.transform((Boolean)Objects.firstNonNull((Object)request.isReverseOrder(), (Object)Boolean.FALSE) != false ? reverseEvents : events, (Function)TypeMappers.lookup(WorkflowHistoryEvent.class, HistoryEvent.class)));
                }
            });
        }
        catch (SwfMetadataNotFoundException e) {
            throw new SimpleWorkflowClientException("UnknownResourceFault", "Unknown execution, runId = " + request.getExecution().getRunId());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        return (History)request.reply((SimpleWorkflowMessage)history);
    }

    private <T extends AbstractPersistent> T allocate(Supplier<T> allocator, Class<T> type, String name) throws SimpleWorkflowException {
        try {
            return (T)((AbstractPersistent)RestrictedTypes.allocateUnitlessResources(type, (Integer)1, this.transactional(allocator)).get(0));
        }
        catch (Exception e) {
            SQLException sqlException = (SQLException)Exceptions.findCause((Throwable)e, SQLException.class);
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)Exceptions.findCause((Throwable)e, ConstraintViolationException.class);
            if (constraintViolationException != null || sqlException != null && "23505".equals(sqlException.getSQLState())) {
                String typeName = type.getSimpleName();
                String faultPrefix = typeName.endsWith("Type") ? "Type" : typeName;
                throw new SimpleWorkflowClientException(faultPrefix + "AlreadyExistsFault", typeName + " already exists: " + name);
            }
            throw this.handleException(e);
        }
    }

    protected <E extends AbstractPersistent> Supplier<E> transactional(Supplier<E> supplier) {
        return Entities.asTransaction(supplier);
    }

    private static void deleteActivities(ActivityTasks activityTasks, AccountFullName accountFullName, WorkflowExecution workflowExecution) {
        try {
            activityTasks.deleteByExample(com.eucalyptus.simpleworkflow.ActivityTask.exampleWithWorkflowExecution((OwnerFullName)accountFullName, workflowExecution.getDomainName(), workflowExecution.getDisplayName()));
        }
        catch (SwfMetadataException e) {
            throw SimpleWorkflowService.up(e);
        }
    }

    private static void buildFilters(ClosedWorkflowExecutionFilterParameters parameters, Conjunction filter, Map<String, String> aliases) {
        if (parameters.getCloseStatusFilter() != null) {
            filter.add((Criterion)Restrictions.eq((String)"closeStatus", (Object)((Object)WorkflowExecution.CloseStatus.fromString(parameters.getCloseStatusFilter().getStatus()))));
        }
        if (parameters.getCloseTimeFilter() != null) {
            if (parameters.getCloseTimeFilter().getOldestDate() != null) {
                filter.add((Criterion)Restrictions.ge((String)"closeTimestamp", (Object)parameters.getCloseTimeFilter().getOldestDate()));
            }
            if (parameters.getCloseTimeFilter().getLatestDate() != null) {
                filter.add((Criterion)Restrictions.le((String)"closeTimestamp", (Object)parameters.getCloseTimeFilter().getLatestDate()));
            }
        }
        SimpleWorkflowService.buildFilters((WorkflowExecutionFilterParameters)parameters, filter, aliases);
    }

    private static void buildFilters(WorkflowExecutionFilterParameters parameters, Conjunction filter, Map<String, String> aliases) {
        if (parameters.getExecutionFilter() != null) {
            filter.add((Criterion)Restrictions.eq((String)"workflowId", (Object)parameters.getExecutionFilter().getWorkflowId()));
        }
        if (parameters.getStartTimeFilter() != null) {
            if (parameters.getStartTimeFilter().getOldestDate() != null) {
                filter.add((Criterion)Restrictions.ge((String)"creationTimestamp", (Object)parameters.getStartTimeFilter().getOldestDate()));
            }
            if (parameters.getStartTimeFilter().getLatestDate() != null) {
                filter.add((Criterion)Restrictions.le((String)"creationTimestamp", (Object)parameters.getStartTimeFilter().getLatestDate()));
            }
        }
        if (parameters.getTagFilter() != null) {
            aliases.put("tagList", "tag");
            filter.add((Criterion)Restrictions.eq((String)"tag.elements", (Object)parameters.getTagFilter().getTag()));
        }
        if (parameters.getTypeFilter() != null) {
            if (parameters.getTypeFilter().getName() != null) {
                aliases.put("workflowType", "workflowType");
                filter.add((Criterion)Restrictions.eq((String)"workflowType.displayName", (Object)parameters.getTypeFilter().getName()));
            }
            if (parameters.getTypeFilter().getVersion() != null) {
                aliases.put("workflowType", "workflowType");
                filter.add((Criterion)Restrictions.eq((String)"workflowType.workflowVersion", (Object)parameters.getTypeFilter().getVersion()));
            }
        }
    }

    private static RuntimeException up(Throwable throwable) {
        throw Exceptions.toUndeclared((Throwable)throwable);
    }

    private static RuntimeException upClient(String errorCode, String message) {
        throw SimpleWorkflowService.up((Throwable)((Object)new SimpleWorkflowClientException(errorCode, message)));
    }

    private SimpleWorkflowException handleException(Exception e) throws SimpleWorkflowException {
        SimpleWorkflowException cause = (SimpleWorkflowException)((Object)Exceptions.findCause((Throwable)e, SimpleWorkflowException.class));
        if (cause != null) {
            throw cause;
        }
        WorkflowExecution.WorkflowHistorySizeLimitException historySizeLimitCause = (WorkflowExecution.WorkflowHistorySizeLimitException)Exceptions.findCause((Throwable)e, WorkflowExecution.WorkflowHistorySizeLimitException.class);
        if (historySizeLimitCause != null) {
            WorkflowExecutions.Utils.terminateWorkflowExecution(this.workflowExecutions, "EVENT_LIMIT_EXCEEDED", historySizeLimitCause.getAccountNumber(), historySizeLimitCause.getDomain(), historySizeLimitCause.getWorkflowId());
            throw new SimpleWorkflowClientException("LimitExceededFault", "Request would exceed history limit for workflow execution");
        }
        AuthQuotaException quotaCause = (AuthQuotaException)Exceptions.findCause((Throwable)e, AuthQuotaException.class);
        if (quotaCause != null) {
            throw new SimpleWorkflowClientException("LimitExceededFault", "Request would exceed quota for type: " + quotaCause.getType());
        }
        TaskTokenException tokenCause = (TaskTokenException)Exceptions.findCause((Throwable)e, TaskTokenException.class);
        if (tokenCause != null) {
            throw new SimpleWorkflowClientException("InvalidParameterValue", "Invalid task token.");
        }
        logger.error((Object)e, (Throwable)e);
        SimpleWorkflowException exception = new SimpleWorkflowException("InternalError", Role.Receiver, String.valueOf(e.getMessage()));
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            exception.initCause(e);
        }
        throw exception;
    }

    private static Integer parsePeriod(String period, Integer noneValue) {
        if (period == null) {
            return null;
        }
        if ("NONE".equals(period)) {
            return noneValue;
        }
        return Integer.parseInt(period);
    }

    private static Integer parseActivityPeriod(String period, Integer defaultValue, ScheduleActivityTaskFailedCause failureOnNoDefault) throws ScheduleActivityTaskException {
        if (period == null && defaultValue == null) {
            throw new ScheduleActivityTaskException(failureOnNoDefault);
        }
        if (period == null) {
            return defaultValue < 0 ? null : defaultValue;
        }
        if ("NONE".equals(period)) {
            return null;
        }
        return Integer.parseInt(period);
    }

    private static Integer requireDefault(Integer value, Integer defaultValue, String description) throws SimpleWorkflowClientException {
        if (value == null && defaultValue == null) {
            throw new SimpleWorkflowClientException("DefaultUndefinedFault", description + " is required");
        }
        return (Integer)Objects.firstNonNull((Object)value, (Object)defaultValue);
    }

    private static void notifyTaskList(AccountFullName accountFullName, String domain, String type, String taskList) {
        NotifyClient.notifyTaskList(accountFullName, domain, type, taskList);
    }

    private static void handleTaskPolling(AccountFullName accountFullName, String domain, String type, String taskList, final String correlationId, final SimpleWorkflowMessage emptyResponse, final Callable<? extends SimpleWorkflowMessage> responseCallable) {
        final String list = Joiner.on((char)'/').join((Object)type, (Object)domain, new Object[]{taskList});
        try {
            NotifyClient.pollTaskList(accountFullName, domain, type, taskList, (Consumer<Boolean>)Contexts.consumerWithCurrentContext((Consumer)new Consumer<Boolean>(){

                public void accept(Boolean notified) {
                    try {
                        SimpleWorkflowMessage taskResponse;
                        if (notified.booleanValue() && (taskResponse = (SimpleWorkflowMessage)responseCallable.call()) != null) {
                            taskResponse.setCorrelationId(correlationId);
                            Contexts.response((BaseMessage)taskResponse);
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)("Interrupted while polling for task " + list), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error polling for task " + list), (Throwable)e);
                    }
                    emptyResponse.setCorrelationId(correlationId);
                    Contexts.response((BaseMessage)emptyResponse);
                }
            }));
        }
        catch (Exception e) {
            logger.error((Object)("Error polling for task " + list), (Throwable)e);
            emptyResponse.setCorrelationId(correlationId);
            Contexts.response((BaseMessage)emptyResponse);
        }
    }

    private static final class StartTimerException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final StartTimerFailedCause failedCause;

        public StartTimerException(StartTimerFailedCause failedCause) {
            this.failedCause = failedCause;
        }

        public StartTimerFailedCause getFailedCause() {
            return this.failedCause;
        }
    }

    private static final class ScheduleActivityTaskException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ScheduleActivityTaskFailedCause failedCause;

        public ScheduleActivityTaskException(ScheduleActivityTaskFailedCause failedCause) {
            this.failedCause = failedCause;
        }

        public ScheduleActivityTaskFailedCause getFailedCause() {
            return this.failedCause;
        }
    }
}

