/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.util.Intervals;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

@ConfigurableClass(root="services.simpleworkflow", description="Parameters controlling Simple Workflow")
public class SimpleWorkflowProperties {
    private static final Logger logger = Logger.getLogger(SimpleWorkflowProperties.class);
    @ConfigurableField(initial="true", description="Service available for internal/administrator use only.")
    public static volatile boolean systemOnly = true;
    @ConfigurableField(initial="10000", description="Maximum number of activity types for each domain.")
    public static volatile int activityTypesPerDomain = 10000;
    @ConfigurableField(initial="10000", description="Maximum number of workflow types for each domain.")
    public static volatile int workflowTypesPerDomain = 10000;
    @ConfigurableField(initial="100000", description="Maximum number of open workflow executions for each domain.")
    public static volatile int openWorkflowExecutionsPerDomain = 100000;
    @ConfigurableField(initial="1000", description="Maximum number of open activity tasks for each workflow execution.")
    public static volatile int openActivityTasksPerWorkflowExecution = 1000;
    @ConfigurableField(initial="1000", description="Maximum number of open timers for each workflow execution.")
    public static volatile int openTimersPerWorkflowExecution = 1000;
    @ConfigurableField(initial="25000", description="Maximum number of events per workflow execution.")
    public static volatile int workflowExecutionHistorySize = 25000;
    @ConfigurableField(initial="365d", description="Maximum workflow execution time.", changeListener=SimpleWorkflowIntervalPropertyChangeListener.class)
    public static volatile String workflowExecutionDuration = "365d";
    @ConfigurableField(initial="90d", description="Maximum workflow execution history retention time.", changeListener=SimpleWorkflowIntervalPropertyChangeListener.class)
    public static volatile String workflowExecutionRetentionDuration = "90d";
    @ConfigurableField(initial="30d", description="Deprecated activity type retention time.", changeListener=SimpleWorkflowIntervalPropertyChangeListener.class)
    public static volatile String deprecatedActivityTypeRetentionDuration = "30d";
    @ConfigurableField(initial="1d", description="Deprecated workflow type minimum retention time.", changeListener=SimpleWorkflowIntervalPropertyChangeListener.class)
    public static volatile String deprecatedWorkflowTypeRetentionDuration = "1d";
    @ConfigurableField(initial="1d", description="Deprecated domain minimum retention time.", changeListener=SimpleWorkflowIntervalPropertyChangeListener.class)
    public static volatile String deprecatedDomainRetentionDuration = "1d";
    private static AtomicLong workflowExecutionDurationMillis = new AtomicLong(Intervals.parse((String)workflowExecutionDuration, (long)TimeUnit.DAYS.toMillis(365L)));
    private static AtomicLong workflowExecutionRetentionDurationMillis = new AtomicLong(Intervals.parse((String)workflowExecutionRetentionDuration, (long)TimeUnit.DAYS.toMillis(90L)));
    private static AtomicLong deprecatedActivityTypeRetentionDurationMillis = new AtomicLong(Intervals.parse((String)deprecatedActivityTypeRetentionDuration, (long)TimeUnit.DAYS.toMillis(30L)));
    private static AtomicLong deprecatedWorkflowTypeRetentionDurationMillis = new AtomicLong(Intervals.parse((String)deprecatedWorkflowTypeRetentionDuration, (long)TimeUnit.DAYS.toMillis(1L)));
    private static AtomicLong deprecatedDomainRetentionDurationMillis = new AtomicLong(Intervals.parse((String)deprecatedDomainRetentionDuration, (long)TimeUnit.DAYS.toMillis(1L)));

    public static boolean isSystemOnly() {
        return systemOnly;
    }

    public static int getActivityTypesPerDomain() {
        return activityTypesPerDomain;
    }

    public static int getWorkflowTypesPerDomain() {
        return workflowTypesPerDomain;
    }

    public static int getOpenWorkflowExecutionsPerDomain() {
        return openWorkflowExecutionsPerDomain;
    }

    public static int getOpenActivityTasksPerWorkflowExecution() {
        return openActivityTasksPerWorkflowExecution;
    }

    public static int getOpenTimersPerWorkflowExecution() {
        return openTimersPerWorkflowExecution;
    }

    public static int getWorkflowExecutionHistorySize() {
        return workflowExecutionHistorySize;
    }

    public static long getWorkflowExecutionDurationMillis() {
        return workflowExecutionDurationMillis.get();
    }

    public static long getWorkflowExecutionRetentionDurationMillis() {
        return workflowExecutionRetentionDurationMillis.get();
    }

    public static long getDeprecatedActivityTypeRetentionDurationMillis() {
        return deprecatedActivityTypeRetentionDurationMillis.get();
    }

    public static long getDeprecatedWorkflowTypeRetentionDurationMillis() {
        return deprecatedWorkflowTypeRetentionDurationMillis.get();
    }

    public static long getDeprecatedDomainRetentionDurationMillis() {
        return deprecatedDomainRetentionDurationMillis.get();
    }

    public static final class SimpleWorkflowIntervalPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            try {
                String fieldName = configurableProperty.getField().getName() + "Millis";
                Field field = SimpleWorkflowProperties.class.getDeclaredField(fieldName);
                long defaultValue = Intervals.parse((String)configurableProperty.getDefaultValue());
                long value = Intervals.parse((String)String.valueOf(newValue), (long)defaultValue);
                field.setAccessible(true);
                logger.info((Object)("Simple workflow configuration updated " + field.getName() + ": " + value + "ms"));
                ((AtomicLong)field.get(null)).set(value);
            }
            catch (IllegalAccessException | NoSuchFieldException | ParseException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }
}

