/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.simpleworkflow.stateful.NotifyType;
import com.eucalyptus.simpleworkflow.stateful.PollForNotificationResponseType;
import com.eucalyptus.simpleworkflow.stateful.PollForNotificationType;
import com.eucalyptus.simpleworkflow.stateful.PolledNotifications;
import com.eucalyptus.util.Consumer;
import com.eucalyptus.util.Consumers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.concurrent.ListenableFuture;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class NotifyClient {
    private static final Logger logger = Logger.getLogger(NotifyClient.class);

    public static void notifyTaskList(AccountFullName accountFullName, String domain, String type, String taskList) {
        NotifyClient.notifyTaskList(new NotifyTaskList(accountFullName, domain, type, taskList));
    }

    public static void notifyTaskList(NotifyTaskList taskList) {
        NotifyType notify = new NotifyType();
        notify.setChannel(taskList.getChannelName());
        try {
            CheckedListenableFuture dispatchFuture = AsyncRequests.dispatch((ServiceConfiguration)Topology.lookup(PolledNotifications.class, (Partition[])new Partition[0]), (BaseMessage)notify);
            dispatchFuture.addListener(new Runnable((ListenableFuture)dispatchFuture, notify){
                final /* synthetic */ ListenableFuture val$dispatchFuture;
                final /* synthetic */ NotifyType val$notify;
                {
                    this.val$dispatchFuture = listenableFuture;
                    this.val$notify = notifyType;
                }

                @Override
                public void run() {
                    try {
                        this.val$dispatchFuture.get();
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)("Interrupted while sending notification for " + this.val$notify.getChannel()), (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        logger.error((Object)("Error sending notification for " + this.val$notify.getChannel()), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)("Error sending notification for " + notify.getChannel()), (Throwable)e);
        }
    }

    public static void pollTaskList(AccountFullName accountFullName, String domain, String type, String taskList, Consumer<Boolean> resultConsumer) throws Exception {
        NotifyClient.pollTaskList(new NotifyTaskList(accountFullName, domain, type, taskList), resultConsumer);
    }

    public static void pollTaskList(NotifyTaskList taskList, Consumer<Boolean> resultConsumer) throws Exception {
        Consumer consumer = Consumers.once(resultConsumer);
        PollForNotificationType poll = new PollForNotificationType();
        poll.setChannel(taskList.getChannelName());
        CheckedListenableFuture dispatchFuture = AsyncRequests.dispatch((ServiceConfiguration)Topology.lookup(PolledNotifications.class, (Partition[])new Partition[0]), (BaseMessage)poll);
        dispatchFuture.addListener(new Runnable((ListenableFuture)dispatchFuture, consumer, poll){
            final /* synthetic */ ListenableFuture val$dispatchFuture;
            final /* synthetic */ Consumer val$consumer;
            final /* synthetic */ PollForNotificationType val$poll;
            {
                this.val$dispatchFuture = listenableFuture;
                this.val$consumer = consumer;
                this.val$poll = pollForNotificationType;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PollForNotificationResponseType response = (PollForNotificationResponseType)this.val$dispatchFuture.get();
                    this.val$consumer.accept(Objects.firstNonNull((Object)response.getNotified(), (Object)false));
                }
                catch (InterruptedException e) {
                    logger.info((Object)("Interrupted while polling for task " + this.val$poll.getChannel()), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)("Error polling for task " + this.val$poll.getChannel()), (Throwable)e);
                }
                finally {
                    this.val$consumer.accept((Object)false);
                }
            }
        });
    }

    public static final class NotifyTaskList {
        private final String accountNumber;
        private final String domain;
        private final String type;
        private final String name;

        public NotifyTaskList(AccountFullName accountFullName, String domain, String type, String name) {
            this(accountFullName.getAccountNumber(), domain, type, name);
        }

        public NotifyTaskList(String accountNumber, String domain, String type, String name) {
            this.accountNumber = accountNumber;
            this.domain = domain;
            this.type = type;
            this.name = name;
        }

        public String getChannelName() {
            return Joiner.on((char)':').join((Object)this.accountNumber, (Object)this.type, new Object[]{this.domain, this.name});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyTaskList taskList = (NotifyTaskList)o;
            if (!this.accountNumber.equals(taskList.accountNumber)) {
                return false;
            }
            if (!this.domain.equals(taskList.domain)) {
                return false;
            }
            if (!this.name.equals(taskList.name)) {
                return false;
            }
            return this.type.equals(taskList.type);
        }

        public int hashCode() {
            int result = this.accountNumber.hashCode();
            result = 31 * result + this.domain.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

