/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.entities.AbstractPersistentSupport;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.common.model.DomainConfiguration;
import com.eucalyptus.simpleworkflow.common.model.DomainDetail;
import com.eucalyptus.simpleworkflow.common.model.DomainInfo;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface Domains {
    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Predicate<? super Domain> var3, Function<? super Domain, T> var4) throws SwfMetadataException;

    public <T> T lookupByExample(Domain var1, @Nullable OwnerFullName var2, String var3, Predicate<? super Domain> var4, Function<? super Domain, T> var5) throws SwfMetadataException;

    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super Domain> var4, Function<? super Domain, T> var5) throws SwfMetadataException;

    public <T> List<T> listDeprecatedExpired(long var1, Function<? super Domain, T> var3) throws SwfMetadataException;

    public Domain updateByExample(Domain var1, OwnerFullName var2, String var3, Callback<Domain> var4) throws SwfMetadataException;

    public Domain save(Domain var1) throws SwfMetadataException;

    public List<Domain> deleteByExample(Domain var1) throws SwfMetadataException;

    public AbstractPersistentSupport<SimpleWorkflowMetadata.DomainMetadata, Domain, SwfMetadataException> withRetries();

    @RestrictedTypes.QuantityMetricFunction(value=SimpleWorkflowMetadata.DomainMetadata.class)
    public static enum CountDomains implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(@Nullable OwnerFullName input) {
            try (TransactionResource tx = Entities.transactionFor(Domain.class);){
                Long l = Entities.count((Object)((Object)Domain.exampleWithOwner(input)));
                return l;
            }
        }
    }

    public static enum StringFunctions implements Function<Domain, String>
    {
        REGISTRATION_STATUS{

            @Nullable
            public String apply(@Nullable Domain domain) {
                return domain == null ? null : Objects.toString(domain.getState(), null);
            }
        };

    }

    @TypeMapper
    public static enum DomainToDomainInfoTransform implements Function<Domain, DomainInfo>
    {
        INSTANCE;


        @Nullable
        public DomainInfo apply(@Nullable Domain domain) {
            return domain == null ? null : new DomainInfo().withName(domain.getDisplayName()).withDescription(domain.getDescription()).withStatus(Objects.toString(domain.getState(), null));
        }
    }

    @TypeMapper
    public static enum DomainToDomainDetailTransform implements Function<Domain, DomainDetail>
    {
        INSTANCE;


        @Nullable
        public DomainDetail apply(@Nullable Domain domain) {
            return domain == null ? null : new DomainDetail().withConfiguration(new DomainConfiguration().withWorkflowExecutionRetentionPeriodInDays((String)Optional.fromNullable((Object)domain.getWorkflowExecutionRetentionPeriodInDays()).transform(Functions.toStringFunction()).or((Object)"NONE"))).withDomainInfo((DomainInfo)TypeMappers.transform((Object)((Object)domain), DomainInfo.class));
        }
    }
}

