/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.simpleworkflow.ActivityType;
import com.eucalyptus.simpleworkflow.WorkflowType;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_domain")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Domain
extends UserMetadata<Status>
implements SimpleWorkflowMetadata.DomainMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="description", length=1024, updatable=false)
    private String description;
    @Column(name="workflow_retention_days", nullable=false, updatable=false)
    private Integer workflowExecutionRetentionPeriodInDays;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="domain")
    private Collection<ActivityType> activityTypes;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="domain")
    private Collection<WorkflowType> workflowTypes;

    protected Domain() {
    }

    protected Domain(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static Domain create(OwnerFullName owner, String name, String description, int workflowExecutionRetentionPeriodInDays) {
        Domain domain = new Domain(owner, name);
        domain.setState(Status.Registered);
        domain.setDescription(description);
        domain.setWorkflowExecutionRetentionPeriodInDays(workflowExecutionRetentionPeriodInDays);
        return domain;
    }

    public static Domain exampleWithOwner(OwnerFullName owner) {
        return new Domain(owner, null);
    }

    public static Domain exampleWithName(OwnerFullName owner, String name) {
        return new Domain(owner, name);
    }

    public static Domain exampleWithUuid(OwnerFullName owner, String uuid) {
        Domain domain = new Domain(owner, null);
        domain.setNaturalId(uuid);
        return domain;
    }

    public static Domain exampleWithStatus(Status status) {
        Domain domain = new Domain(null, null);
        domain.setState(status);
        domain.setStateChangeStack(null);
        domain.setLastState(null);
        return domain;
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((SimpleWorkflow)ComponentIds.lookup(SimpleWorkflow.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"domain", this.getDisplayName()});
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getWorkflowExecutionRetentionPeriodInDays() {
        return this.workflowExecutionRetentionPeriodInDays;
    }

    public void setWorkflowExecutionRetentionPeriodInDays(Integer workflowExecutionRetentionPeriodInDays) {
        this.workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays;
    }

    public static enum Status implements Predicate<UserMetadata<Status>>
    {
        Registered,
        Deprecated;


        public String toString() {
            return this.name().toUpperCase();
        }

        public boolean apply(@Nullable UserMetadata<Status> metadata) {
            return metadata != null && metadata.getState() == this;
        }
    }
}

