/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.simpleworkflow.ActivityType;
import com.eucalyptus.simpleworkflow.SwfMetadataException;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadatas;
import com.eucalyptus.simpleworkflow.common.model.ActivityTypeConfiguration;
import com.eucalyptus.simpleworkflow.common.model.ActivityTypeDetail;
import com.eucalyptus.simpleworkflow.common.model.ActivityTypeInfo;
import com.eucalyptus.simpleworkflow.common.model.TaskList;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface ActivityTypes {
    public <T> T lookupByExample(ActivityType var1, @Nullable OwnerFullName var2, String var3, Predicate<? super ActivityType> var4, Function<? super ActivityType, T> var5) throws SwfMetadataException;

    public <T> List<T> list(OwnerFullName var1, Predicate<? super ActivityType> var2, Function<? super ActivityType, T> var3) throws SwfMetadataException;

    public <T> List<T> listDeprecatedExpired(long var1, Function<? super ActivityType, T> var3) throws SwfMetadataException;

    public ActivityType updateByExample(ActivityType var1, OwnerFullName var2, String var3, Callback<ActivityType> var4) throws SwfMetadataException;

    public ActivityType save(ActivityType var1) throws SwfMetadataException;

    public long countByDomain(OwnerFullName var1, String var2) throws SwfMetadataException;

    public List<ActivityType> deleteByExample(ActivityType var1) throws SwfMetadataException;

    public static enum ActivityTypeInfoStringFunctions implements Function<ActivityTypeInfo, String>
    {
        NAME{

            @Nullable
            public String apply(@Nullable ActivityTypeInfo activityTypeInfo) {
                return activityTypeInfo == null || activityTypeInfo.getActivityType() == null ? null : activityTypeInfo.getActivityType().getName();
            }
        };

    }

    public static enum StringFunctions implements Function<ActivityType, String>
    {
        DOMAIN{

            @Nullable
            public String apply(@Nullable ActivityType activityType) {
                return activityType == null ? null : (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)activityType.getDomain());
            }
        }
        ,
        REGISTRATION_STATUS{

            @Nullable
            public String apply(@Nullable ActivityType activityType) {
                return activityType == null ? null : Objects.toString(activityType.getState(), null);
            }
        };

    }

    @TypeMapper
    public static enum ActivityTypeToActivityTypeInfoTransform implements Function<ActivityType, ActivityTypeInfo>
    {
        INSTANCE;


        @Nullable
        public ActivityTypeInfo apply(@Nullable ActivityType activityType) {
            return activityType == null ? null : new ActivityTypeInfo().withActivityType(new com.eucalyptus.simpleworkflow.common.model.ActivityType().withName(activityType.getDisplayName()).withVersion(activityType.getActivityVersion())).withDescription(activityType.getDescription()).withCreationDate(activityType.getCreationTimestamp()).withDeprecationDate(activityType.getDeprecationTimestamp()).withStatus(Objects.toString(activityType.getState(), null));
        }
    }

    @TypeMapper
    public static enum ActivityTypeToActivityTypeDetailTransform implements Function<ActivityType, ActivityTypeDetail>
    {
        INSTANCE;


        @Nullable
        public ActivityTypeDetail apply(@Nullable ActivityType activityType) {
            return activityType == null ? null : new ActivityTypeDetail().withConfiguration(new ActivityTypeConfiguration().withDefaultTaskList(new TaskList().withName(activityType.getDefaultTaskList())).withDefaultTaskHeartbeatTimeout(this.timeout(activityType.getDefaultTaskHeartbeatTimeout())).withDefaultTaskScheduleToCloseTimeout(this.timeout(activityType.getDefaultTaskScheduleToCloseTimeout())).withDefaultTaskScheduleToStartTimeout(this.timeout(activityType.getDefaultTaskScheduleToStartTimeout())).withDefaultTaskStartToCloseTimeout(this.timeout(activityType.getDefaultTaskStartToCloseTimeout()))).withTypeInfo((ActivityTypeInfo)TypeMappers.transform((Object)((Object)activityType), ActivityTypeInfo.class));
        }

        private String timeout(Integer timeout) {
            return (String)Optional.fromNullable((Object)timeout).transform(Functions.toStringFunction()).or((Object)"NONE");
        }
    }
}

