/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.simpleworkflow.Domain;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadatas;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_activity_type")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ActivityType
extends UserMetadata<Status>
implements SimpleWorkflowMetadata.ActivityTypeMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="domain_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Domain domain;
    @Column(name="activity_version", length=64, nullable=false, updatable=false)
    private String activityVersion;
    @Column(name="description", length=1024, updatable=false)
    private String description;
    @Column(name="default_task_list", length=256, updatable=false)
    private String defaultTaskList;
    @Column(name="default_task_heartbeat_timeout", updatable=false)
    private Integer defaultTaskHeartbeatTimeout;
    @Column(name="default_task_schedule_to_close_timeout", updatable=false)
    private Integer defaultTaskScheduleToCloseTimeout;
    @Column(name="default_task_schedule_to_start_timeout", updatable=false)
    private Integer defaultTaskScheduleToStartTimeout;
    @Column(name="default_task_start_to_close_timeout", updatable=false)
    private Integer defaultTaskStartToCloseTimeout;
    @Column(name="deprecation_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deprecationTimestamp;

    protected ActivityType() {
    }

    protected ActivityType(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static ActivityType create(OwnerFullName owner, String name, String version, Domain domain, String description, String defaultTaskList, Integer defaultTaskHeartbeatTimeout, Integer defaultTaskScheduleToCloseTimeout, Integer defaultTaskScheduleToStartTimeout, Integer defaultTaskStartToCloseTimeout) {
        ActivityType activityType = new ActivityType(owner, name);
        activityType.setState(Status.Registered);
        activityType.setActivityVersion(version);
        activityType.setDomain(domain);
        activityType.setDescription(description);
        activityType.setDefaultTaskList(defaultTaskList);
        activityType.setDefaultTaskHeartbeatTimeout(defaultTaskHeartbeatTimeout);
        activityType.setDefaultTaskScheduleToCloseTimeout(defaultTaskScheduleToCloseTimeout);
        activityType.setDefaultTaskScheduleToStartTimeout(defaultTaskScheduleToStartTimeout);
        activityType.setDefaultTaskStartToCloseTimeout(defaultTaskStartToCloseTimeout);
        return activityType;
    }

    public static ActivityType exampleWithOwner(OwnerFullName owner) {
        return new ActivityType(owner, null);
    }

    public static ActivityType exampleWithName(OwnerFullName owner, String name) {
        return new ActivityType(owner, name);
    }

    public static ActivityType exampleWithUniqueName(OwnerFullName owner, String domain, String name, String version) {
        ActivityType activityType = new ActivityType(owner, name);
        activityType.setUniqueName(ActivityType.createUniqueName(owner.getAccountNumber(), domain, name, version));
        return activityType;
    }

    protected String createUniqueName() {
        return ActivityType.createUniqueName(this.getOwnerAccountNumber(), (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)this.getDomain()), this.getDisplayName(), this.getActivityVersion());
    }

    private static String createUniqueName(String accountNumber, String domain, String name, String version) {
        return accountNumber + ":" + domain + ":" + name + ":" + version;
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((SimpleWorkflow)ComponentIds.lookup(SimpleWorkflow.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"domain", (String)SimpleWorkflowMetadatas.toDisplayName().apply((Object)this.getDomain()), "activity-type", this.getDisplayName(), "version", this.getActivityVersion()});
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public String getActivityVersion() {
        return this.activityVersion;
    }

    public void setActivityVersion(String activityVersion) {
        this.activityVersion = activityVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultTaskList() {
        return this.defaultTaskList;
    }

    public void setDefaultTaskList(String defaultTaskList) {
        this.defaultTaskList = defaultTaskList;
    }

    public Integer getDefaultTaskHeartbeatTimeout() {
        return this.defaultTaskHeartbeatTimeout;
    }

    public void setDefaultTaskHeartbeatTimeout(Integer defaultTaskHeartbeatTimeout) {
        this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
    }

    public Integer getDefaultTaskScheduleToCloseTimeout() {
        return this.defaultTaskScheduleToCloseTimeout;
    }

    public void setDefaultTaskScheduleToCloseTimeout(Integer defaultTaskScheduleToCloseTimeout) {
        this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
    }

    public Integer getDefaultTaskScheduleToStartTimeout() {
        return this.defaultTaskScheduleToStartTimeout;
    }

    public void setDefaultTaskScheduleToStartTimeout(Integer defaultTaskScheduleToStartTimeout) {
        this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
    }

    public Integer getDefaultTaskStartToCloseTimeout() {
        return this.defaultTaskStartToCloseTimeout;
    }

    public void setDefaultTaskStartToCloseTimeout(Integer defaultTaskStartToCloseTimeout) {
        this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
    }

    public Date getDeprecationTimestamp() {
        return this.deprecationTimestamp;
    }

    public void setDeprecationTimestamp(Date deprecationTimestamp) {
        this.deprecationTimestamp = deprecationTimestamp;
    }

    public static enum Status implements Predicate<UserMetadata<Status>>
    {
        Registered,
        Deprecated;


        public String toString() {
            return this.name().toUpperCase();
        }

        public boolean apply(@Nullable UserMetadata<Status> metadata) {
            return metadata != null && metadata.getState() == this;
        }

        public Function<ActivityType, ActivityType> set() {
            return new Function<ActivityType, ActivityType>(){

                @Nullable
                public ActivityType apply(@Nullable ActivityType activityType) {
                    if (activityType != null && !Status.this.apply(activityType)) {
                        activityType.setState(Status.this);
                        activityType.setDeprecationTimestamp(new Date());
                    }
                    return activityType;
                }
            };
        }
    }
}

