/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow;

import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.simpleworkflow.WorkflowExecution;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflowMetadata;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_simpleworkflow")
@Table(name="swf_activity_task")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ActivityTask
extends AbstractOwnedPersistent
implements SimpleWorkflowMetadata.ActivityTaskMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="workflow_execution_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private WorkflowExecution workflowExecution;
    @Column(name="state", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private State state;
    @Column(name="domain", length=256, nullable=false, updatable=false)
    private String domain;
    @Column(name="domain_uuid", nullable=false, updatable=false)
    private String domainUuid;
    @Column(name="workflow_run_id", nullable=false, updatable=false)
    private String workflowRunId;
    @Column(name="task_list", length=256, nullable=false, updatable=false)
    private String taskList;
    @Column(name="scheduled_event_id", nullable=false, updatable=false)
    private Long scheduledEventId;
    @Column(name="started_event_id")
    private Long startedEventId;
    @Column(name="cancel_requested_event_id")
    private Long cancelRequestedEventId;
    @Column(name="activity_type", length=256, nullable=false, updatable=false)
    private String activityType;
    @Column(name="activity_version", length=64, nullable=false, updatable=false)
    private String activityVersion;
    @Column(name="input", updatable=false)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String input;
    @Column(name="schedule_to_close_timeout", updatable=false)
    private Integer scheduleToCloseTimeout;
    @Column(name="schedule_to_start_timeout", updatable=false)
    private Integer scheduleToStartTimeout;
    @Column(name="start_to_close_timeout", updatable=false)
    private Integer startToCloseTimeout;
    @Column(name="heartbeat_timeout", updatable=false)
    private Integer heartbeatTimeout;
    @Column(name="heartbeat_details", updatable=false)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String heartbeatDetails;
    @Column(name="started_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startedTimestamp;
    @Column(name="timeout_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date timeoutTimestamp;

    protected ActivityTask() {
    }

    protected ActivityTask(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static ActivityTask create(OwnerFullName ownerFullName, WorkflowExecution workflowExecution, String domain, String domainUuid, String activityId, String activityType, String activityVersion, String input, Long scheduledEventId, String taskList, Integer scheduleToCloseTimeout, Integer scheduleToStartTimeout, Integer startToCloseTimeout, Integer heartbeatTimeout) {
        ActivityTask activityTask = new ActivityTask(ownerFullName, activityId);
        activityTask.setWorkflowExecution(workflowExecution);
        activityTask.setDomain(domain);
        activityTask.setDomainUuid(domainUuid);
        activityTask.setWorkflowRunId(workflowExecution.getDisplayName());
        activityTask.setActivityType(activityType);
        activityTask.setActivityVersion(activityVersion);
        activityTask.setInput(input);
        activityTask.setScheduledEventId(scheduledEventId);
        activityTask.setStartedEventId(0L);
        activityTask.setTaskList(taskList);
        activityTask.setScheduleToCloseTimeout(scheduleToCloseTimeout);
        activityTask.setScheduleToStartTimeout(scheduleToStartTimeout);
        activityTask.setStartToCloseTimeout(startToCloseTimeout);
        activityTask.setHeartbeatTimeout(heartbeatTimeout);
        activityTask.setState(State.Pending);
        return activityTask;
    }

    public static ActivityTask exampleWithOwner(OwnerFullName owner) {
        return new ActivityTask(owner, null);
    }

    public static ActivityTask exampleWithActivityId(OwnerFullName owner, String domainName, String runId, String name) {
        ActivityTask activityTask = new ActivityTask(owner, name);
        activityTask.setDomain(domainName);
        activityTask.setWorkflowRunId(runId);
        return activityTask;
    }

    public static ActivityTask exampleWithWorkflowExecution(OwnerFullName owner, String domainName, String runId) {
        ActivityTask activityTask = new ActivityTask(owner, null);
        activityTask.setDomain(domainName);
        activityTask.setWorkflowRunId(runId);
        return activityTask;
    }

    public static ActivityTask exampleWithUniqueName(OwnerFullName owner, String runId, Long scheduledEventId) {
        ActivityTask activityTask = new ActivityTask(owner, null);
        activityTask.setUniqueName(ActivityTask.createUniqueName(owner.getAccountNumber(), runId, scheduledEventId));
        return activityTask;
    }

    public static ActivityTask examplePending(OwnerFullName ownerFullName, String domain, String taskList) {
        ActivityTask example = new ActivityTask(ownerFullName, null);
        example.setDomain(domain);
        example.setTaskList(taskList);
        example.setState(State.Pending);
        return example;
    }

    private static String createUniqueName(String accountNumber, String runId, Long scheduledEventId) {
        return accountNumber + ":" + runId + ":" + scheduledEventId;
    }

    protected String createUniqueName() {
        return ActivityTask.createUniqueName(this.getOwnerAccountNumber(), this.getWorkflowExecution().getDisplayName(), this.getScheduledEventId());
    }

    public Pair<String, Date> calculateNextTimeout() {
        Iterable taggedTimeouts = Iterables.filter((Iterable)Lists.newArrayList((Object[])new Pair[]{Pair.ropair((Object)"SCHEDULE_TO_CLOSE", (Object)ActivityTask.toTimeout(this.getCreationTimestamp(), this.getScheduleToCloseTimeout())), Pair.ropair((Object)"SCHEDULE_TO_START", (Object)ActivityTask.toTimeout(this.getCreationTimestamp(), this.getScheduleToStartTimeout())), this.getState() == State.Active ? Pair.ropair((Object)"START_TO_CLOSE", (Object)ActivityTask.toTimeout(this.getStartedTimestamp(), this.getStartToCloseTimeout())) : null, this.getState() == State.Active ? Pair.ropair((Object)"HEARTBEAT", (Object)ActivityTask.toTimeout(this.getLastUpdateTimestamp(), this.getHeartbeatTimeout())) : null}), (Predicate)Predicates.notNull());
        Function timeExtractor = Functions.compose((Function)CollectionUtils.optionalOrNull(), (Function)Pair.right());
        Long timeout = (Long)CollectionUtils.reduce((Iterable)CollectionUtils.fluent((Iterable)taggedTimeouts).transform(timeExtractor).filter(Predicates.notNull()), (Object)Long.MAX_VALUE, (Function)CollectionUtils.lmin());
        String tag = (String)Iterables.tryFind((Iterable)taggedTimeouts, (Predicate)CollectionUtils.propertyPredicate((Object)timeout, (Function)timeExtractor)).transform(Pair.left()).or((Object)"SCHEDULE_TO_CLOSE");
        return timeout == Long.MAX_VALUE ? null : Pair.pair((Object)tag, (Object)new Date(timeout));
    }

    private static Long toTimeout(Date from, Integer period) {
        return period == null ? null : Long.valueOf(from.getTime() + TimeUnit.SECONDS.toMillis(period.intValue()));
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomainUuid() {
        return this.domainUuid;
    }

    public void setDomainUuid(String domainUuid) {
        this.domainUuid = domainUuid;
    }

    public String getWorkflowRunId() {
        return this.workflowRunId;
    }

    public void setWorkflowRunId(String workflowRunId) {
        this.workflowRunId = workflowRunId;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public Long getScheduledEventId() {
        return this.scheduledEventId;
    }

    public void setScheduledEventId(Long scheduledEventId) {
        this.scheduledEventId = scheduledEventId;
    }

    public Long getStartedEventId() {
        return this.startedEventId;
    }

    public void setStartedEventId(Long startedEventId) {
        this.startedEventId = startedEventId;
    }

    public Long getCancelRequestedEventId() {
        return this.cancelRequestedEventId;
    }

    public void setCancelRequestedEventId(Long cancelRequestedEventId) {
        this.cancelRequestedEventId = cancelRequestedEventId;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityVersion() {
        return this.activityVersion;
    }

    public void setActivityVersion(String activityVersion) {
        this.activityVersion = activityVersion;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public Integer getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public void setScheduleToCloseTimeout(Integer scheduleToCloseTimeout) {
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
    }

    public Integer getScheduleToStartTimeout() {
        return this.scheduleToStartTimeout;
    }

    public void setScheduleToStartTimeout(Integer scheduleToStartTimeout) {
        this.scheduleToStartTimeout = scheduleToStartTimeout;
    }

    public Integer getStartToCloseTimeout() {
        return this.startToCloseTimeout;
    }

    public void setStartToCloseTimeout(Integer startToCloseTimeout) {
        this.startToCloseTimeout = startToCloseTimeout;
    }

    public Integer getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(Integer heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public String getHeartbeatDetails() {
        return this.heartbeatDetails;
    }

    public void setHeartbeatDetails(String heartbeatDetails) {
        this.heartbeatDetails = heartbeatDetails;
    }

    public Date getStartedTimestamp() {
        return this.startedTimestamp;
    }

    public void setStartedTimestamp(Date startedTimestamp) {
        this.startedTimestamp = startedTimestamp;
    }

    public Date getTimeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    public void setTimeoutTimestamp(Date timeoutTimestamp) {
        this.timeoutTimestamp = timeoutTimestamp;
    }

    public void updateTimeStamps() {
        super.updateTimeStamps();
        if (this.getState() == State.Active && this.startedTimestamp == null) {
            this.startedTimestamp = new Date();
        }
    }

    @PreUpdate
    @PrePersist
    protected void updateTimeout() {
        this.updateTimeStamps();
        this.setTimeoutTimestamp((Date)Optional.fromNullable(this.calculateNextTimeout()).transform(Pair.right()).orNull());
    }

    public static enum State {
        Pending,
        Active;

    }
}

