#ifndef VIENNA_RNA_PACKAGE_STRUCTURAL_DOMAINS_H
#define VIENNA_RNA_PACKAGE_STRUCTURAL_DOMAINS_H

/**
 *  @file structured_domains.h
 *  @ingroup domains_struc
 *
 *  @brief  This module provides interfaces that deal with additional structured domains in the folding grammar.
 */

/**
 *  @addtogroup domains_struc
 *
 *  @brief  Add and modify structured domains to the RNA folding grammar
 *
 *  This module provides the tools to add and modify structured domains to the production rules of the RNA folding grammar.
 *  Usually this functionality is utilized for incorporating self-enclosed structural modules that exhibit a more or less
 *  complex base pairing pattern.
 *
 */


typedef struct vrna_structured_domains_s  vrna_sd_t;


struct vrna_structured_domains_s {


};

#endif
