/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.cgi;

import cx.ath.matthew.cgi.CGIErrorHandler;
import cx.ath.matthew.cgi.CGIHeaderSentException;
import cx.ath.matthew.cgi.CGIInvalidContentFormatException;
import cx.ath.matthew.cgi.DefaultErrorHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public abstract class CGI {
    private CGIErrorHandler errorhandler = new DefaultErrorHandler();
    private boolean headers_sent = false;
    private HashMap headers = new HashMap();
    private Vector cookies = new Vector();
    private LinkedList pagedata = new LinkedList();
    private LinkedList rawdata = new LinkedList();

    public CGI() {
        System.loadLibrary("cgi-java");
    }

    private native String getenv(String var1);

    private native Object[] getfullenv(Class var1);

    private native void setenv(String var1, String var2);

    public final void header(String string, String string2) throws CGIHeaderSentException {
        if (this.headers_sent) {
            throw new CGIHeaderSentException();
        }
        this.headers.put(string.toLowerCase(), string2);
    }

    public final void setcookie(String string, String string2, String string3, String string4, Date date, boolean bl) throws CGIHeaderSentException {
        if (this.headers_sent) {
            throw new CGIHeaderSentException();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd-MMM-yyyy HH:mm:ss zzz");
        String string5 = string + "=" + string2;
        if (null != string3) {
            string5 = string5 + "; path=" + string3;
        }
        if (null != string4) {
            string5 = string5 + "; domain=" + string4;
        }
        if (null != date) {
            string5 = string5 + "; expires=" + simpleDateFormat.format(date);
        }
        if (bl) {
            string5 = string5 + "; secure";
        }
        this.cookies.add("Set-Cookie: " + string5);
    }

    public final void setcookie(String string, String string2) throws CGIHeaderSentException {
        if (this.headers_sent) {
            throw new CGIHeaderSentException();
        }
        this.cookies.add("Set-Cookie: " + string + "=" + string2);
    }

    public final void out(byte[] byArray) throws CGIInvalidContentFormatException {
        if (this.pagedata.size() > 0) {
            throw new CGIInvalidContentFormatException();
        }
        this.rawdata.add(byArray);
    }

    public final void out(String string) throws CGIInvalidContentFormatException {
        if (this.rawdata.size() > 0) {
            throw new CGIInvalidContentFormatException();
        }
        this.pagedata.add(string);
    }

    public final OutputStream getOutputStream() throws IOException {
        this.flush();
        return System.out;
    }

    public final void flush() throws IOException {
        Iterator<Object> iterator;
        if (!this.headers_sent) {
            this.headers_sent = true;
            for (String string : this.headers.keySet()) {
                String string2 = (String)this.headers.get(string);
                System.out.println(string + ": " + string2);
            }
            iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
            System.out.println();
        }
        if (this.pagedata.size() > 0) {
            iterator = this.pagedata.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
            this.pagedata.clear();
        } else if (this.rawdata.size() > 0) {
            iterator = this.rawdata.iterator();
            while (iterator.hasNext()) {
                System.out.write((byte[])iterator.next());
            }
            this.pagedata.clear();
        }
        System.out.flush();
    }

    protected final void setErrorHandler(CGIErrorHandler cGIErrorHandler) {
        this.errorhandler = cGIErrorHandler;
    }

    protected abstract void cgi(Map var1, Map var2, Map var3, Map var4, String[] var5) throws Exception;

    private Object readVariables(String string, char c, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        String string3 = null;
        block16: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (null != string2) {
                    string2 = string2.trim();
                }
                if (bl) {
                    if (string3 == null) {
                        string3 = string2;
                        string2 = "";
                    } else {
                        string3.trim();
                    }
                    if (!string3.equals("")) {
                        Object v = hashMap.get(string3);
                        if (v == null) {
                            hashMap.put(string3.trim(), string2);
                        } else if (v instanceof String) {
                            LinkedList<Object> linkedList = new LinkedList<Object>();
                            linkedList.add(v);
                            linkedList.add(string2);
                            hashMap.put(string3.trim(), linkedList);
                        } else if (v instanceof LinkedList) {
                            ((LinkedList)v).add(string2);
                        }
                    }
                    string2 = "";
                } else {
                    vector.add(string2);
                    string2 = "";
                }
                string3 = null;
                continue;
            }
            if (bl && c2 == '=') {
                string3 = string2;
                string2 = "";
                continue;
            }
            switch (c2) {
                case '%': {
                    try {
                        char c3 = string.charAt(++i);
                        char c4 = string.charAt(++i);
                        int n = 0;
                        switch (c3) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n += 16 * (c3 - 48);
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n += 16 * (c3 - 97 + 10);
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n += 16 * (c3 - 65 + 10);
                            }
                        }
                        switch (c4) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n += c4 - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n += c4 - 97 + 10;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n += c4 - 65 + 10;
                            }
                        }
                        string2 = string2 + (char)n;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    continue block16;
                }
                case '+': {
                    string2 = string2 + ' ';
                    continue block16;
                }
                default: {
                    string2 = string2 + c2;
                }
            }
        }
        if (bl) {
            if (string3 == null) {
                string3 = string2;
                string2 = "";
            } else {
                string3.trim();
            }
            if (!string3.equals("")) {
                Object v = hashMap.get(string3);
                if (v == null) {
                    hashMap.put(string3.trim(), string2);
                } else if (v instanceof String) {
                    LinkedList<Object> linkedList = new LinkedList<Object>();
                    linkedList.add(v);
                    linkedList.add(string2);
                    hashMap.put(string3.trim(), linkedList);
                } else if (v instanceof LinkedList) {
                    ((LinkedList)v).add(string2);
                }
            }
            return hashMap;
        }
        vector.add(string2);
        return vector;
    }

    private Map getPOST() {
        try {
            String string = "";
            while (System.in.available() > 0) {
                string = string + (char)System.in.read();
            }
            return (Map)this.readVariables(string, '&', true);
        }
        catch (IOException iOException) {
            try {
                this.out("ERROR: IOException: " + iOException);
            }
            catch (CGIInvalidContentFormatException cGIInvalidContentFormatException) {
                System.err.println("ERROR: IOException: " + iOException);
            }
            return new HashMap();
        }
    }

    private Map getCOOKIE() {
        String string = this.getenv("HTTP_COOKIE");
        if (null == string) {
            return new HashMap();
        }
        return (Map)this.readVariables(string, ';', true);
    }

    private Map getGET() {
        String string = this.getenv("QUERY_STRING");
        if (null == string) {
            return new HashMap();
        }
        return (Map)this.readVariables(string, '&', true);
    }

    private Map getENV() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = (String[])this.getfullenv(String.class);
        for (int i = 0; i < stringArray.length; ++i) {
            if (null == stringArray[i]) continue;
            String[] stringArray2 = stringArray[i].split("=");
            if (1 == stringArray2.length) {
                hashMap.put(stringArray2[0], "");
                continue;
            }
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    private String[] getParams(String string) {
        Vector vector = (Vector)this.readVariables(string, ',', false);
        String[] stringArray = new String[vector.size()];
        Iterator iterator = vector.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public final void doCGI(String[] stringArray) {
        Object var2_2 = null;
        try {
            Map map = this.getPOST();
            Map map2 = this.getGET();
            Map map3 = this.getENV();
            Map map4 = this.getCOOKIE();
            String[] stringArray2 = new String[]{};
            if (stringArray.length >= 1) {
                stringArray2 = this.getParams(stringArray[0]);
            }
            this.header("Content-type", "text/html");
            this.cgi(map, map2, map3, map4, stringArray2);
            this.flush();
        }
        catch (Exception exception) {
            this.errorhandler.print(this.headers_sent, exception);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.errorhandler.print(this.headers_sent, new Exception(throwable.toString()));
        }
    }
}

