/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import cx.ath.matthew.io.InOutCopier;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecOutputStream
extends FilterOutputStream {
    private Process proc;
    private InputStream stdout;
    private OutputStream stdin;
    private InOutCopier copy;

    public ExecOutputStream(OutputStream outputStream, Process process) throws IOException {
        super(outputStream);
        this.proc = process;
        this.stdin = process.getOutputStream();
        this.stdout = process.getInputStream();
        this.copy = new InOutCopier(this.stdout, this.out);
        this.copy.start();
    }

    public ExecOutputStream(OutputStream outputStream, String string) throws IOException {
        this(outputStream, Runtime.getRuntime().exec(string));
    }

    public ExecOutputStream(OutputStream outputStream, String[] stringArray) throws IOException {
        this(outputStream, Runtime.getRuntime().exec(stringArray));
    }

    public ExecOutputStream(OutputStream outputStream, String string, String[] stringArray) throws IOException {
        this(outputStream, Runtime.getRuntime().exec(string, stringArray));
    }

    public ExecOutputStream(OutputStream outputStream, String[] stringArray, String[] stringArray2) throws IOException {
        this(outputStream, Runtime.getRuntime().exec(stringArray, stringArray2));
    }

    public void close() throws IOException {
        this.stdin.close();
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.copy.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stdout.close();
        this.out.close();
    }

    public void flush() throws IOException {
        this.stdin.flush();
        this.copy.flush();
        this.out.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.stdin.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.stdin.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.stdin.write(n);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

