/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class DOMPrinter {
    public static void printNode(Node node, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        DOMPrinter.printNode(node, printStream);
    }

    public static void printNode(Node node, PrintStream printStream) {
        if (null != node.getNodeValue()) {
            printStream.print(node.getNodeValue());
        } else {
            int n;
            Object object;
            printStream.print("<" + node.getNodeName());
            if (node.hasAttributes()) {
                object = node.getAttributes();
                for (n = 0; n < object.getLength(); ++n) {
                    Node node2 = object.item(n);
                    printStream.print(" " + node2.getNodeName() + "='" + node2.getNodeValue() + "'");
                }
            }
            if (node.hasChildNodes()) {
                printStream.print(">");
                object = node.getChildNodes();
                for (n = 0; n < object.getLength(); ++n) {
                    DOMPrinter.printNode(object.item(n), printStream);
                }
                printStream.print("</" + node.getNodeName() + ">");
            } else {
                printStream.print("/>");
            }
        }
    }

    public static void printDOM(Document document, PrintStream printStream) {
        Object object;
        DocumentType documentType = document.getDoctype();
        if (null != documentType) {
            printStream.print("<!DOCTYPE " + documentType.getName());
            object = documentType.getPublicId();
            String string = documentType.getSystemId();
            if (null != object) {
                printStream.print(" PUBLIC \"" + (String)object + "\" \"" + string + "\"");
            } else if (null != string) {
                printStream.print(" SYSTEM \"" + string + "\"");
            }
            printStream.println(">");
        }
        object = document.getDocumentElement();
        DOMPrinter.printNode((Node)object, printStream);
    }

    public static void printDOM(Document document, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        DOMPrinter.printDOM(document, printStream);
    }
}

