/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.viewer.FileSaver;
import org.freedesktop.dbus.viewer.TextFile;

abstract class TabbedSaveAction
extends AbstractAction
implements Iterable<TextFile> {
    private static JFileChooser chooser;
    protected final JTabbedPane tabbedPane;

    protected TabbedSaveAction(JTabbedPane jTabbedPane) {
        this.tabbedPane = jTabbedPane;
    }

    protected TabbedSaveAction(JTabbedPane jTabbedPane, String string) {
        super(string);
        this.tabbedPane = jTabbedPane;
    }

    protected TextFile getTextFile(int n) {
        JScrollPane jScrollPane = (JScrollPane)this.tabbedPane.getComponentAt(n);
        JTextComponent jTextComponent = (JTextComponent)jScrollPane.getViewport().getView();
        String string = jTextComponent.getText();
        String string2 = this.getFileName(n);
        TextFile textFile = new TextFile(string2, string);
        return textFile;
    }

    protected String getFileName(int n) {
        return n > -1 ? this.tabbedPane.getTitleAt(n) : "";
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (chooser == null) {
            chooser = new JFileChooser();
        }
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(Gettext._((String)"Select parent directory for saving"));
        int n = chooser.showDialog(this.tabbedPane, "Select");
        if (n == 0) {
            File file = chooser.getSelectedFile();
            if (file.exists() || file.mkdirs()) {
                if (file.canWrite()) {
                    FileSaver fileSaver = new FileSaver(this.tabbedPane, file, this);
                    new Thread(fileSaver).start();
                } else {
                    JOptionPane.showMessageDialog(this.tabbedPane, Gettext._((String)"Could not write to parent directory"), Gettext._((String)"Invalid Parent Directory"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(this.tabbedPane, Gettext._((String)"Could not access parent directory"), Gettext._((String)"Invalid Parent Directory"), 0);
            }
        }
    }
}

