/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.StrongReference;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

class ExportedObject {
    Map<MethodTuple, Method> methods;
    Reference<DBusInterface> object;
    String introspectiondata;

    private String getAnnotations(AnnotatedElement annotatedElement) {
        String string = "";
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            String string2 = "";
            try {
                Method method = clazz.getMethod("value", new Class[0]);
                string2 = method.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            string = string + "  <annotation name=\"" + AbstractConnection.dollar_pattern.matcher(clazz.getName()).replaceAll(".") + "\" value=\"" + string2 + "\" />\n";
        }
        return string;
    }

    /*
     * Could not resolve type clashes
     */
    private Map<MethodTuple, Method> getExportedMethods(Class clazz) throws DBusException {
        if (DBusInterface.class.equals((Object)clazz)) {
            return new HashMap<MethodTuple, Method>();
        }
        HashMap<MethodTuple, Method> hashMap = new HashMap<MethodTuple, Method>();
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (DBusInterface.class.equals(clazz2)) {
                Object object;
                Object object2;
                String string;
                if (null != clazz.getAnnotation(DBusInterfaceName.class)) {
                    GenericDeclaration[] genericDeclarationArray = clazz.getAnnotation(DBusInterfaceName.class).value();
                    this.introspectiondata = this.introspectiondata + " <interface name=\"" + (String)genericDeclarationArray + "\">\n";
                    DBusSignal.addInterfaceMap(clazz.getName(), (String)genericDeclarationArray);
                } else {
                    if (clazz.getName().equals(clazz.getSimpleName())) {
                        throw new DBusException(Gettext._("DBusInterfaces cannot be declared outside a package"));
                    }
                    if (clazz.getName().length() > 255) {
                        throw new DBusException(Gettext._("Introspected interface name exceeds 255 characters. Cannot export objects of type ") + clazz.getName());
                    }
                    this.introspectiondata = this.introspectiondata + " <interface name=\"" + AbstractConnection.dollar_pattern.matcher(clazz.getName()).replaceAll(".") + "\">\n";
                }
                this.introspectiondata = this.introspectiondata + this.getAnnotations(clazz);
                for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                    if (!Modifier.isPublic(((Method)genericDeclaration).getModifiers())) continue;
                    string = "";
                    object2 = ((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(DBusMemberName.class) ? ((Method)genericDeclaration).getAnnotation(DBusMemberName.class).value() : ((Method)genericDeclaration).getName();
                    if (((String)object2).length() > 255) {
                        throw new DBusException(Gettext._("Introspected method name exceeds 255 characters. Cannot export objects with method ") + (String)object2);
                    }
                    this.introspectiondata = this.introspectiondata + "  <method name=\"" + (String)object2 + "\" >\n";
                    this.introspectiondata = this.introspectiondata + this.getAnnotations(genericDeclaration);
                    for (Object object3 : ((Method)genericDeclaration).getExceptionTypes()) {
                        if (!DBusExecutionException.class.isAssignableFrom((Class<?>)object3)) continue;
                        this.introspectiondata = this.introspectiondata + "   <annotation name=\"org.freedesktop.DBus.Method.Error\" value=\"" + AbstractConnection.dollar_pattern.matcher(((Class)object3).getName()).replaceAll(".") + "\" />\n";
                    }
                    for (Object object3 : ((Method)genericDeclaration).getGenericParameterTypes()) {
                        for (String string2 : Marshalling.getDBusType((Type)object3)) {
                            this.introspectiondata = this.introspectiondata + "   <arg type=\"" + string2 + "\" direction=\"in\"/>\n";
                            string = string + string2;
                        }
                    }
                    if (!Void.TYPE.equals(((Method)genericDeclaration).getGenericReturnType())) {
                        if (Tuple.class.isAssignableFrom(((Method)genericDeclaration).getReturnType())) {
                            Type[] typeArray;
                            object = (ParameterizedType)((Method)genericDeclaration).getGenericReturnType();
                            for (Type type : typeArray = object.getActualTypeArguments()) {
                                if (type == null) continue;
                                for (String string3 : Marshalling.getDBusType(type)) {
                                    this.introspectiondata = this.introspectiondata + "   <arg type=\"" + string3 + "\" direction=\"out\"/>\n";
                                }
                            }
                        } else {
                            if (Object[].class.equals((Object)((Method)genericDeclaration).getGenericReturnType())) {
                                throw new DBusException(Gettext._("Return type of Object[] cannot be introspected properly"));
                            }
                            for (Object object3 : Marshalling.getDBusType(((Method)genericDeclaration).getGenericReturnType())) {
                                this.introspectiondata = this.introspectiondata + "   <arg type=\"" + (String)object3 + "\" direction=\"out\"/>\n";
                            }
                        }
                    }
                    this.introspectiondata = this.introspectiondata + "  </method>\n";
                    hashMap.put(new MethodTuple((String)object2, string), (Method)genericDeclaration);
                }
                for (GenericDeclaration genericDeclaration : clazz.getDeclaredClasses()) {
                    if (!DBusSignal.class.isAssignableFrom((Class<?>)genericDeclaration)) continue;
                    if (((Class)genericDeclaration).isAnnotationPresent(DBusMemberName.class)) {
                        string = ((Class)genericDeclaration).getAnnotation(DBusMemberName.class).value();
                        DBusSignal.addSignalMap(((Class)genericDeclaration).getSimpleName(), string);
                    } else {
                        string = ((Class)genericDeclaration).getSimpleName();
                    }
                    if (string.length() > 255) {
                        throw new DBusException(Gettext._("Introspected signal name exceeds 255 characters. Cannot export objects with signals of type ") + string);
                    }
                    this.introspectiondata = this.introspectiondata + "  <signal name=\"" + string + "\">\n";
                    object2 = ((Class)genericDeclaration).getConstructors()[0];
                    object = ((Constructor)object2).getGenericParameterTypes();
                    for (int i = 1; i < ((Type[])object).length; ++i) {
                        for (String string4 : Marshalling.getDBusType(object[i])) {
                            this.introspectiondata = this.introspectiondata + "   <arg type=\"" + string4 + "\" direction=\"out\" />\n";
                        }
                    }
                    this.introspectiondata = this.introspectiondata + this.getAnnotations(genericDeclaration);
                    this.introspectiondata = this.introspectiondata + "  </signal>\n";
                }
                this.introspectiondata = this.introspectiondata + " </interface>\n";
                continue;
            }
            hashMap.putAll(this.getExportedMethods(clazz2));
        }
        return hashMap;
    }

    public ExportedObject(DBusInterface dBusInterface, boolean bl) throws DBusException {
        this.object = bl ? new WeakReference<DBusInterface>(dBusInterface) : new StrongReference<DBusInterface>(dBusInterface);
        this.introspectiondata = "";
        this.methods = this.getExportedMethods(dBusInterface.getClass());
        this.introspectiondata = this.introspectiondata + " <interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n   <arg type=\"s\" direction=\"out\"/>\n  </method>\n </interface>\n";
        this.introspectiondata = this.introspectiondata + " <interface name=\"org.freedesktop.DBus.Peer\">\n  <method name=\"Ping\">\n  </method>\n </interface>\n";
    }
}

