/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Gettext;

class ArrayFrob {
    static Hashtable<Class<? extends Object>, Class<? extends Object>> primitiveToWrapper = new Hashtable();
    static Hashtable<Class<? extends Object>, Class<? extends Object>> wrapperToPrimitive = new Hashtable();

    ArrayFrob() {
    }

    public static <T> T[] wrap(Object object) throws IllegalArgumentException {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException(Gettext._("Not an array"));
        }
        Class<?> clazz2 = clazz.getComponentType();
        Class<? extends Object> clazz3 = primitiveToWrapper.get(clazz2);
        if (null == clazz3) {
            throw new IllegalArgumentException(Gettext._("Not a primitive type"));
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz3, Array.getLength(object));
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }

    public static <T> Object unwrap(T[] TArray) throws IllegalArgumentException {
        Class<?> clazz = TArray.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        Class<? extends Object> clazz3 = wrapperToPrimitive.get(clazz2);
        if (null == clazz3) {
            throw new IllegalArgumentException(Gettext._("Not a wrapper type"));
        }
        Object object = Array.newInstance(clazz3, TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            Array.set(object, i, TArray[i]);
        }
        return object;
    }

    public static <T> List<T> listify(T[] TArray) throws IllegalArgumentException {
        return Arrays.asList(TArray);
    }

    public static <T> List<T> listify(Object object) throws IllegalArgumentException {
        if (object instanceof Object[]) {
            return ArrayFrob.listify((Object[])object);
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException(Gettext._("Not an array"));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Array.getLength(object));
        for (int i = 0; i < Array.getLength(object); ++i) {
            arrayList.add(Array.get(object, i));
        }
        return arrayList;
    }

    public static <T> T[] delist(List<T> list, Class<T> clazz) throws IllegalArgumentException {
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T> Object delistprimitive(List<T> list, Class<T> clazz) throws IllegalArgumentException {
        Object object = Array.newInstance(clazz, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(object, i, list.get(i));
        }
        return object;
    }

    public static Object convert(Object object, Class<? extends Object> clazz) throws IllegalArgumentException {
        try {
            if (List.class.equals(clazz) && object instanceof List) {
                return object;
            }
            if (List.class.equals(clazz) && object.getClass().isArray()) {
                return ArrayFrob.listify(object);
            }
            if (object.getClass().isArray() && clazz.isArray() && object.getClass().getComponentType().equals(clazz.getComponentType())) {
                return object;
            }
            if (object.getClass().isArray() && clazz.isArray() && object.getClass().getComponentType().isPrimitive()) {
                return ArrayFrob.wrap(object);
            }
            if (object.getClass().isArray() && clazz.isArray() && clazz.getComponentType().isPrimitive()) {
                return ArrayFrob.unwrap((Object[])object);
            }
            if (object instanceof List && clazz.isArray() && clazz.getComponentType().isPrimitive()) {
                return ArrayFrob.delistprimitive((List)object, clazz.getComponentType());
            }
            if (object instanceof List && clazz.isArray()) {
                return ArrayFrob.delist((List)object, clazz.getComponentType());
            }
            if (object.getClass().isArray() && clazz.isArray()) {
                return ArrayFrob.type((Object[])object, clazz.getComponentType());
            }
        }
        catch (Exception exception) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new IllegalArgumentException(exception);
        }
        throw new IllegalArgumentException(MessageFormat.format(Gettext._("Not An Expected Convertion type from {0} to {1}"), object.getClass(), clazz));
    }

    public static Object[] type(Object[] objectArray, Class<Object> clazz) {
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    static {
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
    }
}

