/*
 * Decompiled with CFR 0.152.
 */
package net.zemberekserver.server.socket;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.zemberek.erisim.Zemberek;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class ZemberekServerProtocolHandler
extends IoHandlerAdapter {
    private Set<IoSession> sessions = Collections.synchronizedSet(new HashSet());
    private Zemberek zemberek;

    public ZemberekServerProtocolHandler(Zemberek zemberek) {
        this.zemberek = zemberek;
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
        throwable.printStackTrace();
        ioSession.close();
        this.sessions.remove(ioSession);
    }

    public void messageReceived(IoSession ioSession, Object object) throws Exception {
        byte[] byArray = (byte[])object;
        String string = new String(byArray, "UTF-8");
        ioSession.write((Object)this.processMessage(string));
    }

    private synchronized String processMessage(String string) {
        try {
            System.out.println("Alinan mesaj: " + string + " Timestamp: " + System.currentTimeMillis());
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length < 2) {
                return "?";
            }
            if (stringArray[0].equals("*")) {
                int n = 1;
                if (n < stringArray.length) {
                    if (this.zemberek.kelimeDenetle(stringArray[n].trim())) {
                        return "*";
                    }
                    return "#";
                }
            } else {
                if (stringArray[0].equals("&")) {
                    String[] stringArray2 = this.zemberek.oner(stringArray[1].trim());
                    if (stringArray2.length == 0) {
                        return "#";
                    }
                    String string2 = "& (";
                    for (int i = 0; i < stringArray2.length; ++i) {
                        string2 = string2 + stringArray2[i];
                        if (i >= stringArray2.length - 1) continue;
                        string2 = string2 + ",";
                    }
                    string2 = string2 + ")";
                    return string2;
                }
                if (stringArray[0].equals("-")) {
                    String string3 = "- ";
                    String[] stringArray3 = this.zemberek.hecele(stringArray[1].trim());
                    for (int i = 0; i < stringArray3.length; ++i) {
                        string3 = string3 + stringArray3[i];
                        if (i >= stringArray3.length - 1) continue;
                        string3 = string3 + "-";
                    }
                    return string3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "?";
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        System.out.println("Session closed");
        this.sessions.remove(ioSession);
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        System.out.println("Session created");
        if (!this.sessions.contains(ioSession)) {
            this.sessions.add(ioSession);
        }
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
    }
}

