/*
 * Decompiled with CFR 0.152.
 */
package net.zemberekserver.server;

import java.io.IOException;
import net.zemberek.erisim.Zemberek;
import net.zemberek.tr.yapi.TurkiyeTurkcesi;
import net.zemberek.yapi.DilAyarlari;
import net.zemberekserver.server.Config;
import net.zemberekserver.server.dbus.ZemberekDbus;
import net.zemberekserver.server.socket.SocketServer;

public class ZemberekServer {
    Zemberek zemberek;
    SocketServer socketServer = null;
    ZemberekDbus zemberekDbus = null;

    public void init() {
        this.zemberek = new Zemberek((DilAyarlari)new TurkiyeTurkcesi());
    }

    public void initSocketServer() throws IOException {
        this.socketServer = new SocketServer();
        this.socketServer.init(this.zemberek, Config.serverPort, Config.allowRemote);
    }

    public void initDBusServer() {
        ZemberekDbus.start(this.zemberek, Config.busName);
    }

    public void shutdown() {
        if (this.socketServer != null) {
            this.socketServer.shutdown();
        }
        if (this.zemberekDbus != null) {
            // empty if block
        }
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        ZemberekServer zemberekServer = new ZemberekServer();
        zemberekServer.init();
        if (Config.useSockets) {
            try {
                zemberekServer.initSocketServer();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                zemberekServer.shutdown();
            }
        }
        if (Config.useDbus) {
            zemberekServer.initDBusServer();
        }
        System.out.println("Baslatim zamani: " + (System.currentTimeMillis() - l) + "ms.");
    }
}

