/*
 * Decompiled with CFR 0.152.
 */
package net.zemberekserver.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import net.zemberekserver.client.ClientProtocolHandler;
import net.zemberekserver.client.TestMessage;
import net.zemberekserver.server.socket.ZemberekProtocolCodecFactory;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class SocketClient
extends Thread {
    Random r = new Random();
    private ClientProtocolHandler handler = null;
    private IoSession session;
    SocketConnector connector = new SocketConnector();

    public boolean connect() {
        InetSocketAddress inetSocketAddress = new InetSocketAddress("127.0.0.1", 10444);
        this.handler = new ClientProtocolHandler();
        if (this.session != null && this.session.isConnected()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        try {
            SocketConnectorConfig socketConnectorConfig = new SocketConnectorConfig();
            DefaultIoFilterChainBuilder defaultIoFilterChainBuilder = socketConnectorConfig.getFilterChain();
            defaultIoFilterChainBuilder.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ZemberekProtocolCodecFactory()));
            ConnectFuture connectFuture = this.connector.connect((SocketAddress)inetSocketAddress, (IoHandler)this.handler, (IoServiceConfig)socketConnectorConfig);
            connectFuture.join(3000L);
            if (!connectFuture.isConnected()) {
                System.out.println("Server not running.");
                return false;
            }
            this.session = connectFuture.getSession();
            System.out.println("Session created!");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void run() {
        this.connect();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (i % 100 == 0) {
                System.out.print(".");
            }
            this.handler.sendTestMessage(new TestMessage("* do\u011fru", "*"));
        }
        System.out.println("Sure: " + (System.currentTimeMillis() - l));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            SocketClient socketClient = new SocketClient();
            socketClient.start();
        }
    }

    public void startTest(ClientProtocolHandler clientProtocolHandler) {
        System.out.println("Zemberek oturumu haz\u0131r. Test ba\u015flad\u0131.");
        try {
            clientProtocolHandler.sendTestMessage(new TestMessage("* test", "*"));
            clientProtocolHandler.sendTestMessage(new TestMessage("* tset", "#"));
            clientProtocolHandler.sendTestMessage(new TestMessage("* yapabilirlerse", "*"));
            clientProtocolHandler.sendTestMessage(new TestMessage("* imbiklerin", "*"));
            clientProtocolHandler.sendTestMessage(new TestMessage("* mrhaba", "#"));
            clientProtocolHandler.sendTestMessage(new TestMessage("& mrhaba", "& (merhaba)"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Test ba\u015far\u0131s\u0131z.");
            System.exit(0);
        }
    }
}

