/*
 *  OpenSCAD (www.openscad.org)
 *  Copyright (C) 2009-2011 Clifford Wolf <clifford@clifford.at> and
 *                          Marius Kintel <marius@kintel.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  As a special exception, you have permission to link this program
 *  with the CGAL library and distribute executables, as long as you
 *  follow the requirements of the GNU GPL in regard to all of the
 *  software in the executable aside from CGAL.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "module.h"
#include "context.h"
#include "value.h"
#include <sstream>

AbstractModule::~AbstractModule()
{
}

double AbstractModule::lookup_double_variable_with_default(Context &c, std::string variable, double def) const
{
	ValuePtr v = c.lookup_variable(variable, true);
	return (v->type() == Value::ValueType::NUMBER) ? v->toDouble() : def;
}

std::string AbstractModule::lookup_string_variable_with_default(Context &c, std::string variable, std::string def) const
{
	ValuePtr v = c.lookup_variable(variable, true);
	return (v->type() == Value::ValueType::STRING) ? v->toString() : def;
}

std::string AbstractModule::dump(const std::string &indent, const std::string &name) const
{
	std::stringstream dump;
	dump << indent << "abstract module " << name << "();\n";
	return dump.str();
}
