//////////////////////////////////////////////////////////////////////////////
// Name:        SVGPointList.cpp
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by genList.py
//////////////////////////////////////////////////////////////////////////////

#include "SVGPointList.h"
#include <wx/tokenzr.h>
#include <wx/arrimpl.cpp>
WX_DEFINE_OBJARRAY(wxSVGPointListBase);

wxString wxSVGPointList::GetValueAsString() const {
	wxString value;
	for (int i = 0; i < (int) GetCount(); i++) {
		if (i > 0) {
			value += wxT("; ");
		}
		value += wxString::Format(wxT("%g,%g"), Item(i).GetX(), Item(i).GetY());
	}
	return value;
}

void wxSVGPointList::SetValueAsString(const wxString& value) {
	Clear();
	double x, y;
	wxStringTokenizer tkz(value, wxT(";"));
	while (tkz.HasMoreTokens()) {
		wxString token = tkz.GetNextToken().Strip(wxString::both);
		if (token.length() && token.Find(wxT(',')) > 0
				&& token.BeforeFirst(wxT(',')).ToDouble(&x)
				&& token.AfterFirst(wxT(',')).ToDouble(&y)) {
			Add(wxSVGPoint(x, y));
		}
	}
}
