static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (string, _(\"Text\"), \"Hello\")                              \n"
"    description(_(\"String to display (utf8)\"))                              \n"
"    ui_meta    (\"multiline\", \"true\")                                      \n"
"                                                                              \n"
"property_string (font, _(\"Font family\"), \"Sans\")                          \n"
"    description(_(\"Font family (utf8)\"))                                    \n"
"                                                                              \n"
"property_double (size, _(\"Size\"), 10.0)                                     \n"
"    description (_(\"Font size in pixels.\"))                                 \n"
"    value_range (0.0, 2048.0)                                                 \n"
"                                                                              \n"
"property_color  (color, _(\"Color\"), \"black\")                              \n"
"    /* TRANSLATORS: the string 'black' should not be translated */            \n"
"    description(_(\"Color for the text (defaults to 'black')\"))              \n"
"                                                                              \n"
"property_int  (wrap, _(\"Wrap width\"), -1)                                   \n"
"    description (_(\"Sets the width in pixels at which long lines will wrap. \"\n"
"                     \"Use -1 for no wrapping.\"))                            \n"
"    value_range (-1, 1000000)                                                 \n"
"property_int  (vertical_wrap, _(\"Wrap height\"), 0)                          \n"
"    description (_(\"Sets the height in pixels according to which the text is \"\n"
"                   \"vertically justified. \"                                 \n"
"                   \"Use -1 for no vertical justification.\"))                \n"
"    value_range (-1, 1000000)                                                 \n"
"                                                                              \n"
"property_int    (alignment, _(\"Justification\"), 0)                          \n"
"    value_range (0, 2)                                                        \n"
"    description (_(\"Alignment for multi-line text (0=Left, 1=Center, 2=Right)\"))\n"
"                                                                              \n"
"property_int    (vertical_alignment, _(\"Vertical justification\"), 0)        \n"
"    value_range (0, 2)                                                        \n"
"    description (_(\"Vertical text alignment (0=Top, 1=Middle, 2=Bottom)\"))  \n"
"                                                                              \n"
"property_int (width, _(\"Width\"), 0)                                         \n"
"    description (_(\"Rendered width in pixels. (read only)\"))                \n"
"property_int    (height, _(\"Height\"), 0)                                    \n"
"    description (_(\"Rendered height in pixels. (read only)\"))               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#include <gegl-plugin.h>                                                      \n"
"#include <cairo.h>                                                            \n"
"#include <pango/pango-attributes.h>                                           \n"
"#include <pango/pangocairo.h>                                                 \n"
"                                                                              \n"
"/* XXX: this struct is unneeded and could be folded directly into             \n"
" * struct _GeglOp                                                             \n"
" */                                                                           \n"
"typedef struct {                                                              \n"
"  gchar         *string;                                                      \n"
"  gchar         *font;                                                        \n"
"  gdouble        size;                                                        \n"
"  gint           wrap;                                                        \n"
"  gint           vertical_wrap;                                               \n"
"  gint           alignment;                                                   \n"
"  gint           vertical_alignment;                                          \n"
"  GeglRectangle  defined;                                                     \n"
"} CachedExtent;                                                               \n"
"                                                                              \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationSource parent_instance;                                        \n"
"  gpointer            properties;                                             \n"
"  CachedExtent        cex;                                                    \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationSourceClass parent_class;                                      \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#define GEGL_OP_NAME     text                                                 \n"
"#define GEGL_OP_C_SOURCE text.c                                               \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION (GEGL_TYPE_OPERATION_SOURCE)                    \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"static void text_layout_text (GeglOp        *self,                            \n"
"                              cairo_t       *cr,                              \n"
"                              gdouble        rowstride,                       \n"
"                              GeglRectangle *bounds)                          \n"
"{                                                                             \n"
"  GeglProperties       *o = GEGL_PROPERTIES (self);                           \n"
"  PangoFontDescription *desc;                                                 \n"
"  PangoLayout          *layout;                                               \n"
"  PangoAttrList        *attrs;                                                \n"
"  guint16               color[4];                                             \n"
"  gchar                *string;                                               \n"
"  gint                  alignment = 0;                                        \n"
"  PangoRectangle        ink_rect;                                             \n"
"  PangoRectangle        logical_rect;                                         \n"
"  gint                  vertical_offset = 0;                                  \n"
"                                                                              \n"
"  /* Create a PangoLayout, set the font and text */                           \n"
"  layout = pango_cairo_create_layout (cr);                                    \n"
"                                                                              \n"
"  string = g_strcompress (o->string);                                         \n"
"  pango_layout_set_text (layout, string, -1);                                 \n"
"  g_free (string);                                                            \n"
"                                                                              \n"
"  desc = pango_font_description_from_string (o->font);                        \n"
"  pango_font_description_set_absolute_size (desc, o->size * PANGO_SCALE);     \n"
"  pango_layout_set_font_description (layout, desc);                           \n"
"                                                                              \n"
"  switch (o->alignment)                                                       \n"
"  {                                                                           \n"
"  case 0:                                                                     \n"
"    alignment = PANGO_ALIGN_LEFT;                                             \n"
"    break;                                                                    \n"
"  case 1:                                                                     \n"
"    alignment = PANGO_ALIGN_CENTER;                                           \n"
"    break;                                                                    \n"
"  case 2:                                                                     \n"
"    alignment = PANGO_ALIGN_RIGHT;                                            \n"
"    break;                                                                    \n"
"  }                                                                           \n"
"  pango_layout_set_alignment (layout, alignment);                             \n"
"  pango_layout_set_width (layout, o->wrap * PANGO_SCALE);                     \n"
"                                                                              \n"
"  attrs = pango_attr_list_new ();                                             \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, babl_format (\"R'G'B'A u16\"), color);      \n"
"  pango_attr_list_insert (                                                    \n"
"    attrs,                                                                    \n"
"    pango_attr_foreground_new (color[0], color[1], color[2]));                \n"
"  pango_attr_list_insert (                                                    \n"
"    attrs,                                                                    \n"
"    pango_attr_foreground_alpha_new (color[3]));                              \n"
"                                                                              \n"
"  pango_layout_set_attributes (layout, attrs);                                \n"
"                                                                              \n"
"  /* Inform Pango to re-layout the text with the new transformation */        \n"
"  pango_cairo_update_layout (cr, layout);                                     \n"
"                                                                              \n"
"  pango_layout_get_pixel_extents (layout, &ink_rect, &logical_rect);          \n"
"  if (o->vertical_wrap >= 0)                                                  \n"
"    {                                                                         \n"
"      switch (o->vertical_alignment)                                          \n"
"      {                                                                       \n"
"      case 0: /* top */                                                       \n"
"        vertical_offset = 0;                                                  \n"
"        break;                                                                \n"
"      case 1: /* middle */                                                    \n"
"        vertical_offset = (o->vertical_wrap - logical_rect.height) / 2;       \n"
"        break;                                                                \n"
"      case 2: /* bottom */                                                    \n"
"        vertical_offset = o->vertical_wrap - logical_rect.height;             \n"
"        break;                                                                \n"
"      }                                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (bounds)                                                                 \n"
"    {                                                                         \n"
"      *bounds = *GEGL_RECTANGLE (ink_rect.x,     ink_rect.y + vertical_offset,\n"
"                                 ink_rect.width, ink_rect.height);            \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      /* When alpha is 0, Pango goes full alpha (by design).  Go figure... */ \n"
"      if (color[3] > 0)                                                       \n"
"        {                                                                     \n"
"          cairo_translate (cr, 0, vertical_offset);                           \n"
"                                                                              \n"
"          pango_cairo_show_layout (cr, layout);                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  pango_font_description_free (desc);                                         \n"
"  pango_attr_list_unref (attrs);                                              \n"
"  g_object_unref (layout);                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (operation);                                         \n"
"                                                                              \n"
"  guchar          *data = g_new0 (guchar, result->width * result->height * 4);\n"
"  cairo_t         *cr;                                                        \n"
"  cairo_surface_t *surface;                                                   \n"
"                                                                              \n"
"  surface = cairo_image_surface_create_for_data (data,                        \n"
"                                                 CAIRO_FORMAT_ARGB32,         \n"
"                                                 result->width,               \n"
"                                                 result->height,              \n"
"                                                 result->width * 4);          \n"
"  cr = cairo_create (surface);                                                \n"
"  cairo_translate (cr, -result->x, -result->y);                               \n"
"  text_layout_text (self, cr, 0, NULL);                                       \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, babl_format (\"cairo-ARGB32\"), data,   \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"                                                                              \n"
"  cairo_destroy (cr);                                                         \n"
"  cairo_surface_destroy (surface);                                            \n"
"  g_free (data);                                                              \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (operation);                                         \n"
"  GeglProperties           *o = GEGL_PROPERTIES (self);                       \n"
"  CachedExtent *extent;                                                       \n"
"  gint status = FALSE;                                                        \n"
"                                                                              \n"
"  extent = (CachedExtent*)&self->cex;                                         \n"
"  /*if (!self->priv)                                                          \n"
"    {                                                                         \n"
"      self->priv = g_malloc0 (sizeof (CachedExtent));                         \n"
"      extent = (CachedExtent*)self->priv;                                     \n"
"      extent->string = g_strdup (\"\");                                       \n"
"      extent->font = g_strdup (\"\");                                         \n"
"    }*/                                                                       \n"
"                                                                              \n"
"  if ((extent->string && strcmp (extent->string, o->string)) ||               \n"
"      (extent->font && strcmp (extent->font, o->font)) ||                     \n"
"      extent->size != o->size ||                                              \n"
"      extent->wrap != o->wrap ||                                              \n"
"      extent->alignment != o->alignment)                                      \n"
"    { /* get extents */                                                       \n"
"      cairo_t *cr;                                                            \n"
"                                                                              \n"
"      cairo_surface_t *surface  = cairo_image_surface_create (CAIRO_FORMAT_ARGB32,\n"
"          1, 1);                                                              \n"
"      cr = cairo_create (surface);                                            \n"
"      text_layout_text (self, cr, 0, &extent->defined);                       \n"
"      cairo_destroy (cr);                                                     \n"
"      cairo_surface_destroy (surface);                                        \n"
"                                                                              \n"
"      if (extent->string)                                                     \n"
"        g_free (extent->string);                                              \n"
"      extent->string = g_strdup (o->string);                                  \n"
"      if (extent->font)                                                       \n"
"        g_free (extent->font);                                                \n"
"      extent->font = g_strdup (o->font);                                      \n"
"      extent->size = o->size;                                                 \n"
"      extent->wrap = o->wrap;                                                 \n"
"      extent->alignment = o->alignment;                                       \n"
"                                                                              \n"
"      /* store the measured size for later use */                             \n"
"      o->width  = extent->defined.width  - extent->defined.x;                 \n"
"      o->height = extent->defined.height - extent->defined.y;                 \n"
"                                                                              \n"
"      /* XXX: this invalidation is *probably* unnecessary.  having            \n"
"       * get_bounding_box() cause an invalidation can be surprising,          \n"
"       * so disabling it for now.                                             \n"
"       */                                                                     \n"
"      /* gegl_operation_invalidate (operation, NULL, TRUE); */                \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (status)                                                                 \n"
"    {                                                                         \n"
"      g_warning (\"get defined region for text '%s' failed\", o->string);     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return extent->defined;                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (object);                                            \n"
"                                                                              \n"
"  if (self->cex.string)                                                       \n"
"    g_free (self->cex.string);                                                \n"
"  if (self->cex.font)                                                         \n"
"    g_free (self->cex.font);                                                  \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static const gchar *composition =                                             \n"
"    \"<?xml version='1.0'             encoding='UTF-8'?>\"                    \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:crop' width='200' height='200'/>\"                \n"
"    \"<node operation='gegl:text'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='size'>20</param>\"                                     \n"
"    \"    <param name='wrap'>200</param>\"                                    \n"
"    \"    <param name='color'>green</param>\"                                 \n"
"    \"    <param name='string'>loves or pursues or desires to obtain pain of itself, because it is pain, but occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no</param>\"\n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *operation_source_class;                           \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  operation_source_class = GEGL_OPERATION_SOURCE_CLASS (klass);               \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_source_class->process = process;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"reference-composition\", composition,                                   \n"
"    \"title\",        _(\"Render Text\"),                                     \n"
"    \"name\",         \"gegl:text\",                                          \n"
"    \"categories\",   \"render\",                                             \n"
"    \"description\",  _(\"Display a string of text using pango and cairo.\"), \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#endif                                                                        \n"
;
