static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright Dov Grobgeld 2013 <dov.grobgeld (a) gmail.com>                   \n"
" *                                                                            \n"
" * This operation saves a buffer in the npy file format. It may be            \n"
" * read into python as follows:                                               \n"
" *                                                                            \n"
" *   import numpy                                                             \n"
" *   img = numpy.load('image.npy')                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Target path and filename, use '-' for stdout\"))           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME npy_save                                                 \n"
"#define GEGL_OP_C_SOURCE npy-save.c                                           \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <string.h>                                                           \n"
"                                                                              \n"
"static gsize                                                                  \n"
"write_to_stream (GOutputStream     *stream,                                   \n"
"                 const gchar*       data,                                     \n"
"                 gsize              size)                                     \n"
"{                                                                             \n"
"  GError *error = NULL;                                                       \n"
"  gboolean success;                                                           \n"
"  gsize written;                                                              \n"
"                                                                              \n"
"  g_assert (stream);                                                          \n"
"                                                                              \n"
"  success = g_output_stream_write_all (G_OUTPUT_STREAM (stream),              \n"
"                                       (const void *) data, size, &written,   \n"
"                                       NULL, &error);                         \n"
"  if (!success || error != NULL)                                              \n"
"    {                                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      g_error_free (error);                                                   \n"
"      return 0;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return written;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"write_header (GOutputStream *stream,                                          \n"
"              gint           width,                                           \n"
"              gint           height,                                          \n"
"              gint           nb_components,                                   \n"
"              gint           bytes_per_pixel)                                 \n"
"{                                                                             \n"
"  gchar *header;                                                              \n"
"  gsize length;                                                               \n"
"                                                                              \n"
"  // Write header and version number (1.0)                                    \n"
"  write_to_stream (stream, \"\\x93NUMPY\\x01\\x00\", 8);                      \n"
"                                                                              \n"
"  if (nb_components == 3)                                                     \n"
"    {                                                                         \n"
"      header = g_strdup_printf (\"{'descr': '<f4', 'fortran_order': False,\"  \n"
"                                \" 'shape': (%d, %d, 3), } \\n\", height, width);\n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      header = g_strdup_printf (\"{'descr': '<f4', 'fortran_order': False,\"  \n"
"                                \" 'shape': (%d, %d), } \\n\", height, width);\n"
"    }                                                                         \n"
"                                                                              \n"
"  length = strlen (header);                                                   \n"
"                                                                              \n"
"  write_to_stream (stream, (const char *) &length, 2);                        \n"
"  write_to_stream (stream, header, length);                                   \n"
"                                                                              \n"
"  g_free (header);                                                            \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"save_array (GOutputStream       *stream,                                      \n"
"            GeglBuffer          *input,                                       \n"
"            const GeglRectangle *result,                                      \n"
"            const Babl          *format)                                      \n"
"{                                                                             \n"
"  gint bytes_per_pixel, bytes_per_row;                                        \n"
"  gint x = result->x, y = result->y;                                          \n"
"  gint width = result->width - result->x;                                     \n"
"  gint height = result->height - result->y;                                   \n"
"  gint column_stride = 32;                                                    \n"
"  gchar *buffer;                                                              \n"
"  gint nb_components ,row;                                                    \n"
"                                                                              \n"
"  nb_components = babl_format_get_n_components (format);                      \n"
"  bytes_per_pixel = babl_format_get_bytes_per_pixel (format);                 \n"
"                                                                              \n"
"  write_header (stream, width, height, nb_components, bytes_per_pixel);       \n"
"                                                                              \n"
"  bytes_per_row = bytes_per_pixel * width;                                    \n"
"                                                                              \n"
"  buffer = g_try_new (gchar, bytes_per_row * column_stride);                  \n"
"                                                                              \n"
"  g_assert (buffer != NULL);                                                  \n"
"                                                                              \n"
"  for (row = 0; row < height; row += column_stride)                           \n"
"    {                                                                         \n"
"      GeglRectangle tile = { x, 0, width, 0 };                                \n"
"                                                                              \n"
"      tile.y = y + row;                                                       \n"
"      tile.height = MIN (column_stride, height - row);                        \n"
"                                                                              \n"
"      gegl_buffer_get (input, &tile, 1.0, format, buffer,                     \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      write_to_stream (stream, buffer, bytes_per_row * tile.height);          \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (buffer);                                                            \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"export_numpy (GeglOperation       *operation,                                 \n"
"              GeglBuffer          *input,                                     \n"
"              const GeglRectangle *result,                                    \n"
"              GOutputStream       *stream)                                    \n"
"{                                                                             \n"
"  const Babl *input_format, *output_format;                                   \n"
"  gint nb_components;                                                         \n"
"                                                                              \n"
"  input_format = gegl_buffer_get_format (input);                              \n"
"  nb_components = babl_format_get_n_components (input_format);                \n"
"  if (nb_components >= 3)                                                     \n"
"    {                                                                         \n"
"      output_format = babl_format (\"RGB float\");                            \n"
"      nb_components = 3;                                                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      output_format = babl_format (\"Y float\");                              \n"
"      nb_components = 1;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return !save_array (stream, input, result, output_format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GOutputStream *stream;                                                      \n"
"  GFile *file = NULL;                                                         \n"
"  GError *error = NULL;                                                       \n"
"  gboolean status = TRUE;                                                     \n"
"                                                                              \n"
"  stream = gegl_gio_open_output_stream (NULL, o->path, &file, &error);        \n"
"  if (stream == NULL)                                                         \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!export_numpy (operation, input, result, stream))                       \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning (\"could not export NumPy file\");                            \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  if (stream != NULL)                                                         \n"
"    g_object_unref (stream);                                                  \n"
"                                                                              \n"
"  if (file != NULL)                                                           \n"
"    g_object_unref (file);                                                    \n"
"                                                                              \n"
"  return status;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process    = process;                                           \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",          \"gegl:npy-save\",                                     \n"
"    \"title\",       _(\"NumPy File Saver\"),                                 \n"
"    \"categories\",    \"output\",                                            \n"
"    \"description\", _(\"NumPy (Numerical Python) image saver\"),             \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".npy\", \"gegl:npy-save\");                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
