static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"   /* no properties */                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME            nop                                           \n"
"#define GEGL_OP_C_SOURCE        nop.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_nop_prepare (GeglOperation *self)                                        \n"
"{                                                                             \n"
"  const Babl *fmt = gegl_operation_get_source_format (self, \"input\");       \n"
"                                                                              \n"
"  gegl_operation_set_format (self, \"output\", fmt);                          \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_nop_process (GeglOperation        *operation,                            \n"
"                  GeglOperationContext *context,                              \n"
"                  const gchar          *output_prop,                          \n"
"                  const GeglRectangle  *result,                               \n"
"                  gint                  level)                                \n"
"{                                                                             \n"
"  GeglBuffer *input;                                                          \n"
"                                                                              \n"
"  if (strcmp (output_prop, \"output\"))                                       \n"
"    {                                                                         \n"
"      g_warning (\"requested processing of %s pad on a nop\", output_prop);   \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  input = GEGL_BUFFER (gegl_operation_context_get_object (context, \"input\"));\n"
"  if (!input)                                                                 \n"
"    {                                                                         \n"
"      g_warning (\"nop received NULL input\");                                \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_context_take_object (context, \"output\", g_object_ref (input));\n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  operation_class->process = gegl_nop_process;                                \n"
"  operation_class->prepare = gegl_nop_prepare;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"              \"name\",        \"gegl:nop\",                                  \n"
"              \"title\",       _(\"No Operation\"),                           \n"
"              \"categories\",  \"core\",                                      \n"
"              \"description\", _(\"No operation (can be used as a routing point)\"),\n"
"              NULL);                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
