static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 1997 Andrew Kieschnick (andrewk@mail.utexas.edu)             \n"
" *                                                                            \n"
" * Original deinterlace for GIMP 0.54 API by Federico Mena Quintero           \n"
" *                                                                            \n"
" * Copyright (C) 1996 Federico Mena Quintero                                  \n"
" *                                                                            \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_deinterlace_keep)                                            \n"
"  enum_value (GEGL_DEINTERLACE_KEEP_EVEN, \"even\", N_(\"Keep even fields\")) \n"
"  enum_value (GEGL_DEINTERLACE_KEEP_ODD,  \"odd\",  N_(\"Keep odd fields\"))  \n"
"enum_end (GeglDeinterlaceKeep)                                                \n"
"                                                                              \n"
"property_enum (keep, _(\"Keep\"),                                             \n"
"  GeglDeinterlaceKeep, gegl_deinterlace_keep,                                 \n"
"  GEGL_DEINTERLACE_KEEP_EVEN)                                                 \n"
"  description(_(\"Keep even or odd fields\"))                                 \n"
"                                                                              \n"
"property_enum (orientation, _(\"Orientation\"),                               \n"
"  GeglOrientation, gegl_orientation,                                          \n"
"  GEGL_ORIENTATION_HORIZONTAL)                                                \n"
"  description(_(\"Deinterlace horizontally or vertically\"))                  \n"
"                                                                              \n"
"property_int  (size, _(\"Block size\"), 1)                                    \n"
"  value_range (0, 100)                                                        \n"
"  description (_(\"Block size of deinterlacing rows/columns\"))               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     deinterlace                                          \n"
"#define GEGL_OP_C_SOURCE deinterlace.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties              *o       = GEGL_PROPERTIES (operation);         \n"
"                                                                              \n"
"  if (o->orientation == GEGL_ORIENTATION_HORIZONTAL)                          \n"
"    {                                                                         \n"
"      op_area->left = op_area->right = 0;                                     \n"
"      op_area->top = op_area->bottom = o->size + 1;                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      op_area->left = op_area->right = o->size + 1;                           \n"
"      op_area->top = op_area->bottom = 0;                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"deinterlace_horizontal (gfloat              *src_buf,                         \n"
"                        gfloat              *dest,                            \n"
"                        const GeglRectangle *result,                          \n"
"                        const GeglRectangle *extended,                        \n"
"                        const GeglRectangle *boundary,                        \n"
"                        gint                 inter,                           \n"
"                        gint                 y,                               \n"
"                        gint                 size)                            \n"
"{                                                                             \n"
"  gfloat upper[4];                                                            \n"
"  gfloat lower[4];                                                            \n"
"  gfloat temp_buf[4];                                                         \n"
"  gint   x;                                                                   \n"
"  gint   up_offset;                                                           \n"
"  gint   low_offset;                                                          \n"
"  gint   offset = 0;                                                          \n"
"  gint   i;                                                                   \n"
"                                                                              \n"
"  for (x=0; x < result->width; x++)                                           \n"
"    {                                                                         \n"
"      gfloat ualpha, lalpha, temp;                                            \n"
"      gfloat alpha = 0;                                                       \n"
"                                                                              \n"
"      temp_buf[0] = temp_buf[1] = temp_buf[2] = temp_buf[3] = 0;              \n"
"                                                                              \n"
"      for (i = 0; i < size; i++)                                              \n"
"        {                                                                     \n"
"          gint b;                                                             \n"
"                                                                              \n"
"          if (y  - i> 0)                                                      \n"
"            up_offset = (y - i - extended->y) * extended->width * 4;          \n"
"          else                                                                \n"
"            up_offset = inter * extended->width * 4;                          \n"
"                                                                              \n"
"          if (y + i + 1 < boundary->height)                                   \n"
"            low_offset = (y + i + 1 - extended->y) * extended->width * 4;     \n"
"          else                                                                \n"
"            low_offset = (y - 1 + inter - extended->y) * extended->width * 4; \n"
"                                                                              \n"
"          offset = (y - result->y) * extended->width * 4;                     \n"
"                                                                              \n"
"          for (b=0; b<4; b++)                                                 \n"
"            {                                                                 \n"
"              upper[b] = src_buf[up_offset + x * 4 + b];                      \n"
"              lower[b] = src_buf[low_offset + x * 4 + b];                     \n"
"            }                                                                 \n"
"                                                                              \n"
"          ualpha = upper[3];                                                  \n"
"          lalpha = lower[3];                                                  \n"
"          temp   = ualpha + lalpha;                                           \n"
"          alpha += temp;                                                      \n"
"                                                                              \n"
"          for (b=0; b < 3; b++)                                               \n"
"            temp_buf[b] += (upper[b] * ualpha +                               \n"
"                            lower[b] * lalpha);                               \n"
"        }                                                                     \n"
"                                                                              \n"
"      if ((dest[offset + x * 4 + 3] = alpha / (2 * size)))                    \n"
"        {                                                                     \n"
"          gint b;                                                             \n"
"          for (b=0; b < 3; b++)                                               \n"
"            dest[offset + x * 4 + b] = temp_buf[b] / alpha;                   \n"
"                                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"deinterlace_vertical (gfloat              *src_buf,                           \n"
"                      gfloat              *dest,                              \n"
"                      const GeglRectangle *result,                            \n"
"                      const GeglRectangle *extended,                          \n"
"                      const GeglRectangle *boundary,                          \n"
"                      gint                 inter,                             \n"
"                      gint                 x,                                 \n"
"                      gint                 size)                              \n"
"{                                                                             \n"
"  gfloat upper[4];                                                            \n"
"  gfloat lower[4];                                                            \n"
"  gfloat temp_buf[4];                                                         \n"
"  gint   y;                                                                   \n"
"  gint   up_offset;                                                           \n"
"  gint   low_offset;                                                          \n"
"  gint   offset = 0;                                                          \n"
"  gint   i;                                                                   \n"
"                                                                              \n"
"  for (y=result->y; y < result->y + result->height; y++)                      \n"
"    {                                                                         \n"
"      gfloat ualpha, lalpha, temp;                                            \n"
"      gfloat alpha = 0;                                                       \n"
"                                                                              \n"
"      temp_buf[0] = temp_buf[1] = temp_buf[2] = temp_buf[3] = 0;              \n"
"                                                                              \n"
"      for (i = 0; i < size; i++)                                              \n"
"        {                                                                     \n"
"          gint b;                                                             \n"
"                                                                              \n"
"          if (x  - i > 0)                                                     \n"
"            up_offset = (y - extended->y) * extended->width * 4               \n"
"              + (x - i - extended->x) * 4;                                    \n"
"          else                                                                \n"
"            up_offset = (y - extended->y) * extended->width * 4 + inter * 4;  \n"
"                                                                              \n"
"          if (x + i + 1 < boundary->width)                                    \n"
"            low_offset = (y - extended->y) * extended->width * 4 +            \n"
"              (x + i + 1 - extended->x) * 4;                                  \n"
"          else                                                                \n"
"            low_offset = (y - extended->y) * extended->width * 4 +            \n"
"              (x + i - 1 + inter - extended->x) * 4;                          \n"
"                                                                              \n"
"          offset = (y - result->y) * result->width * 4 + (x - result->x) * 4; \n"
"                                                                              \n"
"          for (b=0; b<4; b++)                                                 \n"
"            {                                                                 \n"
"              upper[b] = src_buf[up_offset + b];                              \n"
"              lower[b] = src_buf[low_offset + b];                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          ualpha = upper[3];                                                  \n"
"          lalpha = lower[3];                                                  \n"
"          temp   = ualpha + lalpha;                                           \n"
"          alpha += temp;                                                      \n"
"                                                                              \n"
"          for (b=0; b < 3; b++)                                               \n"
"            temp_buf[b] += (upper[b] * ualpha +                               \n"
"                            lower[b] * lalpha);                               \n"
"        }                                                                     \n"
"                                                                              \n"
"      if ((dest[offset + 3] = alpha / (2 * size)))                            \n"
"        {                                                                     \n"
"          gint b;                                                             \n"
"          for (b=0; b < 3; b++)                                               \n"
"            dest[offset + b] = temp_buf[b] / alpha;                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties              *o        = GEGL_PROPERTIES (operation);        \n"
"  GeglOperationAreaFilter *op_area  = GEGL_OPERATION_AREA_FILTER (operation); \n"
"  const Babl              *format   = babl_format (\"RGBA float\");           \n"
"  GeglRectangle            rect;                                              \n"
"  GeglRectangle            boundary = get_bounding_box (operation);           \n"
"  gint                     x, y;                                              \n"
"  gfloat                  *dst_buf, *src_buf;                                 \n"
"                                                                              \n"
"  rect.x      = CLAMP (result->x - op_area->left, boundary.x, boundary.x +    \n"
"                       boundary.width);                                       \n"
"  rect.width  = CLAMP (result->width + op_area->left + op_area->right, 0,     \n"
"                       boundary.width);                                       \n"
"  rect.y      = CLAMP (result->y - op_area->top, boundary.y, boundary.y +     \n"
"                       boundary.width);                                       \n"
"  rect.height = CLAMP (result->height + op_area->top + op_area->bottom, 0,    \n"
"                       boundary.height);                                      \n"
"                                                                              \n"
"  dst_buf = g_new0 (gfloat, result->height * result->width * 4);              \n"
"  src_buf = g_new0 (gfloat, rect.height * rect.width * 4);                    \n"
"                                                                              \n"
"  gegl_buffer_get (input, result, 1.0, format, dst_buf,                       \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"  gegl_buffer_get (input, &rect, 1.0, format, src_buf,                        \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  if (o->orientation == GEGL_ORIENTATION_HORIZONTAL)                          \n"
"    {                                                                         \n"
"      for (y = result->y; y < result->y + result->height; y++)                \n"
"        if ((o->keep == GEGL_DEINTERLACE_KEEP_EVEN && (y % 2 == 0)) ||        \n"
"            (o->keep == GEGL_DEINTERLACE_KEEP_ODD  && (y % 2 != 0)))          \n"
"          {                                                                   \n"
"            deinterlace_horizontal (src_buf, dst_buf, result, &rect, &boundary,\n"
"                                    o->keep,                                  \n"
"                                    y, o->size);                              \n"
"          }                                                                   \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      for (x = result->x; x < result->x + result->width; x++)                 \n"
"        if ((o->keep == GEGL_DEINTERLACE_KEEP_EVEN && (x % 2 == 0)) ||        \n"
"            (o->keep == GEGL_DEINTERLACE_KEEP_ODD  && (x % 2 != 0)))          \n"
"          {                                                                   \n"
"            deinterlace_vertical (src_buf, dst_buf, result, &rect, &boundary, \n"
"                                  o->keep,                                    \n"
"                                  x, o->size);                                \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);  \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare           = prepare;                               \n"
"  operation_class->get_bounding_box  = get_bounding_box;                      \n"
"  filter_class->process              = process;                               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:deinterlace\",                             \n"
"    \"title\",              _(\"Deinterlace\"),                               \n"
"    \"categories\",         \"enhance\",                                      \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"reference-hash\",     \"663e775f191a41aaf1039b883615d786\",             \n"
"    \"description\", _(\"Fix images where every other row or column is missing\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
