package main

import (
	"ci.cert.uni-stuttgart.de/pub/socks-router/socks"
)

type socksHandler struct {
	handler ConnHandler
}

func (h socksHandler) Detect(peek []byte) (ConnHandler, error) {
	// first byte "0x04" or "0x05" -> SOCKS4 (or 4A) or SOCKS5
	if len(peek) > 0 && (4 == peek[0] || 5 == peek[0]) {
		return h.handler, nil
	} else {
		return nil, nil
	}
}

func CreateSocksHandler(dialer Dialer) (ProtocolHandler, error) {
	server := socks.Server{
		Dialer: dialer,
	}

	return socksHandler{server}, nil
}
