//
// C++ Implementation: csettingsdialog
//
// Author: Oliver Groß <z.o.gross@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
#include "csettingsdialog.h"
#include <QColorDialog>

namespace qbat {
	CSettingsDialog::CSettingsDialog(QWidget * parent) : QDialog(parent) {
		ui.setupUi(this);
		setWindowIcon(QIcon(PATH_ICON_QBAT));
		
		colorSelectButtons.setExclusive(false);
		
		colorSelectButtons.addButton(ui.bgColorButton, 1 + INT_COLOR_BRUSH_MAIN);
		
		colorSelectButtons.addButton(ui.pillarChargingColorButton, 1 + INT_COLOR_BRUSH_CHARGING);
		colorSelectButtons.addButton(ui.pillarDischargingColorButton, 1 + INT_COLOR_BRUSH_DISCHARGING);
		colorSelectButtons.addButton(ui.pillarFullColorButton, 1 + INT_COLOR_BRUSH_FULL);
		
		colorSelectButtons.addButton(ui.labelBgColorButton, 1 + INT_COLOR_BRUSH_LABEL);
		
		colorSelectButtons.addButton(ui.textChargingColorButton, 1 + INT_COLOR_PEN_CHARGING);
		colorSelectButtons.addButton(ui.textDischargingColorButton, 1 + INT_COLOR_PEN_DISCHARGING);
		colorSelectButtons.addButton(ui.textFullColorButton, 1 + INT_COLOR_PEN_FULL);
		
		colorSelectButtons.addButton(ui.poleChargingColorButton, 1 + INT_COLOR_BRUSH_POLE_CHARGING);
		colorSelectButtons.addButton(ui.poleDischargingColorButton, 1 + INT_COLOR_BRUSH_POLE_DISCHARGING);
		colorSelectButtons.addButton(ui.poleFullColorButton, 1 + INT_COLOR_BRUSH_POLE_FULL);
		
		connect(&colorSelectButtons, SIGNAL(buttonClicked(int)), this, SLOT(editColor(int)));
	}
	
	CSettingsDialog::~CSettingsDialog() {}
	
	void CSettingsDialog::applySettings() {
		m_Settings->handleCritical = ui.criticalGroup->isChecked();
		m_Settings->criticalCapacity = ui.criticalCapacitySpin->value();
		
		m_Settings->executeCommand = ui.criticalCommandRadio->isChecked();
		m_Settings->criticalCommand = ui.criticalCommandEdit->text();
		
		m_Settings->confirmCommand = ui.confirmCommandGroup->isChecked();
		m_Settings->confirmWithTimeout = ui.timeoutCheck->isChecked();
		m_Settings->timeoutValue = ui.timeoutSpin->value();
		
		for (int i = 0; i < INT_COUNT_COLORS; i++)
			m_Settings->colors[i] = colors[i];
		
		m_Settings->oldIconStyle = ui.oldStyleRadio->isChecked();
		
		m_Settings->showChargeLabel = ui.showChargeCheck->isChecked();
		m_Settings->showBalloon = ui.showBalloonCheck->isChecked();
		m_Settings->pollingRate = ui.pollingRateSpin->value();
	}
	
	bool CSettingsDialog::execute(Settings * settings) {
		ui.criticalGroup->setChecked(settings->handleCritical);
		ui.criticalCapacitySpin->setValue(settings->criticalCapacity);
		
		if (settings->executeCommand)
			ui.criticalCommandRadio->setChecked(true);
		else
			ui.criticalWarningRadio->setChecked(true);
		
		ui.criticalCommandEdit->setText(settings->criticalCommand);
		ui.confirmCommandGroup->setChecked(settings->confirmCommand);
		ui.timeoutCheck->setChecked(settings->confirmWithTimeout);
		ui.timeoutSpin->setValue(settings->timeoutValue);
		
		ui.showChargeCheck->setChecked(settings->showChargeLabel);
		
		if (settings->oldIconStyle)
			ui.oldStyleRadio->setChecked(true);
		else
			ui.cleanStyleRadio->setChecked(true);
		
		{
			QPixmap colorIcon(24, 24);
			
			for (int i = 0; i < INT_COUNT_COLORS; i++) {
				colorIcon.fill(settings->colors[i]);
				colorSelectButtons.button(i+1)->setIcon(colorIcon);
				colors[i] = settings->colors[i];
			}
		}
		
		ui.pollingRateSpin->setValue(settings->pollingRate);
		ui.showBalloonCheck->setChecked(settings->showBalloon);
		
		m_Settings = settings;
		
		if (exec()) {
			applySettings();
			return true;
		}
		else
			return false;
	}
	
	void CSettingsDialog::editColor(int id) {
		QColor color = QColorDialog::getColor(QColor(colors[id-1]), this);
		if (color.isValid()) {
			QPixmap colorIcon(24, 24);
			colorIcon.fill(color);
			
			colorSelectButtons.button(id)->setIcon(QIcon(colorIcon));
			colors[id-1] = color.rgb();
		}
	}
}
