#ifndef QBAT_CONSTANTS_H
#define QBAT_CONSTANTS_H

#define STRING_VERSION                  "0.3 beta"
#define STRING_FULLNAME                 tr("QBat - Qt Battery Monitor")

#define STRING_APPNAME                  "qbat"
#define STRING_ORGANIZATION             "Inphosoft"

#define DIR_WORK                        ".qbat/"

#define PATH_SYSFS_DIR                  "/sys/class/power_supply"
#define PATH_TRANSLATIONS               "/usr/share/qbat/lang/"
#define PATH_ICONS                      "/usr/share/qbat/icons/"
#define PATH_WORK                       (QDir::toNativeSeparators(QDir::homePath()) + "/" DIR_WORK)

#define CAPTION_ENERGY                  "/energy"
#define CAPTION_CHARGE                  "/charge"
#define CAPTION_VOLTAGE                 "/voltage"
#define CAPTION_NOW(a)                  a + "_now"
#define CAPTION_FULL(a)                 a + "_full"
#define CAPTION_DESIGN(a)               CAPTION_FULL(a) + "_design"

#define PATH_ICON_QBAT                  PATH_ICONS "qbat3.svg"
#define PATH_ICON_QBAT_MONO             PATH_ICONS "qbat3_mono.svg"
#define PATH_ICON_BATTERY               PATH_ICONS "battery.png"

#define INT_CHARGE_WIDTH                12
#define INT_CHARGE_HEIGHT               14
#define INT_CHARGE_XOFFSET              5
#define INT_CHARGE_YOFFSET              5

#define STATE_BATTERY_CHARGING          1
#define STATE_BATTERY_DISCHARGING       2
#define STATE_BATTERY_FULL              3

#define INT_COUNT_COLORS                 11

#define INT_COLOR_BRUSH_MAIN              0
#define INT_COLOR_BRUSH_CHARGING          1
#define INT_COLOR_BRUSH_DISCHARGING       2
#define INT_COLOR_BRUSH_FULL              3

#define INT_COLOR_BRUSH_LABEL             4

#define INT_COLOR_PEN_CHARGING            5
#define INT_COLOR_PEN_DISCHARGING         6
#define INT_COLOR_PEN_FULL                7

#define INT_COLOR_BRUSH_POLE_CHARGING     8
#define INT_COLOR_BRUSH_POLE_DISCHARGING  9
#define INT_COLOR_BRUSH_POLE_FULL        10

#define INT_COLOR_BRUSH_BASE            INT_COLOR_BRUSH_CHARGING - STATE_BATTERY_CHARGING
#define INT_COLOR_PEN_BASE              INT_COLOR_PEN_CHARGING - STATE_BATTERY_CHARGING
#define INT_COLOR_BRUSH_POLE_BASE       INT_COLOR_BRUSH_POLE_CHARGING - STATE_BATTERY_CHARGING


#define STRING_SETTINGS_VALUE           "value"

#define STRING_SETTINGS_GRP_MAIN        "Main"
#define STRING_SETTINGS_POLLINGRATE     "pollingRate"
#define STRING_SETTINGS_UPDATERATE      "dataUpdateRate"
#define STRING_SETTINGS_SHOWBALLOON     "showBalloon"

#define STRING_SETTINGS_GRP_ICONS       "TrayIcons"
#define STRING_SETTINGS_OLDSTYLE        "oldStyle"
#define STRING_SETTINGS_SHOWLABEL       "showChargeLabel"
#define STRING_SETTINGS_COLORS          "colors"
#define STRING_SETTINGS_OLD_COLORS      "oldColors"

#define STRING_SETTINGS_GRP_CRITICAL    "CriticalEvent"
#define STRING_SETTINGS_HANDLE          "handle"
#define STRING_SETTINGS_CRITICALCAP     "criticalCapacity"
#define STRING_SETTINGS_EXECCOMMAND     "executeCommand"
#define STRING_SETTINGS_COMMAND         "command"
#define STRING_SETTINGS_CONFIRMCOMMAND  "confirmCommand"
#define STRING_SETTINGS_CONFIRMTIMEOUT  "confirmWithTimeout"
#define STRING_SETTINGS_TIMEOUTVALUE    "timeoutValue"

#endif
