//
// C++ Interface: common
//
// Author: Oliver Groß <z.o.gross@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
#ifndef QBAT_COMMON_H
#define QBAT_COMMON_H

#include <QString>
#include <QColor>
#include "constants.h"

#define BUF_SIZE 256

namespace qbat {
	struct Settings {
		quint16 pollingRate;
		bool handleCritical;
		quint8 criticalCapacity;
		bool executeCommand;
		QString criticalCommand;
		bool confirmCommand;
		bool confirmWithTimeout;
		quint16 timeoutValue;
		bool showBalloon;
		bool oldIconStyle;
		bool showChargeLabel;
		QRgb colors[INT_COUNT_COLORS];
		
		Settings() :
			pollingRate(3000),
			handleCritical(true),
			criticalCapacity(7),
			executeCommand(false),
			confirmCommand(true),
			confirmWithTimeout(true),
			timeoutValue(10),
			showBalloon(true),
			oldIconStyle(false),
			showChargeLabel(false)
		{
			colors[INT_COLOR_BRUSH_MAIN] = qRgb(255, 255, 255);
			
			colors[INT_COLOR_BRUSH_CHARGING] = qRgb(255, 255, 0);
			colors[INT_COLOR_BRUSH_DISCHARGING] = qRgb(0, 255, 0);
			colors[INT_COLOR_BRUSH_FULL] = qRgb(100, 100, 255);
			
			colors[INT_COLOR_BRUSH_LABEL] = qRgb(255, 255, 255);
			
			colors[INT_COLOR_PEN_CHARGING] = 0;
			colors[INT_COLOR_PEN_DISCHARGING] = 0;
			colors[INT_COLOR_PEN_FULL] = 0;
			
			colors[INT_COLOR_BRUSH_POLE_CHARGING] = qRgb(255, 0, 0);
			colors[INT_COLOR_BRUSH_POLE_DISCHARGING] = qRgb(255, 255, 0);
			colors[INT_COLOR_BRUSH_POLE_FULL] = qRgb(0, 255, 0);
		}
	};
	
	bool readStringFromFile(char * buffer, const char * fileName);
	int readIntSysFile(const char * fileName, int def = 0);
	int toStatusInt(const char * status);
	
	inline int calcRelativeDef(int value, int border, qint8 defValue = -1) {
		return border ? (100.0 * value / border) : defValue;
	}
}

#endif
